/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.hibernate.search.elasticsearch.settings.impl.ParameterValueTransformer;
import org.hibernate.search.exception.SearchException;

abstract class FileAsLineArrayParameterValueTransformer
implements ParameterValueTransformer {
    private static final Pattern FILE_PATH_SEPARATOR_PATTERN = Pattern.compile("[\\s,]+");
    private final ResourceLoader resourceLoader;

    public FileAsLineArrayParameterValueTransformer(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public JsonElement transform(String parameterValue) {
        JsonArray array = new JsonArray();
        for (String filePath : FILE_PATH_SEPARATOR_PATTERN.split(parameterValue)) {
            try (InputStream stream = this.resourceLoader.openResource(filePath);){
                List<String> lines = this.getLines(stream);
                for (String line : lines) {
                    array.add((JsonElement)new JsonPrimitive(line));
                }
            }
            catch (IOException | SearchException e) {
                throw new SearchException("Could not parse file: " + parameterValue, e);
            }
        }
        return array;
    }

    protected abstract List<String> getLines(InputStream var1) throws IOException;

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

