/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.search.elasticsearch.util.impl.gson.AbstractExtraPropertiesJsonAdapter;
import org.hibernate.search.elasticsearch.util.impl.gson.SerializeExtraProperties;
import org.hibernate.search.exception.AssertionFailure;

public abstract class AbstractConfiguredExtraPropertiesJsonAdapterFactory
implements TypeAdapterFactory {
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Builder builder = new Builder(gson, type);
        this.addFields(builder);
        return builder.build();
    }

    protected abstract <T> void addFields(Builder<T> var1);

    private static Field getField(TypeToken<?> type, String fieldName) {
        for (Class rawType = type.getRawType(); rawType != null; rawType = rawType.getSuperclass()) {
            try {
                Field field = rawType.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new AssertionFailure("Missing or inaccessible field " + fieldName + " on type " + type);
    }

    private static <T> AbstractExtraPropertiesJsonAdapter.ExtraPropertyAdapter<T> getExtraPropertyAdapter(Gson gson, TypeToken<T> type) {
        for (Class rawType = type.getRawType(); rawType != null; rawType = rawType.getSuperclass()) {
            for (Field field : rawType.getDeclaredFields()) {
                SerializeExtraProperties annotation = field.getAnnotation(SerializeExtraProperties.class);
                if (annotation == null) continue;
                field.setAccessible(true);
                return new ReflectiveExtraPropertyAdapter(field, gson);
            }
        }
        throw new AssertionFailure("Missing or inaccessible field annotated with " + SerializeExtraProperties.class + " on type " + type);
    }

    private static <T> Constructor<T> getConstructor(TypeToken<T> type) {
        try {
            return type.getRawType().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionFailure("Missing or inaccessible no-arg constructor on type " + type);
        }
    }

    private static List<String> getFieldNames(Field f) {
        SerializedName serializedName = f.getAnnotation(SerializedName.class);
        LinkedList<String> fieldNames = new LinkedList<String>();
        if (serializedName == null) {
            fieldNames.add(f.getName());
        } else {
            fieldNames.add(serializedName.value());
            for (String alternate : serializedName.alternate()) {
                fieldNames.add(alternate);
            }
        }
        return fieldNames;
    }

    private static class Adapter<T>
    extends AbstractExtraPropertiesJsonAdapter<T> {
        private final Constructor<T> constructor;

        public Adapter(Map<String, ? extends AbstractExtraPropertiesJsonAdapter.FieldAdapter<? super T>> fieldAdapters, AbstractExtraPropertiesJsonAdapter.ExtraPropertyAdapter<? super T> extraPropertyAdapter, Constructor<T> constructor) {
            super(fieldAdapters, extraPropertyAdapter);
            this.constructor = constructor;
        }

        @Override
        protected T createInstance() {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new AssertionFailure("Constructor " + this.constructor + " is not accessible.", (Throwable)e);
            }
        }
    }

    private static class ReflectiveFieldAdapter<T, F>
    implements AbstractExtraPropertiesJsonAdapter.FieldAdapter<T> {
        private final Field field;
        private final TypeAdapter<F> typeAdapter;
        private final boolean serialized;

        public ReflectiveFieldAdapter(Field field, TypeAdapter<F> typeAdapter, boolean serialized) {
            this.field = field;
            this.typeAdapter = typeAdapter;
            this.serialized = serialized;
        }

        @Override
        public void read(JsonReader in, T instance) throws IOException {
            try {
                this.field.set(instance, this.typeAdapter.read(in));
            }
            catch (IllegalAccessException e) {
                throw new AssertionFailure("Field " + this.field + " is not accessible.", (Throwable)e);
            }
        }

        @Override
        public boolean serialized() {
            return this.serialized;
        }

        @Override
        public void write(JsonWriter out, T instance) throws IOException {
            if (!this.serialized) {
                throw new AssertionFailure("The property with this name should not be serialized");
            }
            try {
                this.typeAdapter.write(out, this.field.get(instance));
            }
            catch (IllegalAccessException e) {
                throw new AssertionFailure("Field " + this.field + " is not accessible.", (Throwable)e);
            }
        }
    }

    private static class ReflectiveExtraPropertyAdapter<T, F>
    implements AbstractExtraPropertiesJsonAdapter.ExtraPropertyAdapter<T> {
        private final Field extraPropertiesField;
        private final TypeAdapter<JsonElement> propertyValueAdapter;

        public ReflectiveExtraPropertyAdapter(Field extraPropertiesField, Gson gson) {
            this.extraPropertiesField = extraPropertiesField;
            this.propertyValueAdapter = gson.getAdapter(JsonElement.class);
        }

        @Override
        public void readOne(JsonReader in, String name, T instance) throws IOException {
            JsonElement propertyValue = (JsonElement)this.propertyValueAdapter.read(in);
            Map<String, JsonElement> extraProperties = this.getExtraProperties(instance);
            if (extraProperties == null) {
                extraProperties = new LinkedHashMap<String, JsonElement>();
                this.setExtraProperties(instance, extraProperties);
            }
            extraProperties.put(name, propertyValue);
        }

        @Override
        public void writeAll(JsonWriter out, T instance) throws IOException {
            Map<String, JsonElement> extraProperties = this.getExtraProperties(instance);
            if (extraProperties == null) {
                return;
            }
            for (Map.Entry<String, JsonElement> entry : extraProperties.entrySet()) {
                out.name(entry.getKey());
                this.propertyValueAdapter.write(out, (Object)entry.getValue());
            }
        }

        private void setExtraProperties(T instance, Map<String, JsonElement> extraProperties) {
            try {
                this.extraPropertiesField.set(instance, extraProperties);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionFailure("Field " + this.extraPropertiesField + " annotated with " + SerializeExtraProperties.class + " has the wrong type on " + instance.getClass());
            }
            catch (IllegalAccessException e) {
                throw new AssertionFailure("Field " + this.extraPropertiesField + " annotated with " + SerializeExtraProperties.class + " is inaccessible on " + instance.getClass());
            }
        }

        private Map<String, JsonElement> getExtraProperties(T instance) {
            try {
                return (Map)this.extraPropertiesField.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new AssertionFailure("Field " + this.extraPropertiesField + " annotated with " + SerializeExtraProperties.class + " is inaccessible on " + instance.getClass());
            }
        }
    }

    protected static final class Builder<T> {
        private final Gson gson;
        private final TypeToken<T> type;
        private final Map<String, AbstractExtraPropertiesJsonAdapter.FieldAdapter<? super T>> fieldAdapters = new LinkedHashMap<String, AbstractExtraPropertiesJsonAdapter.FieldAdapter<? super T>>();

        private Builder(Gson gson, TypeToken<T> type) {
            this.gson = gson;
            this.type = type;
        }

        public <F> Builder<T> add(String fieldName, Class<F> fieldType) {
            return this.add(fieldName, TypeToken.get(fieldType));
        }

        public <F> Builder<T> add(String fieldName, TypeToken<F> fieldType) {
            Field field = AbstractConfiguredExtraPropertiesJsonAdapterFactory.getField(this.type, fieldName);
            TypeAdapter adapter = this.gson.getAdapter(fieldType);
            boolean first = true;
            for (String name : AbstractConfiguredExtraPropertiesJsonAdapterFactory.getFieldNames(field)) {
                boolean serialized = first;
                this.fieldAdapters.put(name, new ReflectiveFieldAdapter(field, adapter, serialized));
                first = false;
            }
            return this;
        }

        private TypeAdapter<T> build() {
            return new Adapter<T>(this.fieldAdapters, AbstractConfiguredExtraPropertiesJsonAdapterFactory.getExtraPropertyAdapter(this.gson, this.type), AbstractConfiguredExtraPropertiesJsonAdapterFactory.getConstructor(this.type));
        }
    }
}

