/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.batchindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IdentifierProducer
implements StatelessSessionAwareRunnable {
    private static final Log log = LoggerFactory.make();
    private final ProducerConsumerQueue<List<Serializable>> destination;
    private final SessionFactory sessionFactory;
    private final int batchSize;
    private final Class<?> indexedType;
    private final MassIndexerProgressMonitor monitor;
    private final long objectsLimit;
    private final int idFetchSize;
    private final ErrorHandler errorHandler;
    private final String tenantId;

    public IdentifierProducer(ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities, SessionFactory sessionFactory, int objectLoadingBatchSize, Class<?> indexedType, MassIndexerProgressMonitor monitor, long objectsLimit, ErrorHandler errorHandler, int idFetchSize, String tenantId) {
        this.destination = fromIdentifierListToEntities;
        this.sessionFactory = sessionFactory;
        this.batchSize = objectLoadingBatchSize;
        this.indexedType = indexedType;
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
        this.errorHandler = errorHandler;
        this.idFetchSize = idFetchSize;
        this.tenantId = tenantId;
        log.trace((Object)"created");
    }

    @Override
    public void run(StatelessSession upperSession) throws Exception {
        log.trace((Object)"started");
        try {
            this.inTransactionWrapper(upperSession);
        }
        catch (Exception exception) {
            this.errorHandler.handleException(log.massIndexerExceptionWhileFetchingIds(), (Throwable)exception);
        }
        finally {
            this.destination.producerStopping();
        }
        log.trace((Object)"finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inTransactionWrapper(StatelessSession upperSession) throws Exception {
        StatelessSession session = upperSession;
        if (upperSession == null) {
            session = this.tenantId == null ? this.sessionFactory.openStatelessSession() : this.sessionFactory.withStatelessOptions().tenantIdentifier(this.tenantId).openStatelessSession();
        }
        try {
            Transaction transaction = session.getTransaction();
            transaction.begin();
            this.loadAllIdentifiers(session);
            transaction.commit();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (upperSession == null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllIdentifiers(StatelessSession session) throws InterruptedException {
        Number countAsNumber = (Number)session.createCriteria(this.indexedType).setProjection(Projections.rowCount()).setCacheable(false).uniqueResult();
        long totalCount = countAsNumber.longValue();
        if (this.objectsLimit != 0L && this.objectsLimit < totalCount) {
            totalCount = this.objectsLimit;
        }
        if (log.isDebugEnabled()) {
            log.debugf("going to fetch %d primary keys", (Object)totalCount);
        }
        this.monitor.addToTotalCount(totalCount);
        Criteria criteria = session.createCriteria(this.indexedType).setProjection((Projection)Projections.id()).setCacheable(false).setFetchSize(this.idFetchSize);
        ScrollableResults results = criteria.scroll(ScrollMode.FORWARD_ONLY);
        ArrayList<Serializable> destinationList = new ArrayList<Serializable>(this.batchSize);
        long counter = 0L;
        try {
            while (results.next()) {
                Serializable id = (Serializable)results.get(0);
                destinationList.add(id);
                if (destinationList.size() == this.batchSize) {
                    if (session.getTransaction().getStatus() != TransactionStatus.ACTIVE) {
                        throw log.transactionNotActiveWhileProducingIdsForBatchIndexing(this.indexedType);
                    }
                    this.enqueueList(destinationList);
                    destinationList = new ArrayList(this.batchSize);
                }
                if (++counter != totalCount) continue;
                break;
            }
        }
        finally {
            results.close();
        }
        this.enqueueList(destinationList);
    }

    private void enqueueList(List<Serializable> idsList) throws InterruptedException {
        if (!idsList.isEmpty()) {
            this.destination.put(idsList);
            log.tracef("produced a list of ids %s", idsList);
        }
    }
}

