/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.impl;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.DateResolutionUtil;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchDateHelper;

public class ElasticsearchDateBridge
implements TwoWayFieldBridge,
ParameterizedBridge,
IgnoreAnalyzerBridge {
    public static final ElasticsearchDateBridge DATE_YEAR = new ElasticsearchDateBridge(Resolution.YEAR);
    public static final ElasticsearchDateBridge DATE_MONTH = new ElasticsearchDateBridge(Resolution.MONTH);
    public static final ElasticsearchDateBridge DATE_DAY = new ElasticsearchDateBridge(Resolution.DAY);
    public static final ElasticsearchDateBridge DATE_HOUR = new ElasticsearchDateBridge(Resolution.HOUR);
    public static final ElasticsearchDateBridge DATE_MINUTE = new ElasticsearchDateBridge(Resolution.MINUTE);
    public static final ElasticsearchDateBridge DATE_SECOND = new ElasticsearchDateBridge(Resolution.SECOND);
    public static final ElasticsearchDateBridge DATE_MILLISECOND = new ElasticsearchDateBridge(Resolution.MILLISECOND);
    private DateTools.Resolution resolution;

    public ElasticsearchDateBridge() {
        this(Resolution.MILLISECOND);
    }

    public ElasticsearchDateBridge(Resolution resolution) {
        this.resolution = DateResolutionUtil.getLuceneResolution((Resolution)resolution);
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            return;
        }
        luceneOptions.addFieldToDocument(name, this.convertToString((Date)value), document);
    }

    public Object get(String name, Document document) {
        return ElasticsearchDateHelper.stringToDate(document.get(name));
    }

    public String objectToString(Object object) {
        return this.convertToString((Date)object);
    }

    private String convertToString(Date value) {
        return ElasticsearchDateHelper.dateToString(DateTools.round((Date)value, (DateTools.Resolution)this.resolution));
    }

    public void setParameterValues(Map<String, String> parameters) {
        String resolution = parameters.get("resolution");
        Resolution hibResolution = Resolution.valueOf((String)resolution.toUpperCase(Locale.ENGLISH));
        this.resolution = DateResolutionUtil.getLuceneResolution((Resolution)hibResolution);
    }
}

