/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchYearMonthBridge;

public class ElasticsearchLocalDateBridge
extends ElasticsearchTemporalAccessorStringBridge<LocalDate> {
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchYearMonthBridge.FORMATTER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchLocalDateBridge INSTANCE = new ElasticsearchLocalDateBridge();

    private ElasticsearchLocalDateBridge() {
        super(FORMATTER, LocalDate.class);
    }

    @Override
    LocalDate parse(DateTimeFormatter formatter, String stringValue) throws DateTimeParseException {
        return LocalDate.parse(stringValue, formatter);
    }
}

