/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.elasticsearch.schema.impl.ValidationContext;
import org.hibernate.search.util.StringHelper;

final class ValidationErrorCollector {
    private String indexName;
    private String mappingName;
    private final Deque<String> currentPath = new ArrayDeque<String>();
    private String fieldName;
    private final Map<ValidationContext, List<String>> messagesByContext = new LinkedHashMap<ValidationContext, List<String>>();

    ValidationErrorCollector() {
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setMappingName(String mappingName) {
        this.mappingName = mappingName;
    }

    public void pushPropertyName(String propertyName) {
        this.currentPath.addLast(propertyName);
    }

    public void popPropertyName() {
        this.currentPath.removeLast();
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void addError(String errorMessage) {
        ValidationContext context = this.createContext();
        List<String> messages = this.messagesByContext.get(context);
        if (messages == null) {
            messages = new ArrayList<String>();
            this.messagesByContext.put(context, messages);
        }
        messages.add(errorMessage);
    }

    private ValidationContext createContext() {
        return new ValidationContext(this.indexName, this.mappingName, StringHelper.join(this.currentPath, (String)"."), this.fieldName);
    }

    public Map<ValidationContext, List<String>> getMessagesByContext() {
        return this.messagesByContext;
    }
}

