/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchAnalyzerReference
extends RemoteAnalyzerReference {
    private static final Log LOG = LoggerFactory.make();
    private final String name;
    private ElasticsearchAnalyzer analyzer;

    public ElasticsearchAnalyzerReference(String name) {
        this.name = name;
        this.analyzer = null;
    }

    public ElasticsearchAnalyzerReference(ElasticsearchAnalyzer analyzer) {
        this.name = null;
        this.analyzer = analyzer;
    }

    public String getAnalyzerName() {
        return this.name;
    }

    public ElasticsearchAnalyzer getAnalyzer() {
        if (this.analyzer == null) {
            throw LOG.lazyRemoteAnalyzerReferenceNotInitialized((RemoteAnalyzerReference)this);
        }
        return this.analyzer;
    }

    public boolean isInitialized() {
        return this.analyzer != null;
    }

    public void initialize(ElasticsearchAnalyzer analyzer) {
        if (this.analyzer != null) {
            throw new AssertionFailure("An analyzer reference has been initialized more than once: " + (Object)((Object)this));
        }
        this.analyzer = analyzer;
    }

    public void close() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
    }

    public <T extends AnalyzerReference> boolean is(Class<T> analyzerType) {
        return analyzerType.isAssignableFrom(ElasticsearchAnalyzerReference.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append("<");
        if (this.analyzer != null) {
            sb.append(this.analyzer);
        } else {
            sb.append(this.name);
        }
        sb.append(">");
        return sb.toString();
    }
}

