/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import com.google.gson.JsonElement;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.action.DocumentTargetedAction;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.impl.GsonService;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JestClient
implements Service,
Startable,
Stoppable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final int TIME_OUT = 408;
    private static final String CLIENT_PROP_PREFIX = "hibernate.search.default.";
    private io.searchbox.client.JestClient client;
    private ServiceManager serviceManager;
    private GsonService gsonService;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.gsonService = (GsonService)this.serviceManager.requestService(GsonService.class);
        JestClientFactory factory = new JestClientFactory();
        String serverUrisString = ConfigurationParseHelper.getString((Properties)properties, (String)"hibernate.search.default.elasticsearch.host", (String)"http://localhost:9200");
        List<String> serverUris = Arrays.asList(serverUrisString.trim().split("\\s"));
        factory.setHttpClientConfig(((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(serverUris).multiThreaded(true)).readTimeout(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.read_timeout", (int)60000))).connTimeout(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.connection_timeout", (int)3000))).maxTotalConnection(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.max_total_connection", (int)20)).defaultMaxTotalConnectionPerRoute(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.max_total_connection_per_route", (int)2)).discoveryEnabled(ConfigurationParseHelper.getBooleanValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.discovery.enabled", (boolean)false))).discoveryFrequency(ConfigurationParseHelper.getLongValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.discovery.refresh_interval", (long)10L), TimeUnit.SECONDS)).gson(this.gsonService.getGson())).build());
        this.client = factory.getObject();
    }

    public void stop() {
        this.client.shutdownClient();
        this.client = null;
        this.gsonService = null;
        this.serviceManager.releaseService(GsonService.class);
        this.serviceManager = null;
    }

    public <T extends JestResult> T executeRequest(Action<T> request) {
        return this.executeRequest(request, Collections.emptySet(), Collections.emptySet());
    }

    public <T extends JestResult> T executeRequest(Action<T> request, int ... ignoredErrorStatuses) {
        return this.executeRequest(request, this.asSet(ignoredErrorStatuses));
    }

    public <T extends JestResult> T executeRequest(Action<T> request, String ... ignoredErrorTypes) {
        return this.executeRequest(request, Collections.emptySet(), CollectionHelper.asImmutableSet((String[])ignoredErrorTypes));
    }

    public <T extends JestResult> T executeRequest(Action<T> request, Set<Integer> ignoredErrorStatuses) {
        return this.executeRequest(request, ignoredErrorStatuses, Collections.emptySet());
    }

    public <T extends JestResult> T executeRequest(Action<T> request, Set<Integer> ignoredErrorStatuses, Set<String> ignoredErrorTypes) {
        try {
            JestResult result = this.client.execute(request);
            if (!(result.isSucceeded() || this.isResponseCode(result.getResponseCode(), ignoredErrorStatuses) || this.isErrorType(result, ignoredErrorTypes))) {
                if (result.getResponseCode() == 408) {
                    throw LOG.elasticsearchRequestTimeout(this.requestToString(request), this.resultToString(result));
                }
                throw LOG.elasticsearchRequestFailed(this.requestToString(request), this.resultToString(result), null);
            }
            return (T)result;
        }
        catch (IOException e) {
            throw LOG.elasticsearchRequestFailed(this.requestToString(request), null, e);
        }
    }

    public Map<BackendRequest<?>, BulkResult.BulkResultItem> executeBulkRequest(List<BackendRequest<?>> backendRequests, boolean refresh) {
        Bulk.Builder bulkBuilder = (Bulk.Builder)new Bulk.Builder().setParameter("refresh", (Object)refresh);
        for (BackendRequest<?> backendRequest : backendRequests) {
            bulkBuilder.addAction((BulkableAction)backendRequest.getAction());
        }
        Bulk request = bulkBuilder.build();
        try {
            BulkResult response = (BulkResult)this.client.execute((Action)request);
            HashMap successfulItems = CollectionHelper.newHashMap((int)backendRequests.size());
            ArrayList<BackendRequest<? extends JestResult>> erroneousItems = new ArrayList<BackendRequest<? extends JestResult>>();
            int i = 0;
            for (BulkResult.BulkResultItem resultItem : response.getItems()) {
                BackendRequest<?> backendRequest = backendRequests.get(i);
                if (this.isErrored(backendRequest, resultItem)) {
                    erroneousItems.add(backendRequest);
                } else {
                    successfulItems.put(backendRequest, resultItem);
                }
                ++i;
            }
            if (!erroneousItems.isEmpty()) {
                throw LOG.elasticsearchBulkRequestFailed(this.requestToString((Action<?>)request), this.resultToString((JestResult)response), successfulItems, erroneousItems);
            }
            return successfulItems;
        }
        catch (IOException e) {
            throw LOG.elasticsearchRequestFailed(this.requestToString((Action<?>)request), null, e);
        }
    }

    private boolean isErrored(BackendRequest<?> backendRequest, BulkResult.BulkResultItem resultItem) {
        return (resultItem.error != null || resultItem.status >= 400) && !this.isResponseCode(resultItem.status, backendRequest.getIgnoredErrorStatuses());
    }

    private boolean isResponseCode(int responseCode, Set<Integer> codes) {
        if (codes == null) {
            return false;
        }
        return codes.contains(responseCode);
    }

    private boolean isErrorType(JestResult result, Set<String> errorTypes) {
        if (errorTypes == null) {
            return false;
        }
        return errorTypes.contains(this.getErrorType(result));
    }

    private String getErrorType(JestResult result) {
        JsonElement error = result.getJsonObject().get("error");
        if (error == null || !error.isJsonObject()) {
            return null;
        }
        JsonElement errorType = error.getAsJsonObject().get("type");
        if (errorType == null || !errorType.isJsonPrimitive()) {
            return null;
        }
        return errorType.getAsString();
    }

    private Set<Integer> asSet(int ... ignoredErrorStatuses) {
        Set<Integer> ignored;
        if (ignoredErrorStatuses == null || ignoredErrorStatuses.length == 0) {
            ignored = Collections.emptySet();
        } else if (ignoredErrorStatuses.length == 1) {
            ignored = Collections.singleton(ignoredErrorStatuses[0]);
        } else {
            ignored = new HashSet<Integer>();
            for (int ignoredErrorStatus : ignoredErrorStatuses) {
                ignored.add(ignoredErrorStatus);
            }
        }
        return ignored;
    }

    private String requestToString(Action<?> action) {
        StringBuilder sb = new StringBuilder();
        sb.append("Operation: ").append(action.getClass().getSimpleName()).append("\n");
        sb.append("URI:").append(action.getURI()).append("\n");
        if (action instanceof DocumentTargetedAction) {
            sb.append("Index: ").append(((DocumentTargetedAction)action).getIndex()).append("\n");
            sb.append("Type: ").append(((DocumentTargetedAction)action).getType()).append("\n");
            sb.append("Id: ").append(((DocumentTargetedAction)action).getId()).append("\n");
        }
        sb.append("Data:\n");
        sb.append(action.getData(this.gsonService.getGson()));
        sb.append("\n");
        return sb.toString();
    }

    private String resultToString(JestResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Status: ").append(result.getResponseCode()).append("\n");
        sb.append("Error message: ").append(result.getErrorMessage()).append("\n");
        sb.append("Cluster name: ").append(this.property(result, "cluster_name")).append("\n");
        sb.append("Cluster status: ").append(this.property(result, "status")).append("\n");
        sb.append("\n");
        if (result instanceof BulkResult) {
            for (BulkResult.BulkResultItem item : ((BulkResult)result).getItems()) {
                sb.append("Operation: ").append(item.operation).append("\n");
                sb.append("  Index: ").append(item.index).append("\n");
                sb.append("  Type: ").append(item.type).append("\n");
                sb.append("  Id: ").append(item.id).append("\n");
                sb.append("  Status: ").append(item.status).append("\n");
                sb.append("  Error: ").append(item.error).append("\n");
            }
        }
        return sb.toString();
    }

    private String property(JestResult result, String name) {
        if (result.getJsonObject() == null) {
            return null;
        }
        JsonElement clusterName = result.getJsonObject().get(name);
        if (clusterName == null) {
            return null;
        }
        return clusterName.getAsString();
    }
}

