/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.ScopedLuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ScopedLuceneAnalyzer
extends AnalyzerWrapper
implements ScopedAnalyzer {
    private static final Log log = LoggerFactory.make();
    private final LuceneAnalyzerReference globalAnalyzerReference;
    private final Map<String, LuceneAnalyzerReference> scopedAnalyzers = new HashMap<String, LuceneAnalyzerReference>();

    public ScopedLuceneAnalyzer(Analyzer globalAnalyzer) {
        this(new LuceneAnalyzerReference(globalAnalyzer));
    }

    public ScopedLuceneAnalyzer(LuceneAnalyzerReference globalAnalyzerReference) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.globalAnalyzerReference = globalAnalyzerReference;
    }

    public ScopedLuceneAnalyzer(Builder builder) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.globalAnalyzerReference = builder.globalAnalyzerReference;
        this.scopedAnalyzers.putAll(builder.scopedAnalyzers);
    }

    public boolean isCompositeOfSameInstances(ScopedLuceneAnalyzer other) {
        if (this.globalAnalyzerReference.getAnalyzer() != other.globalAnalyzerReference.getAnalyzer()) {
            return false;
        }
        if (this.scopedAnalyzers.size() != other.scopedAnalyzers.size()) {
            return false;
        }
        for (String fieldname : this.scopedAnalyzers.keySet()) {
            if (this.scopedAnalyzers.get(fieldname) == other.scopedAnalyzers.get(fieldname)) continue;
            return false;
        }
        return true;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        LuceneAnalyzerReference analyzerReference = this.scopedAnalyzers.get(fieldName);
        if (analyzerReference == null) {
            analyzerReference = this.globalAnalyzerReference;
        }
        return analyzerReference.getAnalyzer();
    }

    @Override
    public Builder startCopy() {
        return new Builder(this.globalAnalyzerReference, this.scopedAnalyzers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.globalAnalyzerReference);
        sb.append(",");
        sb.append(this.scopedAnalyzers);
        sb.append(">");
        return sb.toString();
    }

    private static LuceneAnalyzerReference getLuceneAnalyzerReference(AnalyzerReference analyzerReference) {
        if (!analyzerReference.is(LuceneAnalyzerReference.class)) {
            throw log.analyzerReferenceIsNotLucene(analyzerReference);
        }
        return analyzerReference.unwrap(LuceneAnalyzerReference.class);
    }

    public static class Builder
    implements ScopedAnalyzer.Builder {
        private LuceneAnalyzerReference globalAnalyzerReference;
        private final Map<String, LuceneAnalyzerReference> scopedAnalyzers = new HashMap<String, LuceneAnalyzerReference>();

        public Builder(LuceneAnalyzerReference globalAnalyzerReference, Map<String, LuceneAnalyzerReference> scopedAnalyzers) {
            this.globalAnalyzerReference = globalAnalyzerReference;
            this.scopedAnalyzers.putAll(scopedAnalyzers);
        }

        @Override
        public LuceneAnalyzerReference getGlobalAnalyzerReference() {
            return this.globalAnalyzerReference;
        }

        @Override
        public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
            this.globalAnalyzerReference = ScopedLuceneAnalyzer.getLuceneAnalyzerReference(globalAnalyzerReference);
        }

        @Override
        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.scopedAnalyzers.put(scope, ScopedLuceneAnalyzer.getLuceneAnalyzerReference(analyzerReference));
        }

        @Override
        public ScopedLuceneAnalyzerReference build() {
            ScopedLuceneAnalyzer analyzer = new ScopedLuceneAnalyzer(this);
            return new ScopedLuceneAnalyzerReference(analyzer);
        }
    }
}

