/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.hibernate.annotations.common.reflection.ClassLoadingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.FacetEncodingType;
import org.hibernate.search.annotations.Facets;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Latitude;
import org.hibernate.search.annotations.Longitude;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.NumericFields;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.SortableFields;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.Spatials;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.DefaultStringBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingFieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.impl.BridgeFactory;
import org.hibernate.search.bridge.spi.EncodingBridge;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.BridgeAdaptorUtils;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.bridge.util.impl.ToStringNullMarker;
import org.hibernate.search.bridge.util.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.AnnotationProcessingHelper;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.ContainedInMetadata;
import org.hibernate.search.engine.metadata.impl.ContainedInMetadataBuilder;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.FieldMetadataBuilderImpl;
import org.hibernate.search.engine.metadata.impl.MetadataProvider;
import org.hibernate.search.engine.metadata.impl.NumericFieldsConfiguration;
import org.hibernate.search.engine.metadata.impl.ParseContext;
import org.hibernate.search.engine.metadata.impl.PathsContext;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.nulls.codec.impl.NotEncodingCodec;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AnnotationMetadataProvider
implements MetadataProvider {
    private static final int INFINITE_DEPTH = Integer.MAX_VALUE;
    private static final Log log = LoggerFactory.make();
    private static final org.hibernate.search.bridge.StringBridge NULL_EMBEDDED_STRING_BRIDGE = DefaultStringBridge.INSTANCE;
    private static final String UNKNOWN_MAPPED_BY_ROLE = "";
    private static final String EMPTY_PREFIX = "";
    private final ReflectionManager reflectionManager;
    private final ConfigContext configContext;
    private final BridgeFactory bridgeFactory;
    private final Class<? extends Annotation> jpaIdClass;
    private final Class<? extends Annotation> jpaEmbeddedIdClass;

    public AnnotationMetadataProvider(ReflectionManager reflectionManager, ConfigContext configContext) {
        this.reflectionManager = reflectionManager;
        this.configContext = configContext;
        this.bridgeFactory = new BridgeFactory(configContext.getServiceManager());
        if (configContext.isJpaPresent()) {
            this.jpaIdClass = this.loadAnnotationClass("javax.persistence.Id", configContext);
            this.jpaEmbeddedIdClass = this.loadAnnotationClass("javax.persistence.EmbeddedId", configContext);
        } else {
            this.jpaIdClass = null;
            this.jpaEmbeddedIdClass = null;
        }
    }

    private Class<? extends Annotation> loadAnnotationClass(String className, ConfigContext configContext) {
        try {
            Class idClass = ClassLoaderHelper.classForName(className, configContext.getServiceManager());
            return idClass;
        }
        catch (ClassLoadingException e) {
            throw new SearchException("Unable to load class " + className + " even though it should be present?!");
        }
    }

    @Override
    public TypeMetadata getTypeMetadataForContainedIn(Class<?> clazz) {
        XClass xClass = this.reflectionManager.toXClass(clazz);
        ParseContext parseContext = new ParseContext();
        parseContext.processingClass(xClass);
        parseContext.setCurrentClass(xClass);
        return this.doGetTypeMetadataFor(clazz, xClass, parseContext);
    }

    @Override
    public TypeMetadata getTypeMetadataFor(Class<?> clazz, IndexManagerType indexManagerType) {
        XClass xClass = this.reflectionManager.toXClass(clazz);
        ParseContext parseContext = new ParseContext();
        parseContext.setIndexManagerType(indexManagerType);
        parseContext.processingClass(xClass);
        parseContext.setCurrentClass(xClass);
        return this.doGetTypeMetadataFor(clazz, xClass, parseContext);
    }

    private TypeMetadata doGetTypeMetadataFor(Class<?> clazz, XClass xClass, ParseContext parseContext) {
        TypeMetadata.Builder typeMetadataBuilder = new TypeMetadata.Builder(clazz, this.configContext, parseContext).boost(this.getBoost(xClass)).boostStrategy(AnnotationProcessingHelper.getDynamicBoost((XAnnotatedElement)xClass));
        this.initializePackageLevelAnnotations(this.packageInfo(clazz), this.configContext);
        this.initializeClass(typeMetadataBuilder, true, "", parseContext, this.configContext, false, null);
        return typeMetadataBuilder.build();
    }

    private XPackage packageInfo(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        try {
            return this.reflectionManager.packageForName(packageName);
        }
        catch (ClassNotFoundException | ClassLoadingException e) {
            log.debugf("package-info not found for package '%s'", packageName, clazz);
            return null;
        }
    }

    @Override
    public boolean containsSearchMetadata(Class<?> clazz) {
        XClass xClass = this.reflectionManager.toXClass(clazz);
        return ReflectionHelper.containsSearchAnnotations(xClass);
    }

    private void checkDocumentId(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, NumericFieldsConfiguration numericFields, boolean isRoot, String prefix, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext, boolean hasExplicitDocumentId) {
        Annotation idAnnotation = this.getIdAnnotation(member, typeMetadataBuilder, configContext);
        if (idAnnotation == null) {
            return;
        }
        if (hasExplicitDocumentId && idAnnotation.annotationType() != DocumentId.class) {
            return;
        }
        String relativeFieldName = this.getIdAttributeName(member, idAnnotation);
        DocumentFieldPath fieldPath = new DocumentFieldPath(prefix, relativeFieldName);
        if (isRoot) {
            this.createIdPropertyMetadata(member, typeMetadataBuilder, numericFields, configContext, parseContext, idAnnotation, fieldPath);
        } else if (parseContext.includeEmbeddedObjectId() || pathsContext.isIncluded(fieldPath)) {
            this.createPropertyMetadataForEmbeddedId(member, typeMetadataBuilder, propertyMetadataBuilder, numericFields, configContext, parseContext, fieldPath);
        }
        if (pathsContext != null) {
            pathsContext.markEncounteredPath(fieldPath);
        }
    }

    private void createPropertyMetadataForEmbeddedId(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, NumericFieldsConfiguration numericFields, ConfigContext configContext, ParseContext parseContext, DocumentFieldPath fieldPath) {
        Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.YES);
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(TermVector.NO);
        FieldBridge fieldBridge = parseContext.skipFieldBridges() ? null : this.bridgeFactory.buildFieldBridge((XMember)member, true, numericFields.isNumericField(fieldPath), parseContext.getIndexManagerType(), this.reflectionManager, configContext.getServiceManager());
        DocumentFieldMetadata.Builder fieldMetadataBuilder = new DocumentFieldMetadata.Builder(typeMetadataBuilder.getResultReference(), propertyMetadataBuilder.getResultReference(), fieldPath, Store.YES, index, termVector).boost(AnnotationProcessingHelper.getBoost(member, null)).fieldBridge(fieldBridge).idInEmbedded();
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = this.determineNumericFieldEncoding(fieldBridge);
        if (numericEncodingType != NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN) {
            fieldMetadataBuilder.numeric();
            fieldMetadataBuilder.numericEncodingType(numericEncodingType);
        }
        DocumentFieldMetadata fieldMetadata = fieldMetadataBuilder.build();
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        if (!parseContext.skipAnalyzers()) {
            AnalyzerReference analyzerReference = AnnotationProcessingHelper.getAnalyzerReference((Analyzer)member.getAnnotation(Analyzer.class), configContext, parseContext.getIndexManagerType());
            if (analyzerReference == null) {
                analyzerReference = typeMetadataBuilder.getAnalyzerReference();
            }
            if (analyzerReference == null) {
                throw new AssertionFailure("Analyzer should not be undefined");
            }
            typeMetadataBuilder.addToScopedAnalyzerReference(fieldPath, analyzerReference, index);
        }
    }

    private void createIdPropertyMetadata(XProperty member, TypeMetadata.Builder typeMetadataBuilder, NumericFieldsConfiguration numericFields, ConfigContext configContext, ParseContext parseContext, Annotation idAnnotation, DocumentFieldPath fieldPath) {
        FieldBridge idBridge;
        NumericField numericFieldAnnotation;
        if (parseContext.isExplicitDocumentId()) {
            if (idAnnotation instanceof DocumentId) {
                throw log.duplicateDocumentIdFound(typeMetadataBuilder.getIndexedType().getName());
            }
            return;
        }
        if (idAnnotation instanceof DocumentId) {
            parseContext.setExplicitDocumentId(true);
        }
        if ((numericFieldAnnotation = numericFields.getNumericFieldAnnotation(fieldPath)) != null && numericFieldAnnotation.forField().isEmpty() && (member.isAnnotationPresent(Field.class) || member.isAnnotationPresent(Fields.class))) {
            numericFieldAnnotation = null;
        }
        if (parseContext.skipFieldBridges()) {
            idBridge = null;
        } else {
            idBridge = this.bridgeFactory.buildFieldBridge((XMember)member, true, numericFieldAnnotation != null, parseContext.getIndexManagerType(), this.reflectionManager, configContext.getServiceManager());
            if (!(idBridge instanceof TwoWayFieldBridge)) {
                throw new SearchException("Bridge for document id does not implement TwoWayFieldBridge: " + member.getName());
            }
        }
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(TermVector.NO);
        PropertyMetadata.Builder propertyMetadataBuilder = new PropertyMetadata.Builder(typeMetadataBuilder.getResultReference(), member, this.reflectionManager.toClass(member.getType()));
        DocumentFieldMetadata.Builder idMetadataBuilder = new DocumentFieldMetadata.Builder(typeMetadataBuilder.getResultReference(), propertyMetadataBuilder.getResultReference(), fieldPath, Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, termVector).id().boost(AnnotationProcessingHelper.getBoost(member, null)).fieldBridge(idBridge);
        parseContext.setIdFieldPath(fieldPath);
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = this.determineNumericFieldEncoding(idBridge);
        if (numericEncodingType != NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN) {
            idMetadataBuilder.numeric();
            idMetadataBuilder.numericEncodingType(numericEncodingType);
        }
        this.checkForSortableField(member, typeMetadataBuilder, propertyMetadataBuilder, "", true, null, parseContext);
        this.checkForSortableFields(member, typeMetadataBuilder, propertyMetadataBuilder, "", true, null, parseContext);
        if (idBridge instanceof MetadataProvidingFieldBridge) {
            FieldMetadataBuilderImpl bridgeDefinedMetadata = this.getBridgeContributedFieldMetadata(idMetadataBuilder, (MetadataProvidingFieldBridge)idBridge);
            for (BridgeDefinedField bridgeDefinedField : bridgeDefinedMetadata.getBridgeDefinedFields()) {
                idMetadataBuilder.addBridgeDefinedField(bridgeDefinedField);
            }
        }
        DocumentFieldMetadata fieldMetadata = idMetadataBuilder.build();
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        PropertyMetadata idPropertyMetadata = propertyMetadataBuilder.build();
        typeMetadataBuilder.idProperty(idPropertyMetadata);
    }

    private Annotation getIdAnnotation(XProperty member, TypeMetadata.Builder typeMetadataBuilder, ConfigContext context) {
        Annotation idAnnotation = null;
        DocumentId documentIdAnnotation = (DocumentId)member.getAnnotation(DocumentId.class);
        if (documentIdAnnotation != null) {
            idAnnotation = documentIdAnnotation;
        }
        if (context.isJpaPresent()) {
            Annotation jpaId = member.getAnnotation(this.jpaIdClass);
            if (jpaId == null) {
                jpaId = member.getAnnotation(this.jpaEmbeddedIdClass);
            }
            if (jpaId != null) {
                typeMetadataBuilder.jpaProperty(member);
                if (idAnnotation == null) {
                    log.debug("Found JPA id and using it as document id");
                    idAnnotation = jpaId;
                }
            }
        }
        return idAnnotation;
    }

    private void initializeProvidedIdMetadata(String prefix, ProvidedId providedId, XClass clazz, TypeMetadata.Builder typeMetadataBuilder, boolean isRoot, PathsContext pathsContext, ParseContext parseContext) {
        TwoWayFieldBridge providedIdFieldBridge = null;
        String relativeFieldName = providedId != null ? providedId.name() : "providedId";
        DocumentFieldPath fieldPath = new DocumentFieldPath(prefix, relativeFieldName);
        if (!parseContext.includeEmbeddedObjectId() && pathsContext != null && !pathsContext.isIncluded(fieldPath)) {
            return;
        }
        if (isRoot || !parseContext.skipFieldBridges()) {
            providedIdFieldBridge = providedId != null ? this.bridgeFactory.extractTwoWayType(providedId.bridge(), clazz, this.reflectionManager) : new TwoWayString2FieldBridgeAdaptor(StringBridge.INSTANCE);
        }
        PropertyMetadata.Builder propertyMetadataBuilder = new PropertyMetadata.Builder(typeMetadataBuilder.getResultReference(), null, null);
        DocumentFieldMetadata.Builder fieldMetadataBuilder = new DocumentFieldMetadata.Builder(typeMetadataBuilder.getResultReference(), propertyMetadataBuilder.getResultReference(), fieldPath, Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO).fieldBridge(providedIdFieldBridge).boost(Float.valueOf(1.0f));
        if (!isRoot) {
            fieldMetadataBuilder.idInEmbedded();
        }
        DocumentFieldMetadata fieldMetadata = fieldMetadataBuilder.build();
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        PropertyMetadata propertyMetadata = propertyMetadataBuilder.build();
        if (isRoot) {
            typeMetadataBuilder.idProperty(propertyMetadata);
        } else {
            typeMetadataBuilder.addProperty(propertyMetadata);
        }
    }

    private String getIdAttributeName(XProperty member, Annotation idAnnotation) {
        String name = null;
        if (idAnnotation.annotationType() == DocumentId.class) {
            name = ((DocumentId)idAnnotation).name();
        }
        return ReflectionHelper.getAttributeName((XMember)member, name);
    }

    private float getBoost(XClass element) {
        float boost = 1.0f;
        if (element == null) {
            return boost;
        }
        Boost boostAnnotation = (Boost)element.getAnnotation(Boost.class);
        if (boostAnnotation != null) {
            boost = boostAnnotation.value();
        }
        return boost;
    }

    private void initializeClass(TypeMetadata.Builder typeMetadataBuilder, boolean isRoot, String prefix, ParseContext parseContext, ConfigContext configContext, boolean disableOptimizationsArg, PathsContext pathsContext) {
        List<XClass> hierarchy = ReflectionHelper.createXClassHierarchy(parseContext.getCurrentClass());
        ProvidedId explicitProvidedIdAnnotation = null;
        XClass providedIdHostingClass = null;
        for (XClass currentClass : hierarchy) {
            ProvidedId providedId = (ProvidedId)currentClass.getAnnotation(ProvidedId.class);
            if (providedId != null) {
                explicitProvidedIdAnnotation = providedId;
                providedIdHostingClass = currentClass;
            }
            parseContext.setCurrentClass(currentClass);
            this.initializeClassLevelAnnotations(typeMetadataBuilder, prefix, configContext, parseContext);
            this.initializeClassBridgeInstances(typeMetadataBuilder, prefix, configContext, currentClass, parseContext);
        }
        boolean isProvidedId = false;
        if (explicitProvidedIdAnnotation != null || configContext.isProvidedIdImplicit()) {
            this.initializeProvidedIdMetadata(prefix, explicitProvidedIdAnnotation, providedIdHostingClass, typeMetadataBuilder, isRoot, pathsContext, parseContext);
            isProvidedId = true;
        }
        boolean disableOptimizations = disableOptimizationsArg || !this.stateInspectionOptimizationsEnabled(typeMetadataBuilder);
        for (XClass currentClass : hierarchy) {
            parseContext.setCurrentClass(currentClass);
            boolean hasExplicitDocumentId = this.hasExplicitDocumentId(currentClass);
            List methods = currentClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMemberLevelAnnotations(prefix, method, typeMetadataBuilder, disableOptimizations, isRoot, isProvidedId, configContext, pathsContext, parseContext, hasExplicitDocumentId);
            }
            List fields = currentClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMemberLevelAnnotations(prefix, field, typeMetadataBuilder, disableOptimizations, isRoot, isProvidedId, configContext, pathsContext, parseContext, hasExplicitDocumentId);
            }
            for (String unqualifiedCollectionRole : parseContext.getCollectedUnqualifiedCollectionRoles()) {
                typeMetadataBuilder.addCollectionRole(StringHelper.qualify(parseContext.getCurrentClass().getName(), unqualifiedCollectionRole));
            }
        }
    }

    private void initializePackageLevelAnnotations(XPackage xPackage, ConfigContext configContext) {
        if (xPackage != null) {
            this.checkForAnalyzerDefs((XAnnotatedElement)xPackage, configContext);
            this.checkForFullTextFilterDefs((XAnnotatedElement)xPackage, configContext);
        }
    }

    private void initializeClassLevelAnnotations(TypeMetadata.Builder typeMetadataBuilder, String prefix, ConfigContext configContext, ParseContext parseContext) {
        Spatials spatialsAnnotation;
        Spatial spatialAnnotation;
        ClassBridge classBridgeAnnotation;
        AnalyzerReference analyzerReference;
        XClass clazz = parseContext.getCurrentClass();
        if (!parseContext.skipAnalyzers() && (analyzerReference = AnnotationProcessingHelper.getAnalyzerReference((Analyzer)clazz.getAnnotation(Analyzer.class), configContext, parseContext.getIndexManagerType())) != null) {
            typeMetadataBuilder.analyzerReference(analyzerReference);
        }
        this.checkForAnalyzerDefs((XAnnotatedElement)clazz, configContext);
        this.checkForFullTextFilterDefs((XAnnotatedElement)clazz, configContext);
        ClassBridges classBridgesAnnotation = (ClassBridges)clazz.getAnnotation(ClassBridges.class);
        if (classBridgesAnnotation != null) {
            ClassBridge[] classBridges;
            for (ClassBridge cb : classBridges = classBridgesAnnotation.value()) {
                this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, cb, clazz, configContext, parseContext);
            }
        }
        if ((classBridgeAnnotation = (ClassBridge)clazz.getAnnotation(ClassBridge.class)) != null) {
            this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, classBridgeAnnotation, clazz, configContext, parseContext);
        }
        if ((spatialAnnotation = (Spatial)clazz.getAnnotation(Spatial.class)) != null) {
            this.bindSpatialAnnotation(spatialAnnotation, prefix, typeMetadataBuilder, parseContext);
        }
        if ((spatialsAnnotation = (Spatials)clazz.getAnnotation(Spatials.class)) != null) {
            Spatial[] spatials;
            for (Spatial innerSpatialAnnotation : spatials = spatialsAnnotation.value()) {
                this.bindSpatialAnnotation(innerSpatialAnnotation, prefix, typeMetadataBuilder, parseContext);
            }
        }
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)clazz, typeMetadataBuilder, configContext);
    }

    private void initializeClassBridgeInstances(TypeMetadata.Builder typeMetadataBuilder, String prefix, ConfigContext configContext, XClass clazz, ParseContext parseContext) {
        Map<FieldBridge, ClassBridge> classBridgeInstances = configContext.getClassBridgeInstances(this.reflectionManager.toClass(clazz));
        for (Map.Entry<FieldBridge, ClassBridge> classBridge : classBridgeInstances.entrySet()) {
            FieldBridge instance = classBridge.getKey();
            ClassBridge configuration = classBridge.getValue();
            this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, configuration, instance, configContext, parseContext);
        }
    }

    private void bindClassBridgeAnnotation(String prefix, TypeMetadata.Builder typeMetadataBuilder, ClassBridge classBridgeAnnotation, XClass clazz, ConfigContext configContext, ParseContext parseContext) {
        FieldBridge fieldBridge = this.bridgeFactory.extractType(classBridgeAnnotation, this.reflectionManager.toClass(clazz));
        this.bindClassBridgeAnnotation(prefix, typeMetadataBuilder, classBridgeAnnotation, fieldBridge, configContext, parseContext);
    }

    private void bindClassBridgeAnnotation(String prefix, TypeMetadata.Builder typeMetadataBuilder, ClassBridge classBridgeAnnotation, FieldBridge fieldBridge, ConfigContext configContext, ParseContext parseContext) {
        this.bridgeFactory.injectParameters(classBridgeAnnotation, fieldBridge);
        String relativeFieldName = classBridgeAnnotation.name();
        DocumentFieldPath fieldPath = new DocumentFieldPath(prefix, relativeFieldName);
        Store store = classBridgeAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(classBridgeAnnotation.index(), classBridgeAnnotation.analyze(), classBridgeAnnotation.norms());
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(classBridgeAnnotation.termVector());
        DocumentFieldMetadata.Builder fieldMetadataBuilder = new DocumentFieldMetadata.Builder(typeMetadataBuilder.getResultReference(), BackReference.empty(), fieldPath, store, index, termVector).boost(Float.valueOf(classBridgeAnnotation.boost().value())).fieldBridge(fieldBridge);
        this.contributeClassBridgeDefinedFields(typeMetadataBuilder, fieldMetadataBuilder, fieldBridge);
        if (!parseContext.skipAnalyzers()) {
            AnalyzerReference analyzerReference = AnnotationProcessingHelper.getAnalyzerReference(classBridgeAnnotation.analyzer(), configContext, parseContext.getIndexManagerType());
            typeMetadataBuilder.addToScopedAnalyzerReference(fieldPath, analyzerReference, index);
            fieldMetadataBuilder.analyzerReference(analyzerReference);
        }
        DocumentFieldMetadata fieldMetadata = fieldMetadataBuilder.build();
        typeMetadataBuilder.addClassBridgeField(fieldMetadata);
    }

    private void bindSpatialAnnotation(Spatial spatialAnnotation, String prefix, XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, ParseContext parseContext) {
        String relativeFieldName = ReflectionHelper.getAttributeName((XMember)member, spatialAnnotation.name());
        DocumentFieldPath fieldPath = new DocumentFieldPath(prefix, relativeFieldName);
        if (parseContext.isSpatialNameUsed(fieldPath)) {
            throw log.cannotHaveTwoSpatialsWithDefaultOrSameName(member.getType().getName());
        }
        parseContext.markSpatialNameAsUsed(fieldPath);
        Store store = spatialAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.NO);
        Field.TermVector termVector = Field.TermVector.NO;
        FieldBridge fieldBridge = this.bridgeFactory.buildFieldBridge((XMember)member, false, false, parseContext.getIndexManagerType(), this.reflectionManager, this.configContext.getServiceManager());
        DocumentFieldMetadata.Builder fieldMetadataBuilder = new DocumentFieldMetadata.Builder(typeMetadataBuilder.getResultReference(), propertyMetadataBuilder.getResultReference(), fieldPath, store, index, termVector).boost(AnnotationProcessingHelper.getBoost(member, spatialAnnotation)).fieldBridge(fieldBridge).spatial();
        if (fieldBridge instanceof MetadataProvidingFieldBridge) {
            MetadataProvidingFieldBridge metadataProvidingFieldBridge = (MetadataProvidingFieldBridge)fieldBridge;
            FieldMetadataBuilderImpl bridgeContributedMetadata = this.getBridgeContributedFieldMetadata(fieldMetadataBuilder, metadataProvidingFieldBridge);
            for (BridgeDefinedField field : bridgeContributedMetadata.getBridgeDefinedFields()) {
                fieldMetadataBuilder.addBridgeDefinedField(field);
            }
        }
        DocumentFieldMetadata fieldMetadata = fieldMetadataBuilder.build();
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        if (member.isCollection()) {
            parseContext.collectUnqualifiedCollectionRole(member.getName());
        }
    }

    private void bindSpatialAnnotation(Spatial spatialAnnotation, String prefix, TypeMetadata.Builder typeMetadataBuilder, ParseContext parseContext) {
        DocumentFieldPath fieldPath;
        String relativeFieldName = spatialAnnotation.name();
        if (relativeFieldName.isEmpty()) {
            relativeFieldName = "_hibernate_default_coordinates";
        }
        if (parseContext.isSpatialNameUsed(fieldPath = new DocumentFieldPath(prefix, relativeFieldName))) {
            throw log.cannotHaveTwoSpatialsWithDefaultOrSameName(parseContext.getCurrentClass().getName());
        }
        parseContext.markSpatialNameAsUsed(fieldPath);
        Store store = spatialAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.NO);
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(TermVector.NO);
        FieldBridge spatialBridge = this.determineSpatialFieldBridge(spatialAnnotation, parseContext);
        DocumentFieldMetadata.Builder fieldMetadataBuilder = new DocumentFieldMetadata.Builder(typeMetadataBuilder.getResultReference(), BackReference.empty(), fieldPath, store, index, termVector).boost(Float.valueOf(spatialAnnotation.boost().value())).fieldBridge(spatialBridge).spatial();
        this.contributeClassBridgeDefinedFields(typeMetadataBuilder, fieldMetadataBuilder, spatialBridge);
        DocumentFieldMetadata fieldMetadata = fieldMetadataBuilder.build();
        typeMetadataBuilder.addClassBridgeField(fieldMetadata);
        AnalyzerReference analyzerReference = typeMetadataBuilder.getAnalyzerReference();
        if (analyzerReference == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
    }

    private void contributeClassBridgeDefinedFields(TypeMetadata.Builder typeMetadataBuilder, DocumentFieldMetadata.Builder fieldMetadataBuilder, FieldBridge fieldBridge) {
        if (fieldBridge instanceof MetadataProvidingFieldBridge) {
            MetadataProvidingFieldBridge metadataProvidingFieldBridge = (MetadataProvidingFieldBridge)fieldBridge;
            FieldMetadataBuilderImpl classBridgeContributedFieldMetadata = this.getBridgeContributedFieldMetadata(fieldMetadataBuilder, metadataProvidingFieldBridge);
            typeMetadataBuilder.addClassBridgeSortableFields(classBridgeContributedFieldMetadata.getSortableFieldsAbsoluteNames());
            for (BridgeDefinedField bridgeDefinedField : classBridgeContributedFieldMetadata.getBridgeDefinedFields()) {
                fieldMetadataBuilder.addBridgeDefinedField(bridgeDefinedField);
            }
        }
    }

    private FieldBridge determineSpatialFieldBridge(Spatial spatialAnnotation, ParseContext parseContext) {
        FieldBridge spatialBridge;
        XClass clazz = parseContext.getCurrentClass();
        if (this.reflectionManager.toXClass(Coordinates.class).isAssignableFrom(clazz)) {
            spatialBridge = this.bridgeFactory.buildSpatialBridge(spatialAnnotation, clazz, null, null);
        } else {
            String latitudeField = null;
            String longitudeField = null;
            List fieldList = clazz.getDeclaredProperties("field");
            for (XProperty property : fieldList) {
                if (property.isAnnotationPresent(Latitude.class) && ((Latitude)property.getAnnotation(Latitude.class)).of().equals(spatialAnnotation.name())) {
                    if (latitudeField != null) {
                        throw log.ambiguousLatitudeDefinition(clazz.getName(), latitudeField, property.getName());
                    }
                    latitudeField = property.getName();
                }
                if (!property.isAnnotationPresent(Longitude.class) || !((Longitude)property.getAnnotation(Longitude.class)).of().equals(spatialAnnotation.name())) continue;
                if (longitudeField != null) {
                    throw log.ambiguousLongitudeDefinition(clazz.getName(), longitudeField, property.getName());
                }
                longitudeField = property.getName();
            }
            List propertyList = clazz.getDeclaredProperties("property");
            for (XProperty property : propertyList) {
                if (property.isAnnotationPresent(Latitude.class) && ((Latitude)property.getAnnotation(Latitude.class)).of().equals(spatialAnnotation.name())) {
                    if (latitudeField != null) {
                        throw log.ambiguousLatitudeDefinition(clazz.getName(), latitudeField, property.getName());
                    }
                    latitudeField = property.getName();
                }
                if (!property.isAnnotationPresent(Longitude.class) || !((Longitude)property.getAnnotation(Longitude.class)).of().equals(spatialAnnotation.name())) continue;
                if (longitudeField != null) {
                    throw log.ambiguousLongitudeDefinition(clazz.getName(), longitudeField, property.getName());
                }
                longitudeField = property.getName();
            }
            spatialBridge = latitudeField != null && longitudeField != null ? this.bridgeFactory.buildSpatialBridge(spatialAnnotation, clazz, latitudeField, longitudeField) : null;
        }
        if (spatialBridge == null) {
            throw log.cannotFindCoordinatesNorLatLongForSpatial(spatialAnnotation.name().isEmpty() ? "default" : spatialAnnotation.name(), clazz.getName());
        }
        return spatialBridge;
    }

    private void bindSortableFieldAnnotation(SortableField sortableFieldAnnotation, String prefix, XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, boolean isIdProperty, ParseContext parseContext) {
        String idFieldAbsoluteName;
        String sortedFieldRelativeName = ReflectionHelper.getAttributeName((XMember)member, sortableFieldAnnotation.forField());
        String sortedFieldAbsoluteName = prefix + sortedFieldRelativeName;
        DocumentFieldPath idFieldPath = parseContext.getIdFieldPath();
        String string = idFieldAbsoluteName = idFieldPath == null ? null : idFieldPath.getAbsoluteName();
        if (isIdProperty && !sortedFieldAbsoluteName.equals(idFieldAbsoluteName) || !isIdProperty && sortedFieldAbsoluteName.equals(idFieldAbsoluteName)) {
            return;
        }
        if (!sortedFieldAbsoluteName.equals(idFieldAbsoluteName) && !this.containsField(propertyMetadataBuilder, sortedFieldAbsoluteName)) {
            if (parseContext.getLevel() != 0) {
                return;
            }
            throw log.sortableFieldRefersToUndefinedField(typeMetadataBuilder.getIndexedType(), propertyMetadataBuilder.getPropertyAccessor().getName(), sortedFieldAbsoluteName);
        }
        SortableFieldMetadata fieldMetadata = new SortableFieldMetadata.Builder(sortedFieldAbsoluteName).build();
        propertyMetadataBuilder.addSortableField(fieldMetadata);
    }

    private boolean containsField(PropertyMetadata.Builder propertyMetadataBuilder, String fieldName) {
        for (DocumentFieldMetadata field : propertyMetadataBuilder.getFieldMetadata()) {
            if (!field.getAbsoluteName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private void initializeMemberLevelAnnotations(String prefix, XProperty member, TypeMetadata.Builder typeMetadataBuilder, boolean disableOptimizations, boolean isRoot, boolean isProvidedId, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext, boolean hasExplicitDocumentId) {
        PropertyMetadata.Builder propertyMetadataBuilder = new PropertyMetadata.Builder(typeMetadataBuilder.getResultReference(), member, this.reflectionManager.toClass(member.getType())).dynamicBoostStrategy(AnnotationProcessingHelper.getDynamicBoost((XAnnotatedElement)member));
        NumericFieldsConfiguration numericFields = this.buildNumericFieldsConfiguration(typeMetadataBuilder.getIndexedType(), member, prefix, pathsContext, parseContext);
        if (!isProvidedId) {
            this.checkDocumentId(member, typeMetadataBuilder, propertyMetadataBuilder, numericFields, isRoot, prefix, configContext, pathsContext, parseContext, hasExplicitDocumentId);
        }
        this.checkForField(member, typeMetadataBuilder, propertyMetadataBuilder, numericFields, prefix, configContext, pathsContext, parseContext);
        this.checkForFields(member, typeMetadataBuilder, propertyMetadataBuilder, numericFields, prefix, configContext, pathsContext, parseContext);
        this.checkForSpatial(member, typeMetadataBuilder, propertyMetadataBuilder, prefix, pathsContext, parseContext);
        this.checkForSpatialsAnnotation(member, typeMetadataBuilder, propertyMetadataBuilder, prefix, pathsContext, parseContext);
        this.checkForSortableField(member, typeMetadataBuilder, propertyMetadataBuilder, prefix, false, pathsContext, parseContext);
        this.checkForSortableFields(member, typeMetadataBuilder, propertyMetadataBuilder, prefix, false, pathsContext, parseContext);
        this.checkForAnalyzerDefs((XAnnotatedElement)member, configContext);
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)member, typeMetadataBuilder, configContext);
        this.checkForIndexedEmbedded(member, propertyMetadataBuilder, prefix, disableOptimizations, typeMetadataBuilder, configContext, pathsContext, parseContext);
        this.checkForContainedIn(member, typeMetadataBuilder, parseContext);
        numericFields.validate();
        PropertyMetadata property = propertyMetadataBuilder.build();
        if (!property.getFieldMetadataSet().isEmpty()) {
            typeMetadataBuilder.addProperty(property);
        }
    }

    private void checkForContainedIn(XProperty member, TypeMetadata.Builder typeMetadataBuilder, ParseContext parseContext) {
        if (!member.isAnnotationPresent(ContainedIn.class)) {
            return;
        }
        ContainedInMetadata containedInMetadata = this.createContainedInMetadata(member);
        typeMetadataBuilder.addContainedIn(containedInMetadata);
        parseContext.collectUnqualifiedCollectionRole(member.getName());
    }

    private ContainedInMetadata createContainedInMetadata(XProperty member) {
        ContainedInMetadataBuilder containedInMetadataBuilder = new ContainedInMetadataBuilder((XMember)member);
        this.updateContainedInMetadata(containedInMetadataBuilder, member, "field");
        this.updateContainedInMetadata(containedInMetadataBuilder, member, "property");
        return containedInMetadataBuilder.createContainedInMetadata();
    }

    private void updateContainedInMetadata(ContainedInMetadataBuilder containedInMetadataBuilder, XProperty propertyWithContainedIn, String accessType) {
        XClass memberReturnedType = this.returnedType(propertyWithContainedIn);
        String mappedBy = this.mappedBy((XMember)propertyWithContainedIn);
        List returnedTypeProperties = memberReturnedType.getDeclaredProperties(accessType);
        for (XProperty property : returnedTypeProperties) {
            if (!this.isCorrespondingIndexedEmbedded(propertyWithContainedIn, mappedBy, property)) continue;
            this.updateContainedInMetadataForProperty(containedInMetadataBuilder, property);
            break;
        }
    }

    private boolean isCorrespondingIndexedEmbedded(XProperty memberWithContainedIn, String mappedBy, XProperty candidateProperty) {
        if (!candidateProperty.isAnnotationPresent(IndexedEmbedded.class)) {
            return false;
        }
        if (mappedBy.equals(candidateProperty.getName())) {
            return true;
        }
        if (mappedBy.isEmpty()) {
            String reverseMappedBy = this.mappedBy((XMember)candidateProperty);
            return reverseMappedBy.equals(memberWithContainedIn.getName());
        }
        return false;
    }

    private void updateContainedInMetadataForProperty(ContainedInMetadataBuilder containedInMetadataBuilder, XProperty property) {
        IndexedEmbedded indexedEmbeddedAnnotation = (IndexedEmbedded)property.getAnnotation(IndexedEmbedded.class);
        containedInMetadataBuilder.maxDepth(indexedEmbeddedAnnotation.depth());
        containedInMetadataBuilder.prefix(this.buildEmbeddedPrefix(indexedEmbeddedAnnotation, property));
        containedInMetadataBuilder.includePaths(indexedEmbeddedAnnotation.includePaths());
    }

    private String mappedBy(XMember member) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = member.getAnnotations()) {
            String mappedBy = this.mappedBy(annotation);
            if (!StringHelper.isNotEmpty(mappedBy)) continue;
            return mappedBy;
        }
        return "";
    }

    private String mappedBy(Annotation annotation) {
        try {
            Method declaredMethod = annotation.annotationType().getDeclaredMethod("mappedBy", new Class[0]);
            return (String)declaredMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (SecurityException e) {
            return "";
        }
        catch (NoSuchMethodException e) {
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return "";
        }
    }

    private NumericFieldsConfiguration buildNumericFieldsConfiguration(Class<?> indexedType, XProperty member, String prefix, PathsContext pathsContext, ParseContext parseContext) {
        NumericFields numericFieldsAnnotation;
        LinkedHashMap<String, NumericField> fieldsMarkedAsNumeric = new LinkedHashMap<String, NumericField>();
        NumericField numericFieldAnnotation = (NumericField)member.getAnnotation(NumericField.class);
        if (numericFieldAnnotation != null && (this.isFieldInPath(numericFieldAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            fieldsMarkedAsNumeric.put(numericFieldAnnotation.forField(), numericFieldAnnotation);
        }
        if ((numericFieldsAnnotation = (NumericFields)member.getAnnotation(NumericFields.class)) != null) {
            for (NumericField numericField : numericFieldsAnnotation.value()) {
                NumericField existing;
                if (!this.isFieldInPath(numericFieldAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached() || (existing = fieldsMarkedAsNumeric.put(numericField.forField(), numericField)) == null) continue;
                throw log.severalNumericFieldAnnotationsForSameField(indexedType, member.getName());
            }
        }
        return new NumericFieldsConfiguration(indexedType, member, fieldsMarkedAsNumeric);
    }

    private void checkForField(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, NumericFieldsConfiguration numericFields, String prefix, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        Field fieldAnnotation = (Field)member.getAnnotation(Field.class);
        if (fieldAnnotation != null && (this.isFieldInPath(fieldAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            Set<Facet> facetAnnotations = this.findMatchingFacetAnnotations((XMember)member, fieldAnnotation.name());
            this.bindFieldAnnotation(prefix, fieldAnnotation, numericFields, facetAnnotations, typeMetadataBuilder, propertyMetadataBuilder, configContext, parseContext);
        }
    }

    private Set<Facet> findMatchingFacetAnnotations(XMember member, String fieldName) {
        Facet facetAnnotation = (Facet)member.getAnnotation(Facet.class);
        Facets facetsAnnotation = (Facets)member.getAnnotation(Facets.class);
        if (facetAnnotation == null && facetsAnnotation == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Facet> matchingFacetAnnotations = new LinkedHashSet<Facet>(1);
        if (facetAnnotation != null && facetAnnotation.forField().equals(fieldName)) {
            matchingFacetAnnotations.add(facetAnnotation);
        }
        if (facetsAnnotation != null) {
            for (Facet annotation : facetsAnnotation.value()) {
                if (annotation == null || !annotation.forField().equals(fieldName)) continue;
                matchingFacetAnnotations.add(annotation);
            }
        }
        return matchingFacetAnnotations;
    }

    private void bindFieldAnnotation(String prefix, Field fieldAnnotation, NumericFieldsConfiguration numericFields, Set<Facet> facetAnnotations, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, ConfigContext configContext, ParseContext parseContext) {
        DocumentFieldMetadata.Builder fieldMetadataBuilder;
        AnalyzerReference analyzerReference;
        XProperty member = propertyMetadataBuilder.getPropertyAccessor();
        if (this.isPropertyTransient(member, configContext)) {
            typeMetadataBuilder.disableStateInspectionOptimization();
        }
        String relativeFieldName = ReflectionHelper.getAttributeName((XMember)member, fieldAnnotation.name());
        DocumentFieldPath fieldPath = new DocumentFieldPath(prefix, relativeFieldName);
        Store store = fieldAnnotation.store();
        Field.Index index = AnnotationProcessingHelper.getIndex(fieldAnnotation.index(), fieldAnnotation.analyze(), fieldAnnotation.norms());
        Field.TermVector termVector = AnnotationProcessingHelper.getTermVector(fieldAnnotation.termVector());
        NumericField numericFieldAnnotation = numericFields.getNumericFieldAnnotation(fieldPath);
        FieldBridge fieldBridge = parseContext.skipFieldBridges() ? null : this.bridgeFactory.buildFieldBridge(fieldAnnotation, (XMember)member, false, numericFieldAnnotation != null, parseContext.getIndexManagerType(), this.reflectionManager, configContext.getServiceManager());
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = this.determineNumericFieldEncoding(fieldBridge);
        NullMarkerCodec nullTokenCodec = this.determineNullMarkerCodec(fieldBridge, fieldAnnotation, configContext, parseContext, typeMetadataBuilder.getIndexedType(), fieldPath);
        if (nullTokenCodec != NotEncodingCodec.SINGLETON && fieldBridge instanceof TwoWayFieldBridge) {
            fieldBridge = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)fieldBridge, nullTokenCodec);
        }
        if (parseContext.skipAnalyzers()) {
            analyzerReference = null;
        } else {
            analyzerReference = this.determineAnalyzer(fieldAnnotation, member, configContext, parseContext);
            analyzerReference = typeMetadataBuilder.addToScopedAnalyzerReference(fieldPath, analyzerReference, index);
        }
        if (this.isNumericField(numericFieldAnnotation, fieldBridge)) {
            fieldMetadataBuilder = new DocumentFieldMetadata.Builder(typeMetadataBuilder.getResultReference(), propertyMetadataBuilder.getResultReference(), fieldPath, store, Field.Index.NO.equals((Object)index) ? index : Field.Index.NOT_ANALYZED_NO_NORMS, termVector).boost(AnnotationProcessingHelper.getBoost(member, fieldAnnotation)).fieldBridge(fieldBridge).analyzerReference(analyzerReference).indexNullAs(nullTokenCodec).numeric().precisionStep(AnnotationProcessingHelper.getPrecisionStep(numericFieldAnnotation)).numericEncodingType(numericEncodingType);
        } else {
            fieldMetadataBuilder = new DocumentFieldMetadata.Builder(typeMetadataBuilder.getResultReference(), propertyMetadataBuilder.getResultReference(), fieldPath, store, index, termVector).boost(AnnotationProcessingHelper.getBoost(member, fieldAnnotation)).fieldBridge(fieldBridge).analyzerReference(analyzerReference).indexNullAs(nullTokenCodec);
            if (fieldBridge instanceof SpatialFieldBridge) {
                fieldMetadataBuilder.spatial();
            }
        }
        for (Facet facetAnnotation : facetAnnotations) {
            if (Analyze.YES.equals((Object)fieldAnnotation.analyze())) {
                throw log.attemptToFacetOnAnalyzedField(fieldPath.getAbsoluteName(), member.getDeclaringClass().getName());
            }
            String relativeFacetFieldName = facetAnnotation.name();
            if (relativeFacetFieldName.isEmpty()) {
                relativeFacetFieldName = relativeFieldName;
            }
            DocumentFieldPath facetFieldPath = new DocumentFieldPath(prefix, relativeFacetFieldName);
            FacetMetadata.Builder facetMetadataBuilder = new FacetMetadata.Builder(fieldMetadataBuilder.getResultReference(), facetFieldPath);
            FacetEncodingType facetEncodingType = this.determineFacetEncodingType(member, facetAnnotation);
            facetMetadataBuilder.setFacetEncoding(facetEncodingType);
            facetMetadataBuilder.setFacetEncodingAuto(facetAnnotation.encoding().equals((Object)FacetEncodingType.AUTO));
            fieldMetadataBuilder.addFacetMetadata(facetMetadataBuilder.build());
        }
        if (fieldBridge instanceof MetadataProvidingFieldBridge) {
            MetadataProvidingFieldBridge metadataProvidingFieldBridge = (MetadataProvidingFieldBridge)fieldBridge;
            FieldMetadataBuilderImpl bridgeContributedMetadata = this.getBridgeContributedFieldMetadata(fieldMetadataBuilder, metadataProvidingFieldBridge);
            for (String sortableFieldAbsoluteName : bridgeContributedMetadata.getSortableFieldsAbsoluteNames()) {
                SortableFieldMetadata sortableFieldMetadata = new SortableFieldMetadata.Builder(sortableFieldAbsoluteName).build();
                propertyMetadataBuilder.addSortableField(sortableFieldMetadata);
            }
            for (BridgeDefinedField field : bridgeContributedMetadata.getBridgeDefinedFields()) {
                fieldMetadataBuilder.addBridgeDefinedField(field);
            }
        }
        DocumentFieldMetadata fieldMetadata = fieldMetadataBuilder.build();
        propertyMetadataBuilder.addDocumentField(fieldMetadata);
        parseContext.collectUnqualifiedCollectionRole(member.getName());
    }

    private FacetEncodingType determineFacetEncodingType(XProperty member, Facet facetAnnotation) {
        FacetEncodingType facetEncodingType = facetAnnotation.encoding();
        if (!facetEncodingType.equals((Object)FacetEncodingType.AUTO)) {
            return facetEncodingType;
        }
        Class indexedType = this.reflectionManager.toClass(this.returnedType(member));
        if (ReflectionHelper.isIntegerType(indexedType)) {
            facetEncodingType = FacetEncodingType.LONG;
        } else if (Date.class.isAssignableFrom(indexedType) || Calendar.class.isAssignableFrom(indexedType)) {
            facetEncodingType = FacetEncodingType.LONG;
        } else if (ReflectionHelper.isFloatingPointType(indexedType)) {
            facetEncodingType = FacetEncodingType.DOUBLE;
        } else if (String.class.isAssignableFrom(indexedType)) {
            facetEncodingType = FacetEncodingType.STRING;
        } else {
            throw log.unsupportedFieldTypeForFaceting(indexedType.getName(), member.getDeclaringClass().getName(), member.getName());
        }
        return facetEncodingType;
    }

    private boolean isNumericField(NumericField numericFieldAnnotation, FieldBridge fieldBridge) {
        return numericFieldAnnotation != null || NumericFieldUtils.isNumericContainerOrNumericFieldBridge(fieldBridge);
    }

    private NumericFieldSettingsDescriptor.NumericEncodingType determineNumericFieldEncoding(FieldBridge fieldBridge) {
        EncodingBridge encodingBridge = BridgeAdaptorUtils.unwrapAdaptorAndContainer(fieldBridge, EncodingBridge.class);
        if (encodingBridge != null) {
            return encodingBridge.getEncodingType();
        }
        return NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN;
    }

    private NullMarkerCodec determineNullMarkerCodec(FieldBridge fieldBridge, Field fieldAnnotation, ConfigContext context, ParseContext parseContext, Class<?> indexedType, DocumentFieldPath fieldPath) {
        if (parseContext.skipNullMarkerCodec()) {
            return NotEncodingCodec.SINGLETON;
        }
        if (fieldAnnotation == null) {
            return NotEncodingCodec.SINGLETON;
        }
        String indexNullAs = fieldAnnotation.indexNullAs();
        if (indexNullAs.equals("__DO_NOT_INDEX_NULL__")) {
            return NotEncodingCodec.SINGLETON;
        }
        NullMarker nullMarker = indexNullAs.equals("__DEFAULT_NULL_TOKEN__") ? this.createNullMarker(fieldBridge, context.getDefaultNullToken(), fieldPath) : this.createNullMarker(fieldBridge, indexNullAs, fieldPath);
        IndexManagerType indexManagerType = parseContext.getIndexManagerType();
        MissingValueStrategy missingValueStrategy = indexManagerType.getMissingValueStrategy();
        return missingValueStrategy.createNullMarkerCodec(indexedType, fieldPath, nullMarker);
    }

    private NullMarker createNullMarker(FieldBridge fieldBridge, String marker, DocumentFieldPath path) {
        EncodingBridge encodingBridge = BridgeAdaptorUtils.unwrapAdaptorOnly(fieldBridge, EncodingBridge.class);
        if (encodingBridge != null) {
            try {
                return encodingBridge.createNullMarker(marker);
            }
            catch (IllegalArgumentException e) {
                throw log.nullMarkerInvalidFormat(marker, path.getAbsoluteName(), e.getLocalizedMessage(), e);
            }
        }
        return new ToStringNullMarker(marker);
    }

    private AnalyzerReference determineAnalyzer(Field fieldAnnotation, XProperty member, ConfigContext context, ParseContext parseContext) {
        AnalyzerReference analyzerReference = null;
        if (!parseContext.skipAnalyzers()) {
            if (fieldAnnotation != null) {
                analyzerReference = AnnotationProcessingHelper.getAnalyzerReference(fieldAnnotation.analyzer(), context, parseContext.getIndexManagerType());
            }
            if (analyzerReference == null) {
                analyzerReference = AnnotationProcessingHelper.getAnalyzerReference((Analyzer)member.getAnnotation(Analyzer.class), context, parseContext.getIndexManagerType());
            }
        }
        return analyzerReference;
    }

    private boolean isPropertyTransient(XProperty member, ConfigContext context) {
        Annotation transientAnnotation;
        if (!context.isJpaPresent()) {
            return false;
        }
        try {
            Class transientAnnotationClass = ClassLoaderHelper.classForName("javax.persistence.Transient", this.configContext.getServiceManager());
            transientAnnotation = member.getAnnotation(transientAnnotationClass);
        }
        catch (ClassLoadingException e) {
            throw new SearchException("Unable to load @Transient.class even though it should be present ?!");
        }
        return transientAnnotation != null;
    }

    private void checkForSpatialsAnnotation(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, String prefix, PathsContext pathsContext, ParseContext parseContext) {
        Spatials spatialsAnnotation = (Spatials)member.getAnnotation(Spatials.class);
        if (spatialsAnnotation != null) {
            for (Spatial spatialAnnotation : spatialsAnnotation.value()) {
                if (!this.isFieldInPath(spatialAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached()) continue;
                this.bindSpatialAnnotation(spatialAnnotation, prefix, member, typeMetadataBuilder, propertyMetadataBuilder, parseContext);
            }
        }
    }

    private void checkForSpatial(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, String prefix, PathsContext pathsContext, ParseContext parseContext) {
        Spatial spatialAnnotation = (Spatial)member.getAnnotation(Spatial.class);
        if (spatialAnnotation != null && (this.isFieldInPath(spatialAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            this.bindSpatialAnnotation(spatialAnnotation, prefix, member, typeMetadataBuilder, propertyMetadataBuilder, parseContext);
        }
    }

    private void checkForSortableField(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, String prefix, boolean isIdProperty, PathsContext pathsContext, ParseContext parseContext) {
        SortableField sortableFieldAnnotation = (SortableField)member.getAnnotation(SortableField.class);
        if (sortableFieldAnnotation != null && (this.isFieldInPath(sortableFieldAnnotation, member, pathsContext, prefix) || !parseContext.isMaxLevelReached())) {
            this.bindSortableFieldAnnotation(sortableFieldAnnotation, prefix, member, typeMetadataBuilder, propertyMetadataBuilder, isIdProperty, parseContext);
        }
    }

    private void checkForSortableFields(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, String prefix, boolean isIdProperty, PathsContext pathsContext, ParseContext parseContext) {
        SortableFields sortableFieldsAnnotation = (SortableFields)member.getAnnotation(SortableFields.class);
        if (sortableFieldsAnnotation != null) {
            for (SortableField sortableFieldAnnotation : sortableFieldsAnnotation.value()) {
                if (!this.isFieldInPath(sortableFieldAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached()) continue;
                this.bindSortableFieldAnnotation(sortableFieldAnnotation, prefix, member, typeMetadataBuilder, propertyMetadataBuilder, isIdProperty, parseContext);
            }
        }
    }

    private void checkForAnalyzerDefs(XAnnotatedElement annotatedElement, ConfigContext context) {
        AnalyzerDefs defs = (AnalyzerDefs)annotatedElement.getAnnotation(AnalyzerDefs.class);
        if (defs != null) {
            for (AnalyzerDef def : defs.value()) {
                context.addAnalyzerDef(def, annotatedElement);
            }
        }
        AnalyzerDef def = (AnalyzerDef)annotatedElement.getAnnotation(AnalyzerDef.class);
        context.addAnalyzerDef(def, annotatedElement);
    }

    private void checkForFullTextFilterDefs(XAnnotatedElement annotatedElement, ConfigContext context) {
        FullTextFilterDefs defs = (FullTextFilterDefs)annotatedElement.getAnnotation(FullTextFilterDefs.class);
        if (defs != null) {
            for (FullTextFilterDef def : defs.value()) {
                context.addFullTextFilterDef(def, annotatedElement);
            }
        }
        FullTextFilterDef def = (FullTextFilterDef)annotatedElement.getAnnotation(FullTextFilterDef.class);
        context.addFullTextFilterDef(def, annotatedElement);
    }

    private void checkForAnalyzerDiscriminator(XAnnotatedElement annotatedElement, TypeMetadata.Builder typeMetadataBuilder, ConfigContext context) {
        AnalyzerDiscriminator discriminatorAnnotation = (AnalyzerDiscriminator)annotatedElement.getAnnotation(AnalyzerDiscriminator.class);
        if (discriminatorAnnotation == null) {
            return;
        }
        if (annotatedElement instanceof XProperty && this.isPropertyTransient((XProperty)annotatedElement, context)) {
            typeMetadataBuilder.disableStateInspectionOptimization();
        }
        Class<? extends Discriminator> discriminatorClass = discriminatorAnnotation.impl();
        Discriminator discriminator = ClassLoaderHelper.instanceFromClass(Discriminator.class, discriminatorClass, "analyzer discriminator implementation");
        if (annotatedElement instanceof XMember) {
            typeMetadataBuilder.analyzerDiscriminator(discriminator, (XMember)annotatedElement);
        } else {
            typeMetadataBuilder.analyzerDiscriminator(discriminator, null);
        }
    }

    private void checkForFields(XProperty member, TypeMetadata.Builder typeMetadataBuilder, PropertyMetadata.Builder propertyMetadataBuilder, NumericFieldsConfiguration numericFields, String prefix, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        Fields fieldsAnnotation = (Fields)member.getAnnotation(Fields.class);
        if (fieldsAnnotation != null && fieldsAnnotation.value().length > 0) {
            for (Field fieldAnnotation : fieldsAnnotation.value()) {
                if (!this.isFieldInPath(fieldAnnotation, member, pathsContext, prefix) && parseContext.isMaxLevelReached()) continue;
                Set<Facet> facetAnnotations = this.findMatchingFacetAnnotations((XMember)member, fieldAnnotation.name());
                this.bindFieldAnnotation(prefix, fieldAnnotation, numericFields, facetAnnotations, typeMetadataBuilder, propertyMetadataBuilder, configContext, parseContext);
            }
        }
    }

    private boolean isFieldInPath(Annotation fieldAnnotation, XProperty member, PathsContext pathsContext, String prefix) {
        DocumentFieldPath path;
        if (pathsContext != null && pathsContext.isIncluded(path = new DocumentFieldPath(prefix, this.fieldName(fieldAnnotation, member)))) {
            pathsContext.markEncounteredPath(path);
            return true;
        }
        return false;
    }

    private String fieldName(Annotation fieldAnnotation, XProperty member) {
        if (fieldAnnotation == null) {
            return member.getName();
        }
        String fieldName = AnnotationProcessingHelper.getFieldName(fieldAnnotation);
        if (fieldName == null || fieldName.isEmpty()) {
            return member.getName();
        }
        return fieldName;
    }

    private void checkForIndexedEmbedded(XProperty member, PropertyMetadata.Builder propertyMetadataBuilder, String prefix, boolean disableOptimizations, TypeMetadata.Builder typeMetadataBuilder, ConfigContext configContext, PathsContext pathsContext, ParseContext parseContext) {
        IndexedEmbedded indexedEmbeddedAnnotation = (IndexedEmbedded)member.getAnnotation(IndexedEmbedded.class);
        if (indexedEmbeddedAnnotation == null) {
            return;
        }
        parseContext.collectUnqualifiedCollectionRole(member.getName());
        int oldMaxLevel = parseContext.getMaxLevel();
        int potentialLevel = this.potentialLevel(parseContext, indexedEmbeddedAnnotation, member);
        if (potentialLevel < oldMaxLevel) {
            parseContext.setMaxLevel(potentialLevel);
        }
        parseContext.incrementLevel();
        XClass elementClass = this.elementClass(member, indexedEmbeddedAnnotation);
        String localPrefix = this.buildEmbeddedPrefix(indexedEmbeddedAnnotation, member);
        String fullPrefix = prefix + localPrefix;
        boolean includeEmbeddedObjectId = indexedEmbeddedAnnotation.includeEmbeddedObjectId();
        if (parseContext.getMaxLevel() == Integer.MAX_VALUE && parseContext.hasBeenProcessed(elementClass)) {
            throw log.detectInfiniteTypeLoopInIndexedEmbedded(elementClass.getName(), typeMetadataBuilder.getIndexedType().getName(), fullPrefix);
        }
        PathsContext updatedPathsContext = this.updatePaths(fullPrefix, pathsContext, indexedEmbeddedAnnotation);
        boolean pathsCreatedAtThisLevel = false;
        if (pathsContext == null && updatedPathsContext != null) {
            pathsCreatedAtThisLevel = true;
        }
        if (!parseContext.isMaxLevelReached() || this.isInPath(fullPrefix, updatedPathsContext, indexedEmbeddedAnnotation)) {
            parseContext.processingClass(elementClass);
            EmbeddedTypeMetadata.Builder embeddedTypeMetadataBuilder = new EmbeddedTypeMetadata.Builder(typeMetadataBuilder, this.reflectionManager.toClass(elementClass), propertyMetadataBuilder.getResultReference(), (XMember)member, localPrefix);
            embeddedTypeMetadataBuilder.boost(this.getBoost(elementClass) * AnnotationProcessingHelper.getBoost(member, null).floatValue());
            if (!parseContext.skipAnalyzers()) {
                AnalyzerReference analyzerReference = AnnotationProcessingHelper.getAnalyzerReference((Analyzer)member.getAnnotation(Analyzer.class), configContext, parseContext.getIndexManagerType());
                if (analyzerReference == null) {
                    analyzerReference = typeMetadataBuilder.getAnalyzerReference();
                }
                embeddedTypeMetadataBuilder.analyzerReference(analyzerReference);
            }
            if (disableOptimizations) {
                typeMetadataBuilder.blacklistForOptimization(elementClass);
            }
            XClass previousClass = parseContext.getCurrentClass();
            parseContext.setCurrentClass(elementClass);
            boolean previousIncludeEmbeddedObjectId = parseContext.includeEmbeddedObjectId();
            parseContext.setIncludeEmbeddedObjectId(includeEmbeddedObjectId);
            this.initializeClass(embeddedTypeMetadataBuilder, false, fullPrefix, parseContext, configContext, disableOptimizations, updatedPathsContext);
            parseContext.setCurrentClass(previousClass);
            parseContext.setIncludeEmbeddedObjectId(previousIncludeEmbeddedObjectId);
            String indexNullAs = this.embeddedNullToken(configContext, indexedEmbeddedAnnotation);
            if (indexNullAs != null) {
                NullEncodingFieldBridge fieldBridge = new NullEncodingFieldBridge(NULL_EMBEDDED_STRING_BRIDGE, indexNullAs);
                embeddedTypeMetadataBuilder.indexNullToken(indexNullAs, this.embeddedNullField(fullPrefix), fieldBridge);
            }
            EmbeddedTypeMetadata embeddedTypeMetadata = embeddedTypeMetadataBuilder.build();
            for (XClass xClass : embeddedTypeMetadata.getOptimizationBlackList()) {
                typeMetadataBuilder.blacklistForOptimization(xClass);
            }
            typeMetadataBuilder.addEmbeddedType(embeddedTypeMetadata);
            parseContext.removeProcessedClass(elementClass);
        } else if (log.isTraceEnabled()) {
            log.tracef("depth reached, ignoring %s", fullPrefix);
        }
        parseContext.decrementLevel();
        parseContext.setMaxLevel(oldMaxLevel);
        if (pathsCreatedAtThisLevel) {
            this.validateAllPathsEncountered(member, updatedPathsContext, indexedEmbeddedAnnotation);
        }
    }

    private int potentialLevel(ParseContext parseContext, IndexedEmbedded indexedEmbeddedAnnotation, XProperty member) {
        int potentialLevel = this.depth(indexedEmbeddedAnnotation) + parseContext.getLevel();
        if (potentialLevel < 0) {
            potentialLevel = Integer.MAX_VALUE;
        }
        return potentialLevel;
    }

    private XClass elementClass(XProperty member, IndexedEmbedded indexedEmbeddedAnnotation) {
        if (Void.TYPE == indexedEmbeddedAnnotation.targetElement()) {
            return this.returnedType(member);
        }
        return this.reflectionManager.toXClass(indexedEmbeddedAnnotation.targetElement());
    }

    private XClass returnedType(XProperty member) {
        return member.getElementClass();
    }

    private int depth(IndexedEmbedded embeddedAnn) {
        if (!this.isDepthSet(embeddedAnn) && embeddedAnn.includePaths().length > 0) {
            return 0;
        }
        return embeddedAnn.depth();
    }

    private boolean isDepthSet(IndexedEmbedded embeddedAnn) {
        return Integer.MAX_VALUE != embeddedAnn.depth();
    }

    private boolean isInPath(String localPrefix, PathsContext pathsContext, IndexedEmbedded embeddedAnn) {
        if (pathsContext != null) {
            boolean defaultPrefix = this.isDefaultPrefix(embeddedAnn);
            Iterator<String> iterator = pathsContext.getEncounteredPaths().iterator();
            while (iterator.hasNext()) {
                String path;
                String app = path = iterator.next();
                if (defaultPrefix) {
                    app = app + ".";
                }
                if (!app.startsWith(localPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    private PathsContext updatePaths(String localPrefix, PathsContext pathsContext, IndexedEmbedded indexedEmbeddedAnnotation) {
        if (pathsContext != null) {
            return pathsContext;
        }
        PathsContext newPathsContext = new PathsContext();
        for (String path : indexedEmbeddedAnnotation.includePaths()) {
            newPathsContext.addIncludedPath(localPrefix + path);
        }
        return newPathsContext;
    }

    private String buildEmbeddedPrefix(IndexedEmbedded indexedEmbeddedAnnotation, XProperty member) {
        if (this.isDefaultPrefix(indexedEmbeddedAnnotation)) {
            return this.defaultPrefix(member);
        }
        return indexedEmbeddedAnnotation.prefix();
    }

    private String defaultPrefix(XProperty member) {
        return member.getName() + '.';
    }

    private boolean isDefaultPrefix(IndexedEmbedded indexedEmbeddedAnnotation) {
        return ".".equals(indexedEmbeddedAnnotation.prefix());
    }

    private String embeddedNullField(String localPrefix) {
        if (localPrefix.endsWith(".")) {
            return localPrefix.substring(0, localPrefix.length() - 1);
        }
        return localPrefix;
    }

    private void validateAllPathsEncountered(XProperty member, PathsContext updatedPathsContext, IndexedEmbedded indexedEmbeddedAnnotation) {
        Set<String> unEncounteredPaths = updatedPathsContext.getUnEncounteredPaths();
        if (unEncounteredPaths.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String prefix = indexedEmbeddedAnnotation.prefix();
            for (String path : unEncounteredPaths) {
                sb.append(this.removeLeadingPrefixFromPath(path, prefix));
                sb.append(',');
            }
            String invalidPaths = sb.substring(0, sb.length() - 1);
            throw log.invalidIncludePathConfiguration(member.getName(), member.getDeclaringClass().getName(), invalidPaths);
        }
    }

    private String removeLeadingPrefixFromPath(String path, String prefix) {
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    private String embeddedNullToken(ConfigContext context, IndexedEmbedded indexedEmbeddedAnnotation) {
        String indexNullAs = indexedEmbeddedAnnotation.indexNullAs();
        if ("__DO_NOT_INDEX_NULL__".equals(indexNullAs)) {
            return null;
        }
        if ("__DEFAULT_NULL_TOKEN__".equals(indexNullAs)) {
            return context.getDefaultNullToken();
        }
        return indexNullAs;
    }

    boolean stateInspectionOptimizationsEnabled(TypeMetadata.Builder typeMetadataBuilder) {
        if (!typeMetadataBuilder.isStateInspectionOptimizationsEnabled()) {
            return false;
        }
        if (typeMetadataBuilder.areClassBridgesUsed()) {
            log.tracef("State inspection optimization disabled as entity %s uses class bridges", typeMetadataBuilder.getIndexedType().getName());
            return false;
        }
        BoostStrategy boostStrategy = typeMetadataBuilder.getClassBoostStrategy();
        if (boostStrategy != null && !(boostStrategy instanceof DefaultBoostStrategy)) {
            log.tracef("State inspection optimization disabled as DynamicBoost is enabled on entity %s", typeMetadataBuilder.getIndexedType().getName());
            return false;
        }
        return true;
    }

    private FieldMetadataBuilderImpl getBridgeContributedFieldMetadata(DocumentFieldMetadata.Builder fieldMetadataBuilder, MetadataProvidingFieldBridge metadataProvidingFieldBridge) {
        FieldMetadataBuilderImpl builder = new FieldMetadataBuilderImpl(fieldMetadataBuilder.getResultReference());
        metadataProvidingFieldBridge.configureFieldMetadata(fieldMetadataBuilder.getAbsoluteName(), builder);
        return builder;
    }

    private boolean hasExplicitDocumentId(XClass type) {
        List methods = type.getDeclaredProperties("property");
        for (XProperty method : methods) {
            if (!method.isAnnotationPresent(DocumentId.class)) continue;
            return true;
        }
        List fields = type.getDeclaredProperties("field");
        for (XProperty field : fields) {
            if (!field.isAnnotationPresent(DocumentId.class)) continue;
            return true;
        }
        return false;
    }
}

