/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Filter;
import org.hibernate.search.query.dsl.SimpleQueryStringContext;
import org.hibernate.search.query.dsl.SimpleQueryStringMatchingContext;
import org.hibernate.search.query.dsl.impl.ConnectedSimpleQueryStringMatchingContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

class ConnectedSimpleQueryStringContext
implements SimpleQueryStringContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;

    public ConnectedSimpleQueryStringContext(QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = new QueryCustomizer();
    }

    @Override
    public SimpleQueryStringMatchingContext onField(String field) {
        return new ConnectedSimpleQueryStringMatchingContext(field, this.queryCustomizer, this.queryContext);
    }

    @Override
    public SimpleQueryStringMatchingContext onFields(String field, String ... fields) {
        String[] allFields = new String[fields.length + 1];
        allFields[0] = field;
        System.arraycopy(fields, 0, allFields, 1, fields.length);
        return new ConnectedSimpleQueryStringMatchingContext(allFields, this.queryCustomizer, this.queryContext);
    }

    @Override
    public ConnectedSimpleQueryStringContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public ConnectedSimpleQueryStringContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public ConnectedSimpleQueryStringContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

