/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.StringHelper;

public final class ElasticsearchRequest {
    private final String method;
    private final String path;
    private final Map<String, String> parameters;
    private final List<JsonObject> bodyParts;

    public static Builder put() {
        return new Builder("PUT");
    }

    public static Builder get() {
        return new Builder("GET");
    }

    public static Builder post() {
        return new Builder("POST");
    }

    public static Builder delete() {
        return new Builder("DELETE");
    }

    public static Builder head() {
        return new Builder("HEAD");
    }

    private ElasticsearchRequest(Builder builder) {
        this.method = builder.method;
        this.path = builder.pathBuilder.toString();
        this.parameters = builder.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.parameters);
        this.bodyParts = builder.bodyParts == null ? Collections.emptyList() : Collections.unmodifiableList(builder.bodyParts);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public List<JsonObject> getBodyParts() {
        return this.bodyParts;
    }

    public static final class Builder {
        private static final String PATH_SEPARATOR = "/";
        private final String method;
        private final StringBuilder pathBuilder = new StringBuilder("/");
        private Map<String, String> parameters;
        private List<JsonObject> bodyParts;

        private Builder(String method) {
            this.method = method;
        }

        public Builder pathComponent(String pathComponent) {
            try {
                String encodedPathComponent = URLEncoder.encode(pathComponent, StandardCharsets.UTF_8.name());
                this.pathBuilder.append(encodedPathComponent).append(PATH_SEPARATOR);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionFailure("Unexpected error retrieving the UTF-8 charset", (Throwable)e);
            }
            return this;
        }

        public Builder multiValuedPathComponent(Iterable<String> indexNames) {
            return this.pathComponent(StringHelper.join(indexNames, (String)","));
        }

        public Builder param(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, String>();
            }
            this.parameters.put(name, value);
            return this;
        }

        public Builder param(String name, int value) {
            return this.param(name, String.valueOf(value));
        }

        public Builder param(String name, boolean value) {
            return this.param(name, String.valueOf(value));
        }

        public Builder body(JsonObject object) {
            if (this.bodyParts == null) {
                this.bodyParts = new ArrayList<JsonObject>();
            }
            this.bodyParts.add(object);
            return this;
        }

        public ElasticsearchRequest build() {
            return new ElasticsearchRequest(this);
        }
    }
}

