/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.search.backend.impl.lucene.MultiWriteDrainableLinkedList;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.processor.impl.ParallelWorkExecutionContext;
import org.hibernate.search.elasticsearch.processor.impl.SequentialWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.BulkRequestFailedException;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchWorkProcessor
implements AutoCloseable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final int MAX_BULK_SIZE = 250;
    private final AsyncBackendRequestProcessor asyncProcessor = new AsyncBackendRequestProcessor();
    private final ErrorHandler errorHandler;
    private final ElasticsearchClient client;
    private final GsonProvider gsonProvider;
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchWorkExecutionContext parallelWorkExecutionContext;

    public ElasticsearchWorkProcessor(BuildContext context, ElasticsearchClient client, GsonProvider gsonProvider, ElasticsearchWorkFactory workFactory) {
        this.errorHandler = context.getErrorHandler();
        this.client = client;
        this.gsonProvider = gsonProvider;
        this.workFactory = workFactory;
        this.parallelWorkExecutionContext = new ParallelWorkExecutionContext(client, gsonProvider);
    }

    @Override
    public void close() {
        this.awaitAsyncProcessingCompletion();
        this.asyncProcessor.shutdown();
    }

    public <T> T executeSyncUnsafe(ElasticsearchWork<T> work) {
        return work.execute(this.parallelWorkExecutionContext);
    }

    public void executeSyncSafe(Iterable<ElasticsearchWork<?>> requests) {
        this.executeSafely(requests);
    }

    public void executeAsync(ElasticsearchWork<?> request) {
        this.asyncProcessor.submitRequest(request);
    }

    public void awaitAsyncProcessingCompletion() {
        this.asyncProcessor.awaitCompletion();
    }

    private void executeSafely(Iterable<ElasticsearchWork<?>> requests) {
        SequentialWorkExecutionContext context = new SequentialWorkExecutionContext(this.client, this.gsonProvider, this.workFactory, this, this.errorHandler);
        for (ElasticsearchWork<?> work : this.createRequestGroups(requests, true)) {
            this.executeSafely(work, context);
        }
        context.flush();
    }

    private void executeSafely(ElasticsearchWork<?> work, ElasticsearchWorkExecutionContext context) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Processing %s", work);
        }
        try {
            work.execute(context);
        }
        catch (BulkRequestFailedException brfe) {
            ErrorContextBuilder builder = new ErrorContextBuilder();
            ArrayList allWorks = new ArrayList();
            for (BulkableElasticsearchWork<?> successfulWork : brfe.getSuccessfulItems().keySet()) {
                successfulWork.getLuceneWorks().forEach(w -> {
                    allWorks.add(w);
                    builder.workCompleted(w);
                });
            }
            for (BulkableElasticsearchWork<?> failedWork : brfe.getErroneousItems()) {
                failedWork.getLuceneWorks().forEach(w -> {
                    allWorks.add(w);
                    builder.addWorkThatFailed(w);
                });
            }
            builder.allWorkToBeDone(allWorks);
            builder.errorThatOccurred((Throwable)((Object)brfe));
            this.errorHandler.handle(builder.createErrorContext());
        }
        catch (RuntimeException e) {
            ErrorContextBuilder builder = new ErrorContextBuilder();
            ArrayList allWorks = new ArrayList();
            work.getLuceneWorks().forEach(w -> {
                allWorks.add(w);
                builder.addWorkThatFailed(w);
            });
            builder.allWorkToBeDone(allWorks);
            builder.errorThatOccurred((Throwable)e);
            this.errorHandler.handle(builder.createErrorContext());
        }
    }

    private List<ElasticsearchWork<?>> createRequestGroups(Iterable<ElasticsearchWork<?>> requests, boolean refreshInBulkAPICall) {
        ProcessorWorkGroupBuilder bulkBuilder = new ProcessorWorkGroupBuilder(refreshInBulkAPICall);
        for (ElasticsearchWork<?> request : requests) {
            request.aggregate(bulkBuilder);
        }
        return bulkBuilder.build();
    }

    private class ProcessorWorkGroupBuilder
    implements ElasticsearchWorkAggregator {
        private final boolean refreshInBulkAPICall;
        private final List<ElasticsearchWork<?>> result = new ArrayList();
        private final List<BulkableElasticsearchWork<?>> bulkInProgress = new ArrayList();

        public ProcessorWorkGroupBuilder(boolean refreshInBulkAPICall) {
            this.refreshInBulkAPICall = refreshInBulkAPICall;
        }

        @Override
        public void addBulkable(BulkableElasticsearchWork<?> work) {
            this.bulkInProgress.add(work);
            if (this.bulkInProgress.size() >= 250) {
                this.flushBulkInProgress();
            }
        }

        @Override
        public void addNonBulkable(ElasticsearchWork<?> work) {
            this.flushBulkInProgress();
            this.result.add(work);
        }

        private void flushBulkInProgress() {
            if (this.bulkInProgress.isEmpty()) {
                return;
            }
            if (this.bulkInProgress.size() == 1) {
                ElasticsearchWork work = this.bulkInProgress.iterator().next();
                this.result.add(work);
            } else {
                this.result.add((ElasticsearchWork<?>)ElasticsearchWorkProcessor.this.workFactory.bulk(this.bulkInProgress).refresh(this.refreshInBulkAPICall).build());
            }
            this.bulkInProgress.clear();
        }

        private List<ElasticsearchWork<?>> build() {
            this.flushBulkInProgress();
            return this.result;
        }
    }

    private class RequestProcessingRunnable
    implements Runnable {
        private final AsyncBackendRequestProcessor asyncProcessor;
        private final CountDownLatch latch = new CountDownLatch(1);

        public RequestProcessingRunnable(AsyncBackendRequestProcessor asyncProcessor) {
            this.asyncProcessor = asyncProcessor;
        }

        @Override
        public void run() {
            try {
                this.processAsyncWork();
            }
            finally {
                this.latch.countDown();
            }
        }

        private void processAsyncWork() {
            SequentialWorkExecutionContext context = new SequentialWorkExecutionContext(ElasticsearchWorkProcessor.this.client, ElasticsearchWorkProcessor.this.gsonProvider, ElasticsearchWorkProcessor.this.workFactory, ElasticsearchWorkProcessor.this, ElasticsearchWorkProcessor.this.errorHandler);
            AsyncBackendRequestProcessor asyncBackendRequestProcessor = this.asyncProcessor;
            synchronized (asyncBackendRequestProcessor) {
                block3: while (true) {
                    Iterable works;
                    if ((works = this.asyncProcessor.asyncWorkQueue.drainToDetachedIterable()) == null) {
                        this.asyncProcessor.asyncWorkerWasStarted.set(false);
                        context.flush();
                        return;
                    }
                    Iterator iterator = ElasticsearchWorkProcessor.this.createRequestGroups(works, false).iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        ElasticsearchWork work = (ElasticsearchWork)iterator.next();
                        work.execute(context);
                    }
                    break;
                }
            }
        }
    }

    private class AsyncBackendRequestProcessor {
        private final ScheduledExecutorService scheduler;
        private final MultiWriteDrainableLinkedList<ElasticsearchWork<?>> asyncWorkQueue = new MultiWriteDrainableLinkedList();
        private final AtomicBoolean asyncWorkerWasStarted;
        private volatile CountDownLatch lastAsyncWorkLatch;

        private AsyncBackendRequestProcessor() {
            this.scheduler = Executors.newScheduledThreadPool((String)"Elasticsearch AsyncBackendRequestProcessor");
            this.asyncWorkerWasStarted = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submitRequest(ElasticsearchWork<?> request) {
            this.asyncWorkQueue.add(request);
            if (!this.asyncWorkerWasStarted.get()) {
                AsyncBackendRequestProcessor asyncBackendRequestProcessor = this;
                synchronized (asyncBackendRequestProcessor) {
                    if (this.asyncWorkerWasStarted.compareAndSet(false, true)) {
                        try {
                            RequestProcessingRunnable runnable = new RequestProcessingRunnable(this);
                            this.scheduler.schedule(runnable, 100L, TimeUnit.MILLISECONDS);
                            this.lastAsyncWorkLatch = runnable.latch;
                        }
                        catch (Exception e) {
                            this.asyncWorkerWasStarted.set(false);
                            CountDownLatch latch = this.lastAsyncWorkLatch;
                            if (latch != null) {
                                latch.countDown();
                            }
                            throw e;
                        }
                    }
                }
            }
        }

        public void awaitCompletion() {
            CountDownLatch localLatch = this.lastAsyncWorkLatch;
            if (localLatch != null) {
                try {
                    localLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw LOG.interruptedWhileWaitingForRequestCompletion(e);
                }
            }
        }

        public void shutdown() {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.interruptedWhileWaitingForIndexActivity(e);
            }
            finally {
                CountDownLatch localLatch = this.lastAsyncWorkLatch;
                if (localLatch != null) {
                    localLatch.countDown();
                }
            }
        }
    }
}

