/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.elasticsearch.client.Response;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleBulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.IndexWorkBuilder;

public class IndexWork
extends SimpleBulkableElasticsearchWork<Void> {
    protected final IndexingMonitor indexingMonitor;

    public IndexWork(Builder builder) {
        super(builder);
        this.indexingMonitor = builder.monitor;
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return null;
    }

    @Override
    protected void afterSuccess(ElasticsearchWorkExecutionContext context) {
        if (this.indexingMonitor != null) {
            IndexingMonitor bufferedIndexingMonitor = context.getBufferedIndexingMonitor(this.indexingMonitor);
            bufferedIndexingMonitor.documentsAdded(1L);
        }
    }

    public static class Builder
    extends SimpleBulkableElasticsearchWork.Builder<Builder>
    implements IndexWorkBuilder {
        private final String indexName;
        private final String typeName;
        private final String id;
        private final JsonObject document;
        protected IndexingMonitor monitor;

        public Builder(String indexName, String typeName, String id, JsonObject document) {
            super(indexName, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.typeName = typeName;
            this.id = id;
            this.document = document;
        }

        @Override
        public Builder monitor(IndexingMonitor monitor) {
            this.monitor = monitor;
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName).pathComponent(this.typeName).pathComponent(this.id).body(this.document);
            return builder.build();
        }

        @Override
        protected JsonObject buildBulkableActionMetadata() {
            return JsonBuilder.object().add("index", JsonBuilder.object().addProperty("_index", this.indexName).addProperty("_type", this.typeName).addProperty("_id", this.id)).build();
        }

        @Override
        public IndexWork build() {
            return new IndexWork(this);
        }
    }
}

