/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.filter.impl.CachingWrapperQuery;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.dsl.impl.RemoteMatchQuery;
import org.hibernate.search.query.dsl.impl.RemotePhraseQuery;
import org.hibernate.search.query.dsl.impl.RemoteSimpleQueryStringQuery;
import org.hibernate.search.query.dsl.sort.impl.NativeSortField;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.spatial.impl.DistanceQuery;
import org.hibernate.search.spatial.impl.SpatialHashQuery;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ToElasticsearch {
    public static final String FACET_FIELD_SUFFIX = "__HSearch_Facet";
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final int DEFAULT_SLOP = 0;
    private static final int DEFAULT_MAX_EDIT_DISTANCE = 0;
    private static final float DEFAULT_BOOST = 1.0f;
    private static final String BOOST_OPERATOR = "^";
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final JsonPrimitive SORT_ORDER_ASC = new JsonPrimitive("asc");
    private static final JsonPrimitive SORT_ORDER_DESC = new JsonPrimitive("desc");
    private static final JsonPrimitive SORT_MISSING_LAST = new JsonPrimitive("_last");
    private static final JsonPrimitive SORT_MISSING_FIRST = new JsonPrimitive("_first");
    private static final Map<SortField.Type, Number> SORT_FIELD_SCALAR_MINIMUMS = new EnumMap<SortField.Type, Number>(SortField.Type.class);
    private static final Map<SortField.Type, Number> SORT_FIELD_SCALAR_DEFAULTS = new EnumMap<SortField.Type, Number>(SortField.Type.class);
    private static final Map<SortField.Type, Number> SORT_FIELD_SCALAR_MAXIMUMS = new EnumMap<SortField.Type, Number>(SortField.Type.class);
    private static final Map<SortField.Type, Class<? extends Number>> SORT_FIELD_SCALAR_TYPES = new EnumMap<SortField.Type, Class<? extends Number>>(SortField.Type.class);
    private static final JsonBuilder.JsonAppender<Object> NOOP_APPENDER;

    private static void initSortFieldScalarValues(SortField.Type type, Class<? extends Number> clazz, Number minValue, Number defaultValue, Number maxValue) {
        SORT_FIELD_SCALAR_MINIMUMS.put(type, minValue);
        SORT_FIELD_SCALAR_DEFAULTS.put(type, defaultValue);
        SORT_FIELD_SCALAR_MAXIMUMS.put(type, maxValue);
        SORT_FIELD_SCALAR_TYPES.put(type, clazz);
    }

    private ToElasticsearch() {
    }

    public static void addFacetingRequest(JsonBuilder.Object jsonQuery, FacetingRequest facetingRequest, String sourceFieldAbsoluteName, String facetRelativeName) {
        String aggregationFieldName = sourceFieldAbsoluteName + "." + facetRelativeName + FACET_FIELD_SUFFIX;
        if (facetingRequest instanceof DiscreteFacetRequest) {
            JsonObject termsJsonQuery = JsonBuilder.object().add("terms", JsonBuilder.object().addProperty("field", aggregationFieldName).addProperty("size", facetingRequest.getMaxNumberOfFacets() == -1 ? Integer.MAX_VALUE : facetingRequest.getMaxNumberOfFacets()).add("order", (JsonElement)ToElasticsearch.fromFacetSortOrder(facetingRequest.getSort())).addProperty("min_doc_count", facetingRequest.hasZeroCountsIncluded() ? 0 : 1)).build();
            if (ToElasticsearch.isNested(sourceFieldAbsoluteName)) {
                JsonBuilder.Object facetJsonQuery = JsonBuilder.object();
                facetJsonQuery.add("nested", JsonBuilder.object().addProperty("path", FieldHelper.getEmbeddedFieldPath(sourceFieldAbsoluteName) + "." + facetRelativeName + FACET_FIELD_SUFFIX));
                facetJsonQuery.add("aggregations", JsonBuilder.object().add(aggregationFieldName, (JsonElement)termsJsonQuery));
                jsonQuery.add(facetingRequest.getFacetingName(), facetJsonQuery);
            } else {
                jsonQuery.add(facetingRequest.getFacetingName(), (JsonElement)termsJsonQuery);
            }
        } else if (facetingRequest instanceof RangeFacetRequest) {
            RangeFacetRequest rangeFacetingRequest = (RangeFacetRequest)facetingRequest;
            for (FacetRange facetRange : rangeFacetingRequest.getFacetRangeList()) {
                JsonBuilder.Object comparisonFragment = JsonBuilder.object();
                if (facetRange.getMin() != null) {
                    comparisonFragment.addProperty(facetRange.isMinIncluded() ? "gte" : "gt", facetRange.getMin());
                }
                if (facetRange.getMax() != null) {
                    comparisonFragment.addProperty(facetRange.isMaxIncluded() ? "lte" : "lt", facetRange.getMax());
                }
                JsonObject rangeQuery = ToElasticsearch.wrapQueryForNestedIfRequired(aggregationFieldName, JsonBuilder.object().add("range", JsonBuilder.object().add(aggregationFieldName, comparisonFragment)).build());
                jsonQuery.add(facetingRequest.getFacetingName() + "-" + facetRange.getIdentifier(), JsonBuilder.object().add("filter", (JsonElement)rangeQuery));
            }
        } else {
            throw LOG.facetingRequestHasUnsupportedType(facetingRequest.getClass().getName());
        }
    }

    private static JsonObject fromFacetSortOrder(FacetSortOrder sortOrder) {
        JsonObject sort = new JsonObject();
        switch (sortOrder) {
            case COUNT_ASC: {
                sort.addProperty("_count", "asc");
                break;
            }
            case COUNT_DESC: {
                sort.addProperty("_count", "desc");
                break;
            }
            case FIELD_VALUE: {
                sort.addProperty("_term", "asc");
                break;
            }
            case RANGE_DEFINITION_ORDER: {
                throw LOG.cannotSendRangeDefinitionOrderToElasticsearchBackend();
            }
        }
        return sort;
    }

    public static JsonObject condition(String operator, JsonArray conditions) {
        JsonObject jsonCondition = conditions.size() == 1 ? conditions.get(0).getAsJsonObject() : JsonBuilder.object().add("bool", JsonBuilder.object().add(operator, (JsonElement)conditions)).build();
        return jsonCondition;
    }

    public static JsonObject fromLuceneQuery(Query query) {
        if (query instanceof MatchAllDocsQuery) {
            return ToElasticsearch.convertMatchAllDocsQuery((MatchAllDocsQuery)query);
        }
        if (query instanceof MatchNoDocsQuery) {
            return ToElasticsearch.convertMatchNoDocsQuery((MatchNoDocsQuery)query);
        }
        if (query instanceof TermQuery) {
            return ToElasticsearch.convertTermQuery((TermQuery)query);
        }
        if (query instanceof BooleanQuery) {
            return ToElasticsearch.convertBooleanQuery((BooleanQuery)query);
        }
        if (query instanceof TermRangeQuery) {
            return ToElasticsearch.convertTermRangeQuery((TermRangeQuery)query);
        }
        if (query instanceof NumericRangeQuery) {
            return ToElasticsearch.convertNumericRangeQuery((NumericRangeQuery)query);
        }
        if (query instanceof WildcardQuery) {
            return ToElasticsearch.convertWildcardQuery((WildcardQuery)query);
        }
        if (query instanceof PrefixQuery) {
            return ToElasticsearch.convertPrefixQuery((PrefixQuery)query);
        }
        if (query instanceof FuzzyQuery) {
            return ToElasticsearch.convertFuzzyQuery((FuzzyQuery)query);
        }
        if (query instanceof RemotePhraseQuery) {
            return ToElasticsearch.convertRemotePhraseQuery((RemotePhraseQuery)query);
        }
        if (query instanceof RemoteMatchQuery) {
            return ToElasticsearch.convertRemoteMatchQuery((RemoteMatchQuery)query);
        }
        if (query instanceof RemoteSimpleQueryStringQuery) {
            return ToElasticsearch.convertRemoteSimpleQueryStringQuery((RemoteSimpleQueryStringQuery)query);
        }
        if (query instanceof ConstantScoreQuery) {
            return ToElasticsearch.convertConstantScoreQuery((ConstantScoreQuery)query);
        }
        if (query instanceof FilteredQuery) {
            return ToElasticsearch.convertFilteredQuery((FilteredQuery)query);
        }
        if (query instanceof QueryWrapperFilter) {
            JsonObject result = ToElasticsearch.fromLuceneQuery(((QueryWrapperFilter)query).getQuery());
            return ToElasticsearch.wrapBoostIfNecessary(result, query.getBoost());
        }
        if (query instanceof DistanceQuery) {
            return ToElasticsearch.convertDistanceQuery((DistanceQuery)query);
        }
        if (query instanceof SpatialHashQuery) {
            return ToElasticsearch.convertSpatialHashFilter((SpatialHashQuery)query);
        }
        if (query instanceof PhraseQuery) {
            return ToElasticsearch.convertPhraseQuery((PhraseQuery)query);
        }
        if (query instanceof BoostQuery) {
            JsonObject result = ToElasticsearch.fromLuceneQuery(((BoostQuery)query).getQuery());
            return ToElasticsearch.wrapBoostIfNecessary(result, query.getBoost());
        }
        if (query instanceof CachingWrapperQuery) {
            JsonObject result = ToElasticsearch.fromLuceneQuery(((CachingWrapperQuery)query).getQuery());
            return ToElasticsearch.wrapBoostIfNecessary(result, query.getBoost());
        }
        if (query instanceof org.apache.lucene.search.CachingWrapperQuery) {
            JsonObject result = ToElasticsearch.fromLuceneQuery(((org.apache.lucene.search.CachingWrapperQuery)query).getQuery());
            return ToElasticsearch.wrapBoostIfNecessary(result, query.getBoost());
        }
        if (query instanceof CachingWrapperFilter) {
            JsonObject result = ToElasticsearch.fromLuceneQuery((Query)((CachingWrapperFilter)query).getFilter());
            return ToElasticsearch.wrapBoostIfNecessary(result, query.getBoost());
        }
        throw LOG.cannotTransformLuceneQueryIntoEsQuery(query);
    }

    public static JsonObject fromDeletionQuery(DocumentBuilderIndexedEntity documentBuilder, DeletionQuery deletionQuery) {
        return ToElasticsearch.fromLuceneQuery(deletionQuery.toLuceneQuery(documentBuilder));
    }

    private static JsonObject convertMatchAllDocsQuery(MatchAllDocsQuery matchAllDocsQuery) {
        return JsonBuilder.object().add("match_all", (JsonElement)new JsonObject()).build();
    }

    private static JsonObject convertMatchNoDocsQuery(MatchNoDocsQuery matchNoDocsQuery) {
        return JsonBuilder.object().add("type", JsonBuilder.object().addProperty("value", "__HSearch_Workaround_MatchNoDocsQuery")).build();
    }

    private static JsonObject convertBooleanQuery(BooleanQuery booleanQuery) {
        JsonArray musts = new JsonArray();
        JsonArray shoulds = new JsonArray();
        JsonArray mustNots = new JsonArray();
        JsonArray filters = new JsonArray();
        for (BooleanClause clause : booleanQuery.clauses()) {
            switch (clause.getOccur()) {
                case MUST: {
                    musts.add((JsonElement)ToElasticsearch.fromLuceneQuery(clause.getQuery()));
                    break;
                }
                case FILTER: {
                    filters.add((JsonElement)ToElasticsearch.fromLuceneQuery(clause.getQuery()));
                    break;
                }
                case MUST_NOT: {
                    mustNots.add((JsonElement)ToElasticsearch.fromLuceneQuery(clause.getQuery()));
                    break;
                }
                case SHOULD: {
                    shoulds.add((JsonElement)ToElasticsearch.fromLuceneQuery(clause.getQuery()));
                }
            }
        }
        JsonBuilder.Object clauses = JsonBuilder.object();
        if (musts.size() > 1) {
            clauses.add("must", (JsonElement)musts);
        } else if (musts.size() == 1) {
            clauses.add("must", (JsonElement)musts.iterator().next());
        }
        if (shoulds.size() > 1) {
            clauses.add("should", (JsonElement)shoulds);
        } else if (shoulds.size() == 1) {
            clauses.add("should", (JsonElement)shoulds.iterator().next());
        }
        if (mustNots.size() > 1) {
            clauses.add("must_not", (JsonElement)mustNots);
        } else if (mustNots.size() == 1) {
            clauses.add("must_not", (JsonElement)mustNots.iterator().next());
        }
        if (filters.size() > 1) {
            clauses.add("filter", (JsonElement)filters);
        } else if (filters.size() == 1) {
            clauses.add("filter", (JsonElement)filters.iterator().next());
        }
        clauses.append(ToElasticsearch.boostAppender((Query)booleanQuery));
        JsonObject bool = new JsonObject();
        bool.add("bool", (JsonElement)clauses.build());
        return bool;
    }

    private static JsonObject convertTermQuery(TermQuery query) {
        String field = query.getTerm().field();
        JsonObject matchQuery = JsonBuilder.object().add("term", JsonBuilder.object().add(field, JsonBuilder.object().addProperty("value", query.getTerm().text()).append(ToElasticsearch.boostAppender((Query)query)))).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(field, matchQuery);
    }

    private static JsonObject convertWildcardQuery(WildcardQuery query) {
        String field = query.getTerm().field();
        JsonObject wildcardQuery = JsonBuilder.object().add("wildcard", JsonBuilder.object().add(field, JsonBuilder.object().addProperty("value", query.getTerm().text()).append(ToElasticsearch.boostAppender((Query)query)))).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(field, wildcardQuery);
    }

    private static JsonObject convertPrefixQuery(PrefixQuery query) {
        String field = query.getField();
        JsonObject wildcardQuery = JsonBuilder.object().add("prefix", JsonBuilder.object().add(field, JsonBuilder.object().addProperty("value", query.getPrefix().text()).append(ToElasticsearch.boostAppender((Query)query)))).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(field, wildcardQuery);
    }

    private static JsonObject convertFuzzyQuery(FuzzyQuery query) {
        String field = query.getTerm().field();
        JsonObject fuzzyQuery = JsonBuilder.object().add("fuzzy", JsonBuilder.object().add(field, JsonBuilder.object().addProperty("value", query.getTerm().text()).addProperty("fuzziness", query.getMaxEdits()).addProperty("prefix_length", query.getPrefixLength()).append(ToElasticsearch.boostAppender((Query)query)))).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(field, fuzzyQuery);
    }

    private static JsonObject convertPhraseQuery(PhraseQuery query) {
        Term[] terms = query.getTerms();
        if (terms.length == 0) {
            throw LOG.cannotQueryOnEmptyPhraseQuery();
        }
        String field = terms[0].field();
        StringBuilder phrase = new StringBuilder();
        for (Term term : terms) {
            phrase.append(" ").append(term.text());
        }
        JsonObject phraseQuery = JsonBuilder.object().add("match_phrase", JsonBuilder.object().add(field, JsonBuilder.object().addProperty("query", phrase.toString().trim()).append(ToElasticsearch.slopAppender(query.getSlop())).append(ToElasticsearch.boostAppender((Query)query)))).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(field, phraseQuery);
    }

    private static JsonObject convertRemotePhraseQuery(RemotePhraseQuery query) {
        if (StringHelper.isEmpty((String)query.getPhrase())) {
            throw LOG.cannotQueryOnEmptyPhraseQuery();
        }
        JsonObject phraseQuery = JsonBuilder.object().add("match_phrase", JsonBuilder.object().add(query.getField(), JsonBuilder.object().addProperty("query", query.getPhrase().trim()).addProperty("analyzer", query.getAnalyzerReference().getAnalyzer().getName(query.getField())).append(ToElasticsearch.slopAppender(query.getSlop())).append(ToElasticsearch.boostAppender((Query)query)))).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(query.getField(), phraseQuery);
    }

    private static JsonObject convertRemoteMatchQuery(RemoteMatchQuery query) {
        JsonObject matchQuery = JsonBuilder.object().add("match", JsonBuilder.object().add(query.getField(), JsonBuilder.object().addProperty("query", query.getSearchTerms()).addProperty("analyzer", query.getAnalyzerReference().getAnalyzer().getName(query.getField())).append(ToElasticsearch.fuzzinessAppender(query.getMaxEditDistance())).append(ToElasticsearch.boostAppender((Query)query)))).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(query.getField(), matchQuery);
    }

    private static JsonObject convertRemoteSimpleQueryStringQuery(RemoteSimpleQueryStringQuery query) {
        JsonBuilder.Object queryBuilder = JsonBuilder.object().addProperty("query", query.getQuery()).addProperty("default_operator", query.isMatchAll() ? "and" : "or");
        HashSet<String> analyzers = new HashSet<String>();
        String overridingRemoteAnalyzerName = null;
        JsonArray fieldArray = new JsonArray();
        for (RemoteSimpleQueryStringQuery.Field field : query.getFields()) {
            StringBuilder sb = new StringBuilder(field.getName());
            if (field.getBoost() != 1.0f) {
                sb.append(BOOST_OPERATOR).append(field.getBoost());
            }
            fieldArray.add(sb.toString());
            String originalRemoteAnalyzerName = query.getOriginalRemoteAnalyzerReference().getAnalyzer().getName(field.getName());
            String queryRemoteAnalyzerName = query.getQueryRemoteAnalyzerReference().getAnalyzer().getName(field.getName());
            analyzers.add(queryRemoteAnalyzerName);
            if (queryRemoteAnalyzerName.equals(originalRemoteAnalyzerName)) continue;
            if (overridingRemoteAnalyzerName == null) {
                overridingRemoteAnalyzerName = queryRemoteAnalyzerName;
                continue;
            }
            if (overridingRemoteAnalyzerName.equals(queryRemoteAnalyzerName)) continue;
            throw LOG.unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzersForSimpleQueryStringQueries(Arrays.asList(overridingRemoteAnalyzerName, queryRemoteAnalyzerName));
        }
        queryBuilder.add("fields", (JsonElement)fieldArray);
        if (overridingRemoteAnalyzerName != null) {
            if (analyzers.size() == 1) {
                queryBuilder.addProperty("analyzer", overridingRemoteAnalyzerName);
            } else {
                throw LOG.unableToOverrideQueryAnalyzerWithMoreThanOneAnalyzersForSimpleQueryStringQueries(analyzers);
            }
        }
        JsonObject simpleQueryStringQuery = JsonBuilder.object().add("simple_query_string", queryBuilder.append(ToElasticsearch.boostAppender((Query)query))).build();
        return simpleQueryStringQuery;
    }

    private static JsonObject convertTermRangeQuery(TermRangeQuery query) {
        JsonBuilder.Object interval = JsonBuilder.object();
        if (query.getLowerTerm() != null) {
            interval.addProperty(query.includesLower() ? "gte" : "gt", query.getLowerTerm().utf8ToString());
        }
        if (query.getUpperTerm() != null) {
            interval.addProperty(query.includesUpper() ? "lte" : "lt", query.getUpperTerm().utf8ToString());
        }
        interval.append(ToElasticsearch.boostAppender((Query)query));
        JsonObject range = JsonBuilder.object().add("range", JsonBuilder.object().add(query.getField(), interval)).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(query.getField(), range);
    }

    private static JsonObject convertNumericRangeQuery(NumericRangeQuery<?> query) {
        JsonBuilder.Object interval = JsonBuilder.object();
        if (query.getMin() != null) {
            interval.addProperty(query.includesMin() ? "gte" : "gt", query.getMin());
        }
        if (query.getMax() != null) {
            interval.addProperty(query.includesMax() ? "lte" : "lt", query.getMax());
        }
        interval.append(ToElasticsearch.boostAppender(query));
        JsonObject range = JsonBuilder.object().add("range", JsonBuilder.object().add(query.getField(), interval)).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(query.getField(), range);
    }

    private static JsonObject convertConstantScoreQuery(ConstantScoreQuery query) {
        JsonObject constantScoreQuery = JsonBuilder.object().add("constant_score", JsonBuilder.object().add("filter", (JsonElement)ToElasticsearch.fromLuceneQuery(query.getQuery())).append(ToElasticsearch.boostAppender((Query)query))).build();
        return constantScoreQuery;
    }

    private static JsonObject wrapBoostIfNecessary(JsonObject convertedQuery, float boost) {
        if (boost != 1.0f) {
            return JsonBuilder.object().add("bool", JsonBuilder.object().add("must", (JsonElement)convertedQuery).addProperty("boost", Float.valueOf(boost))).build();
        }
        return convertedQuery;
    }

    private static JsonObject convertFilteredQuery(FilteredQuery query) {
        JsonObject filteredQuery = JsonBuilder.object().add("bool", JsonBuilder.object().add("must", (JsonElement)ToElasticsearch.fromLuceneQuery(query.getQuery())).add("filter", (JsonElement)ToElasticsearch.fromLuceneQuery((Query)query.getFilter())).append(ToElasticsearch.boostAppender((Query)query))).build();
        return filteredQuery;
    }

    private static JsonObject convertDistanceQuery(DistanceQuery query) {
        JsonObject distanceQuery = JsonBuilder.object().add("geo_distance", JsonBuilder.object().addProperty("distance", query.getRadius() + "km").add(query.getCoordinatesField(), JsonBuilder.object().addProperty("lat", query.getCenter().getLatitude()).addProperty("lon", query.getCenter().getLongitude()))).build();
        distanceQuery = ToElasticsearch.wrapQueryForNestedIfRequired(query.getCoordinatesField(), distanceQuery);
        Query approximationQuery = query.getApproximationQuery();
        if (approximationQuery instanceof SpatialHashQuery) {
            distanceQuery = JsonBuilder.object().add("bool", JsonBuilder.object().add("must", (JsonElement)distanceQuery).add("filter", (JsonElement)ToElasticsearch.convertSpatialHashFilter((SpatialHashQuery)approximationQuery))).build();
        }
        return distanceQuery;
    }

    private static JsonObject convertSpatialHashFilter(SpatialHashQuery filter) {
        JsonArray cellsIdsJsonArray = new JsonArray();
        for (String cellId : filter.getSpatialHashCellsIds()) {
            cellsIdsJsonArray.add(cellId);
        }
        JsonObject spatialHashFilter = JsonBuilder.object().add("terms", JsonBuilder.object().add(filter.getFieldName(), (JsonElement)cellsIdsJsonArray)).build();
        return ToElasticsearch.wrapQueryForNestedIfRequired(filter.getFieldName(), spatialHashFilter);
    }

    private static JsonBuilder.JsonAppender<? super JsonBuilder.Object> slopAppender(final int slop) {
        if (slop != 0) {
            return new JsonBuilder.JsonAppender<JsonBuilder.Object>(){

                @Override
                public void append(JsonBuilder.Object object) {
                    object.addProperty("slop", slop);
                }
            };
        }
        return NOOP_APPENDER;
    }

    private static JsonBuilder.JsonAppender<? super JsonBuilder.Object> fuzzinessAppender(final int maxEditDistance) {
        if (maxEditDistance != 0) {
            return new JsonBuilder.JsonAppender<JsonBuilder.Object>(){

                @Override
                public void append(JsonBuilder.Object object) {
                    object.addProperty("fuzziness", maxEditDistance);
                }
            };
        }
        return NOOP_APPENDER;
    }

    private static JsonBuilder.JsonAppender<? super JsonBuilder.Object> boostAppender(Query query) {
        final float boost = query.getBoost();
        if (boost != 1.0f) {
            return new JsonBuilder.JsonAppender<JsonBuilder.Object>(){

                @Override
                public void append(JsonBuilder.Object object) {
                    object.addProperty("boost", Float.valueOf(boost));
                }
            };
        }
        return NOOP_APPENDER;
    }

    private static JsonObject wrapQueryForNestedIfRequired(String field, JsonObject query) {
        if (!ToElasticsearch.isNested(field)) {
            return query;
        }
        String path = FieldHelper.getEmbeddedFieldPath(field);
        return JsonBuilder.object().add("nested", JsonBuilder.object().addProperty("path", path).add("query", (JsonElement)query)).build();
    }

    private static boolean isNested(String field) {
        return false;
    }

    public static JsonArray fromLuceneSort(Sort sort) {
        JsonBuilder.Array builder = JsonBuilder.array();
        for (SortField field : sort.getSort()) {
            builder.add(ToElasticsearch.fromLuceneSortField(field));
        }
        return builder.build();
    }

    private static JsonBuilder.Object fromLuceneSortField(SortField sortField) {
        String sortFieldName;
        SortField.Type sortFieldType;
        block8: {
            block7: {
                if (sortField instanceof DistanceSortField) {
                    DistanceSortField distanceSortField = (DistanceSortField)sortField;
                    Coordinates center = distanceSortField.getCenter();
                    return JsonBuilder.object().add("_geo_distance", JsonBuilder.object().add("order", (JsonElement)ToElasticsearch.fromLuceneSortFieldOrder(sortField.getType(), sortField.getReverse())).add(sortField.getField(), JsonBuilder.object().addProperty("lat", center.getLatitude()).addProperty("lon", center.getLongitude())).addProperty("unit", "km").addProperty("distance_type", "arc"));
                }
                if (sortField instanceof NativeSortField) {
                    NativeSortField nativeSortField = (NativeSortField)sortField;
                    String sortFieldName2 = nativeSortField.getField();
                    String sortDescriptionAsString = nativeSortField.getNativeSortDescription();
                    JsonElement sortDescription = JSON_PARSER.parse(sortDescriptionAsString);
                    return JsonBuilder.object().add(sortFieldName2, sortDescription);
                }
                sortFieldType = sortField.getType();
                if (sortField.getField() != null) break block7;
                switch (sortFieldType) {
                    case DOC: {
                        sortFieldName = "_uid";
                        break block8;
                    }
                    case SCORE: {
                        sortFieldName = "_score";
                        break block8;
                    }
                    default: {
                        throw LOG.cannotUseThisSortTypeWithNullSortFieldName(sortField.getType());
                    }
                }
            }
            sortFieldName = sortField.getField();
        }
        boolean reverse = sortField.getReverse();
        JsonPrimitive order = ToElasticsearch.fromLuceneSortFieldOrder(sortField.getType(), reverse);
        JsonBuilder.Object contentBuilder = JsonBuilder.object().add("order", (JsonElement)order);
        JsonPrimitive missing = ToElasticsearch.fromLuceneSortFieldMissing(sortFieldType, sortField.missingValue, reverse);
        if (missing != null) {
            contentBuilder.add("missing", (JsonElement)missing);
        }
        return JsonBuilder.object().add(sortFieldName, contentBuilder);
    }

    private static JsonPrimitive fromLuceneSortFieldOrder(SortField.Type sortFieldType, boolean reverse) {
        switch (sortFieldType) {
            case SCORE: {
                return reverse ? SORT_ORDER_ASC : SORT_ORDER_DESC;
            }
        }
        return reverse ? SORT_ORDER_DESC : SORT_ORDER_ASC;
    }

    private static JsonPrimitive fromLuceneSortFieldMissing(SortField.Type sortFieldType, Object luceneMissing, boolean reverse) {
        if (luceneMissing == null) {
            switch (sortFieldType) {
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: {
                    luceneMissing = SORT_FIELD_SCALAR_DEFAULTS.get(sortFieldType);
                    break;
                }
                case STRING: 
                case STRING_VAL: {
                    luceneMissing = reverse ? SortField.STRING_LAST : SortField.STRING_FIRST;
                    break;
                }
            }
        }
        switch (sortFieldType) {
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: {
                if (luceneMissing.equals(SORT_FIELD_SCALAR_MINIMUMS.get(sortFieldType))) {
                    return reverse ? SORT_MISSING_LAST : SORT_MISSING_FIRST;
                }
                if (luceneMissing.equals(SORT_FIELD_SCALAR_MAXIMUMS.get(sortFieldType))) {
                    return reverse ? SORT_MISSING_FIRST : SORT_MISSING_LAST;
                }
                return new JsonPrimitive(SORT_FIELD_SCALAR_TYPES.get(sortFieldType).cast(luceneMissing));
            }
            case STRING: 
            case STRING_VAL: {
                if (SortField.STRING_LAST.equals(luceneMissing)) {
                    return SORT_MISSING_LAST;
                }
                if (SortField.STRING_FIRST.equals(luceneMissing)) {
                    return SORT_MISSING_FIRST;
                }
                if (luceneMissing != null) {
                    throw new AssertionFailure("Unexpected missing value specified on a String SortField: " + luceneMissing);
                }
                return null;
            }
        }
        if (luceneMissing != null) {
            throw new AssertionFailure("Missing value specified on a SortField which is not supposed to support it: " + sortFieldType);
        }
        return null;
    }

    static {
        ToElasticsearch.initSortFieldScalarValues(SortField.Type.DOUBLE, Double.class, Double.MIN_VALUE, 0.0, Double.MAX_VALUE);
        ToElasticsearch.initSortFieldScalarValues(SortField.Type.FLOAT, Float.class, Float.valueOf(Float.MIN_VALUE), Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE));
        ToElasticsearch.initSortFieldScalarValues(SortField.Type.LONG, Long.class, Long.MIN_VALUE, 0L, Long.MAX_VALUE);
        ToElasticsearch.initSortFieldScalarValues(SortField.Type.INT, Integer.class, Integer.MIN_VALUE, 0, Integer.MAX_VALUE);
        NOOP_APPENDER = new JsonBuilder.JsonAppender<Object>(){

            @Override
            public void append(Object appendable) {
            }
        };
    }
}

