/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import com.google.gson.JsonPrimitive;
import org.hibernate.search.elasticsearch.schema.impl.Elasticsearch2SchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ValidationErrorCollector;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.schema.impl.model.FieldDataType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexType;
import org.hibernate.search.elasticsearch.schema.impl.model.NormsType;
import org.hibernate.search.elasticsearch.schema.impl.model.PropertyMapping;

public class Elasticsearch5SchemaValidator
extends Elasticsearch2SchemaValidator {
    public Elasticsearch5SchemaValidator(ElasticsearchSchemaAccessor schemaAccessor) {
        super(schemaAccessor);
    }

    @Override
    protected void doValidateJsonPrimitive(ValidationErrorCollector errorCollector, DataType type, String attributeName, JsonPrimitive expectedValue, JsonPrimitive actualValue) {
        switch (type) {
            case TEXT: 
            case KEYWORD: {
                this.validateEqualWithDefault(errorCollector, attributeName, expectedValue, actualValue, null);
                break;
            }
            default: {
                super.doValidateJsonPrimitive(errorCollector, type, attributeName, expectedValue, actualValue);
            }
        }
    }

    @Override
    protected void validateIndexOptions(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        Boolean expectedDocValues;
        FieldDataType expectedFieldData;
        NormsType expectedNorms;
        IndexType expectedIndex = expectedMapping.getIndex();
        if (IndexType.TRUE.equals((Object)expectedIndex)) {
            IndexType indexDefault = IndexType.TRUE;
            this.validateEqualWithDefault(errorCollector, "index", expectedIndex, actualMapping.getIndex(), indexDefault);
        }
        if (NormsType.TRUE.equals((Object)(expectedNorms = expectedMapping.getNorms()))) {
            NormsType normsDefault = DataType.TEXT.equals((Object)expectedMapping.getType()) ? NormsType.TRUE : NormsType.FALSE;
            this.validateEqualWithDefault(errorCollector, "norms", expectedNorms, actualMapping.getNorms(), normsDefault);
        }
        if (FieldDataType.TRUE.equals((Object)(expectedFieldData = expectedMapping.getFieldData()))) {
            this.validateEqualWithDefault(errorCollector, "fielddata", expectedFieldData, actualMapping.getFieldData(), FieldDataType.FALSE);
        }
        if (Boolean.TRUE.equals(expectedDocValues = expectedMapping.getDocValues())) {
            this.validateEqualWithDefault(errorCollector, "doc_values", expectedDocValues, actualMapping.getDocValues(), false);
        }
    }
}

