/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.stream.Stream;
import org.elasticsearch.client.Response;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class SimpleElasticsearchWork<R>
implements ElasticsearchWork<R> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    protected final ElasticsearchRequest request;
    private final LuceneWork luceneWork;
    protected final URLEncodedString dirtiedIndexName;
    protected final ElasticsearchRequestSuccessAssessor resultAssessor;
    protected final boolean markIndexDirty;

    protected SimpleElasticsearchWork(Builder<?> builder) {
        this.request = builder.buildRequest();
        this.luceneWork = builder.luceneWork;
        this.dirtiedIndexName = builder.dirtiedIndexName;
        this.resultAssessor = builder.resultAssessor;
        this.markIndexDirty = builder.markIndexDirty;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "path = " + this.request.getPath() + ", dirtiedIndexName = " + this.dirtiedIndexName + "]";
    }

    @Override
    public final R execute(ElasticsearchWorkExecutionContext executionContext) {
        R result;
        GsonProvider gsonProvider = executionContext.getGsonProvider();
        Response response = null;
        JsonObject parsedResponseBody = null;
        try {
            this.beforeExecute(executionContext, this.request);
            response = executionContext.getClient().execute(this.request);
            parsedResponseBody = ElasticsearchClientUtils.parseJsonResponse(gsonProvider, response);
            this.resultAssessor.checkSuccess(executionContext, this.request, response, parsedResponseBody);
            result = this.generateResult(executionContext, response, parsedResponseBody);
        }
        catch (SearchException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw LOG.elasticsearchRequestFailed(ElasticsearchClientUtils.formatRequest(gsonProvider, this.request), ElasticsearchClientUtils.formatResponse(gsonProvider, response, parsedResponseBody), e);
        }
        if (this.markIndexDirty) {
            executionContext.setIndexDirty(this.dirtiedIndexName);
        }
        this.afterSuccess(executionContext);
        return result;
    }

    protected void beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
    }

    protected void afterSuccess(ElasticsearchWorkExecutionContext executionContext) {
    }

    protected abstract R generateResult(ElasticsearchWorkExecutionContext var1, Response var2, JsonObject var3);

    @Override
    public void aggregate(ElasticsearchWorkAggregator aggregator) {
        aggregator.addNonBulkable(this);
    }

    @Override
    public Stream<LuceneWork> getLuceneWorks() {
        if (this.luceneWork != null) {
            return Stream.of(this.luceneWork);
        }
        return Stream.empty();
    }

    protected static abstract class Builder<B> {
        protected final URLEncodedString dirtiedIndexName;
        protected ElasticsearchRequestSuccessAssessor resultAssessor;
        protected LuceneWork luceneWork;
        protected boolean markIndexDirty;

        public Builder(URLEncodedString dirtiedIndexName, ElasticsearchRequestSuccessAssessor resultAssessor) {
            this.dirtiedIndexName = dirtiedIndexName;
            this.resultAssessor = resultAssessor;
        }

        public B luceneWork(LuceneWork luceneWork) {
            this.luceneWork = luceneWork;
            return (B)this;
        }

        public B markIndexDirty(boolean markIndexDirty) {
            this.markIndexDirty = markIndexDirty;
            return (B)this;
        }

        protected abstract ElasticsearchRequest buildRequest();

        public abstract ElasticsearchWork<?> build();
    }
}

