/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.WaitForIndexStatusWorkBuilder;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class WaitForIndexStatusWork
extends SimpleElasticsearchWork<Void> {
    protected WaitForIndexStatusWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return null;
    }

    private static class SuccessAssessor
    implements ElasticsearchRequestSuccessAssessor {
        private static final Log LOG = (Log)LoggerFactory.make(Log.class);
        private static final int TIMED_OUT_HTTP_STATUS_CODE = 408;
        private final URLEncodedString indexName;
        private final ElasticsearchIndexStatus requiredIndexStatus;
        private final String timeoutAndUnit;
        private final DefaultElasticsearchRequestSuccessAssessor delegate;

        public SuccessAssessor(URLEncodedString indexName, ElasticsearchIndexStatus requiredIndexStatus, String timeoutAndUnit) {
            this.indexName = indexName;
            this.requiredIndexStatus = requiredIndexStatus;
            this.timeoutAndUnit = timeoutAndUnit;
            this.delegate = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorStatuses(408).build();
        }

        @Override
        public void checkSuccess(ElasticsearchWorkExecutionContext context, ElasticsearchRequest request, Response response, JsonObject parsedResponseBody) throws SearchException {
            this.delegate.checkSuccess(context, request, response, parsedResponseBody);
            if (response.getStatusLine().getStatusCode() == 408) {
                String status = parsedResponseBody.get("status").getAsString();
                throw LOG.unexpectedIndexStatus(this.indexName.original, this.requiredIndexStatus.getElasticsearchString(), status, this.timeoutAndUnit);
            }
        }

        @Override
        public boolean isSuccess(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
            throw new AssertionFailure("This method should never be called, because WaitForIndexStatusWork is not bulkable.");
        }
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements WaitForIndexStatusWorkBuilder {
        private final URLEncodedString indexName;
        private final ElasticsearchIndexStatus requiredStatus;
        private final String timeout;

        public Builder(URLEncodedString indexName, ElasticsearchIndexStatus requiredStatus, String timeout) {
            super(null, new SuccessAssessor(indexName, requiredStatus, timeout));
            this.indexName = indexName;
            this.requiredStatus = requiredStatus;
            this.timeout = timeout;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(Paths._CLUSTER).pathComponent(Paths.HEALTH).pathComponent(this.indexName).param("wait_for_status", this.requiredStatus.getElasticsearchString()).param("timeout", this.timeout);
            return builder.build();
        }

        @Override
        public WaitForIndexStatusWork build() {
            return new WaitForIndexStatusWork(this);
        }
    }
}

