/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.TransactionalOperationExecutor;
import org.hibernate.search.backend.impl.TransactionalOperationExecutorSelector;
import org.hibernate.search.backend.impl.WorkQueuePerIndexSplitter;
import org.hibernate.search.backend.spi.OperationDispatcher;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.store.IndexShardingStrategy;

public class TransactionalOperationDispatcher
implements OperationDispatcher {
    private final Function<Class<?>, EntityIndexBinding> bindingLookup;
    private final IndexManagerHolder indexManagerHolder;
    private final Predicate<IndexManager> indexManagerFilter;

    public TransactionalOperationDispatcher(SearchIntegrator integrator) {
        this(integrator, (IndexManager indexManager) -> true);
    }

    public TransactionalOperationDispatcher(SearchIntegrator integrator, Predicate<IndexManager> indexManagerFilter) {
        this(integrator.unwrap(ExtendedSearchIntegrator.class).getIndexManagerHolder(), integrator::getIndexBinding, indexManagerFilter);
    }

    public TransactionalOperationDispatcher(IndexManagerHolder indexManagerHolder, Map<Class<?>, EntityIndexBinding> bindings) {
        this(indexManagerHolder, bindings::get, indexManager -> true);
    }

    private TransactionalOperationDispatcher(IndexManagerHolder indexManagerHolder, Function<Class<?>, EntityIndexBinding> bindingLookup, Predicate<IndexManager> indexManagerFilter) {
        this.indexManagerHolder = indexManagerHolder;
        this.bindingLookup = bindingLookup;
        this.indexManagerFilter = indexManagerFilter;
    }

    @Override
    public void dispatch(LuceneWork work, IndexingMonitor monitor) {
        WorkQueuePerIndexSplitter context = new WorkQueuePerIndexSplitter(this.indexManagerHolder, this.indexManagerFilter);
        this.appendWork(context, work);
        context.commitOperations(monitor);
    }

    @Override
    public void dispatch(List<LuceneWork> queue, IndexingMonitor monitor) {
        WorkQueuePerIndexSplitter context = new WorkQueuePerIndexSplitter(this.indexManagerHolder, this.indexManagerFilter);
        for (LuceneWork work : queue) {
            this.appendWork(context, work);
        }
        context.commitOperations(monitor);
    }

    private void appendWork(WorkQueuePerIndexSplitter context, LuceneWork work) {
        Class<?> entityType = work.getEntityClass();
        EntityIndexBinding entityIndexBinding = this.bindingLookup.apply(entityType);
        IndexShardingStrategy shardingStrategy = entityIndexBinding.getSelectionStrategy();
        TransactionalOperationExecutor executor = work.acceptIndexWorkVisitor(TransactionalOperationExecutorSelector.INSTANCE, null);
        executor.performOperation(work, shardingStrategy, context);
    }
}

