/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.impl.InternalBackendFactory;
import org.hibernate.search.backend.spi.Backend;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.indexes.impl.EntityIndexBinder;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IndexManagerGroupHolder
implements AutoCloseable {
    private static final Log log = LoggerFactory.make();
    private static final String INDEX_SHARD_ID_SEPARATOR = ".";
    private final IndexManagerHolder parentHolder;
    private final String indexNameBase;
    private final Similarity similarity;
    private final IndexManagerType indexManagerType;
    private final EntityIndexBinder entityIndexBinder;
    private final ConcurrentMap<String, IndexManager> indexManagersRegistry = new ConcurrentHashMap<String, IndexManager>();
    private final ConcurrentMap<String, Backend> backendRegistry = new ConcurrentHashMap<String, Backend>();

    public IndexManagerGroupHolder(IndexManagerHolder parentHolder, String indexNameBase, Similarity similarity, IndexManagerType indexManagerType, EntityIndexBinder entityIndexBinder) {
        this.parentHolder = parentHolder;
        this.indexNameBase = indexNameBase;
        this.similarity = similarity;
        this.indexManagerType = indexManagerType;
        this.entityIndexBinder = entityIndexBinder;
    }

    @Override
    public synchronized void close() {
        for (Backend backend : this.backendRegistry.values()) {
            backend.close();
        }
        this.backendRegistry.clear();
        for (IndexManager indexManager : this.indexManagersRegistry.values()) {
            indexManager.destroy();
        }
        this.indexManagersRegistry.clear();
    }

    public String getIndexNameBase() {
        return this.indexNameBase;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public IndexManagerType getIndexManagerType() {
        return this.indexManagerType;
    }

    MutableEntityIndexBinding bind(Class<?> entityType, EntityIndexingInterceptor<?> interceptor, WorkerBuildContext buildContext) {
        return this.entityIndexBinder.bind(this, entityType, interceptor, buildContext);
    }

    public Backend getOrCreateBackend(String indexManagerName, Properties properties, WorkerBuildContext buildContext) {
        String backendName = properties.getProperty("worker.backend");
        return this.getOrCreateBackend(backendName, indexManagerName, properties, buildContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Backend getOrCreateBackend(String backendName, String indexManagerName, Properties properties, WorkerBuildContext buildContext) {
        String backendIdentifier;
        Backend backend;
        if (backendName == null) {
            backendName = "";
        }
        if ((backend = (Backend)this.backendRegistry.get(backendIdentifier = this.entityIndexBinder.createBackendIdentifier(backendName, indexManagerName))) != null) {
            return backend;
        }
        IndexManagerGroupHolder indexManagerGroupHolder = this;
        synchronized (indexManagerGroupHolder) {
            backend = (Backend)this.backendRegistry.get(backendIdentifier);
            if (backend != null) {
                return backend;
            }
            backend = InternalBackendFactory.createBackend(backendName, indexManagerName, properties, buildContext);
            this.backendRegistry.put(backendIdentifier, backend);
            return backend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexManager getOrCreateIndexManager(String shardName, Properties indexProperties, Class<?> entityType, WorkerBuildContext context) {
        IndexManager indexManager;
        String indexName = this.indexNameBase;
        if (shardName != null) {
            indexName = indexName + INDEX_SHARD_ID_SEPARATOR + shardName;
        }
        if ((indexManager = (IndexManager)this.indexManagersRegistry.get(indexName)) != null) {
            indexManager.addContainedEntity(entityType);
            return indexManager;
        }
        IndexManagerGroupHolder indexManagerGroupHolder = this;
        synchronized (indexManagerGroupHolder) {
            indexManager = (IndexManager)this.indexManagersRegistry.get(indexName);
            if (indexManager != null) {
                indexManager.addContainedEntity(entityType);
                return indexManager;
            }
            if (shardName != null) {
                indexProperties = new MaskedProperty(indexProperties, shardName, indexProperties);
            }
            indexManager = this.doCreateIndexManager(indexName, entityType, indexProperties, context);
        }
        return indexManager;
    }

    private synchronized IndexManager doCreateIndexManager(String indexName, Class<?> entityType, Properties indexProperties, WorkerBuildContext workerBuildContext) {
        IndexManager manager;
        ExtendedSearchIntegrator activeIntegrator = null;
        if (workerBuildContext == null) {
            activeIntegrator = this.parentHolder.getActiveSearchIntegrator();
            workerBuildContext = this.toWorkerBuildContext(activeIntegrator);
        }
        ServiceManager serviceManager = workerBuildContext.getServiceManager();
        String indexManagerImplementationName = indexProperties.getProperty("indexmanager");
        try (ServiceReference<IndexManagerFactory> indexManagerFactoryRef = serviceManager.requestReference(IndexManagerFactory.class);){
            IndexManagerFactory indexManagerFactory = indexManagerFactoryRef.get();
            manager = StringHelper.isEmpty(indexManagerImplementationName) ? indexManagerFactory.createDefaultIndexManager() : indexManagerFactory.createIndexManagerByName(indexManagerImplementationName);
        }
        try {
            manager.initialize(indexName, indexProperties, this.similarity, workerBuildContext);
        }
        catch (Exception e) {
            throw log.unableToInitializeIndexManager(indexName, e);
        }
        this.indexManagersRegistry.put(indexName, manager);
        this.parentHolder.register(indexName, this);
        Backend backend = this.getOrCreateBackend(indexName, indexProperties, workerBuildContext);
        BackendQueueProcessor backendQueueProcessor = backend.createQueueProcessor(manager, workerBuildContext);
        this.parentHolder.register(indexName, manager, backendQueueProcessor);
        manager.addContainedEntity(entityType);
        if (activeIntegrator != null) {
            manager.setSearchFactory(activeIntegrator);
        }
        return manager;
    }

    private WorkerBuildContext toWorkerBuildContext(ExtendedSearchIntegrator integrator) {
        if (integrator instanceof WorkerBuildContext) {
            return (WorkerBuildContext)((Object)integrator);
        }
        throw log.assertionFailureCannotCastToWorkerBuilderContext(integrator.getClass());
    }
}

