/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.FieldSettingsDescriptor;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.PropertyDescriptor;
import org.hibernate.search.query.engine.impl.FieldNameCollector;
import org.hibernate.search.query.engine.impl.QueryFilters;
import org.hibernate.search.reader.impl.MultiReaderFactory;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.DefaultLogCategories;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class LazyQueryState
implements Closeable {
    private static final Log log = LoggerFactory.make();
    private static final Log QUERY_LOG = LoggerFactory.make(DefaultLogCategories.QUERY);
    private final Query userQuery;
    private final IndexSearcher searcher;
    private final boolean fieldSortDoTrackScores;
    private final boolean fieldSortDoMaxScore;
    private final ExtendedSearchIntegrator extendedIntegrator;
    private final Collection<EntityIndexBinding> targetedEntityBindings;
    private final QueryFilters facetingFilters;
    private Query rewrittenQuery;

    public LazyQueryState(Query userQuery, QueryFilters facetingFilters, IndexReader reader, Similarity searcherSimilarity, ExtendedSearchIntegrator extendedIntegrator, Collection<EntityIndexBinding> targetedEntityBindings, boolean fieldSortDoTrackScores, boolean fieldSortDoMaxScore) {
        this.userQuery = userQuery;
        this.facetingFilters = facetingFilters;
        this.fieldSortDoTrackScores = fieldSortDoTrackScores;
        this.fieldSortDoMaxScore = fieldSortDoMaxScore;
        this.searcher = new IndexSearcher(reader);
        this.searcher.setSimilarity(searcherSimilarity);
        this.extendedIntegrator = extendedIntegrator;
        this.targetedEntityBindings = targetedEntityBindings;
    }

    public boolean isFieldSortDoTrackScores() {
        return this.fieldSortDoTrackScores;
    }

    public boolean isFieldSortDoMaxScore() {
        return this.fieldSortDoMaxScore;
    }

    public Explanation explain(QueryFilters filters, int documentId) throws IOException {
        return this.searcher.explain(filters.filterOrPassthrough(this.rewrittenQuery()), documentId);
    }

    public Document doc(int docId) throws IOException {
        return this.searcher.doc(docId);
    }

    public void doc(int docId, StoredFieldVisitor fieldVisitor) throws IOException {
        this.searcher.doc(docId, fieldVisitor);
    }

    public int maxDoc() {
        return this.searcher.getIndexReader().maxDoc();
    }

    public void search(QueryFilters filters, Collector collector) throws IOException {
        this.validateQuery();
        QUERY_LOG.executingLuceneQuery(this.userQuery);
        this.searcher.search(filters.filterOrPassthrough(this.rewrittenQuery()), collector);
    }

    public IndexReader getIndexReader() {
        return this.searcher.getIndexReader();
    }

    @Override
    public void close() {
        IndexReader indexReader = this.searcher.getIndexReader();
        try {
            MultiReaderFactory.closeReader(indexReader);
        }
        catch (SearchException e) {
            log.unableToCloseSearcherDuringQuery(this.userQuery.toString(), e);
        }
    }

    public String describeQuery() {
        return this.userQuery.toString();
    }

    private void validateQuery() {
        HashSet<String> invalidFields;
        HashSet<String> stringEncodedFieldNames = new HashSet<String>();
        HashSet<String> numericEncodedFieldNames = new HashSet<String>();
        for (EntityIndexBinding binding : this.targetedEntityBindings) {
            IndexedTypeDescriptor indexedTypeDescriptor = this.extendedIntegrator.getIndexedTypeDescriptor(binding.getDocumentBuilder().getBeanClass());
            for (FieldDescriptor fieldDescriptor : indexedTypeDescriptor.getIndexedFields()) {
                this.putInFieldTypeBucket(stringEncodedFieldNames, numericEncodedFieldNames, fieldDescriptor);
            }
            for (PropertyDescriptor propertyDescriptor : indexedTypeDescriptor.getIndexedProperties()) {
                for (FieldDescriptor fieldDescriptor : propertyDescriptor.getIndexedFields()) {
                    this.putInFieldTypeBucket(stringEncodedFieldNames, numericEncodedFieldNames, fieldDescriptor);
                }
            }
        }
        FieldNameCollector.FieldCollection fieldCollection = FieldNameCollector.extractFieldNames(this.userQuery);
        if (!Collections.disjoint(stringEncodedFieldNames, fieldCollection.getNumericFieldNames())) {
            invalidFields = new HashSet<String>();
            for (String numericField : fieldCollection.getNumericFieldNames()) {
                if (!stringEncodedFieldNames.contains(numericField)) continue;
                invalidFields.add(numericField);
            }
            throw log.stringEncodedFieldsAreTargetedWithNumericQuery(this.userQuery.toString(), StringHelper.join(invalidFields, ","));
        }
        if (!Collections.disjoint(numericEncodedFieldNames, fieldCollection.getStringFieldNames())) {
            invalidFields = new HashSet();
            for (String stringField : fieldCollection.getStringFieldNames()) {
                if (!numericEncodedFieldNames.contains(stringField)) continue;
                invalidFields.add(stringField);
            }
            throw log.numericEncodedFieldsAreTargetedWithStringQuery(this.userQuery.toString(), StringHelper.join(invalidFields, ","));
        }
    }

    private void putInFieldTypeBucket(Set<String> stringEncodedFieldNames, Set<String> numericEncodedFieldNames, FieldDescriptor fieldDescriptor) {
        if (FieldSettingsDescriptor.Type.NUMERIC.equals((Object)fieldDescriptor.getType())) {
            if (!fieldDescriptor.indexNull()) {
                numericEncodedFieldNames.add(fieldDescriptor.getName());
            }
        } else {
            stringEncodedFieldNames.add(fieldDescriptor.getName());
        }
    }

    private Query rewrittenQuery() throws IOException {
        if (this.rewrittenQuery == null) {
            Query effectiveQuery = this.facetingFilters.filterOrPassthrough(this.userQuery);
            this.rewrittenQuery = effectiveQuery.rewrite(this.searcher.getIndexReader());
        }
        return this.rewrittenQuery;
    }
}

