/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.StandardFilterKey;
import org.hibernate.search.filter.impl.CachingWrapperQuery;
import org.hibernate.search.filter.impl.DefaultFilterKey;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.engine.impl.AbstractHSQuery;
import org.hibernate.search.query.engine.impl.DocumentExtractorImpl;
import org.hibernate.search.query.engine.impl.FacetManagerImpl;
import org.hibernate.search.query.engine.impl.LazyQueryState;
import org.hibernate.search.query.engine.impl.QueryFilters;
import org.hibernate.search.query.engine.impl.QueryHits;
import org.hibernate.search.query.engine.impl.SortConfigurations;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.reader.impl.MultiReaderFactory;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.FilterCacheModeTypeHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneHSQuery
extends AbstractHSQuery
implements HSQuery {
    static final Log log = LoggerFactory.make();
    private static final FullTextFilterImplementor[] EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR = new FullTextFilterImplementor[0];
    private static final Set<String> SUPPORTED_PROJECTION_CONSTANTS = Collections.unmodifiableSet(CollectionHelper.asSet("__HSearch_Document", "__HSearch_DocumentId", "__HSearch_Explanation", "__HSearch_id", "_hibernate_class", "__HSearch_Score", "_HSearch_SpatialDistance", "__HSearch_This"));
    private Query luceneQuery;
    private boolean allowFieldSelectionInProjection = true;
    private transient Map<String, EntityIndexBinding> targetedEntityBindingsByName;
    private boolean needClassFilterClause;
    private Set<String> idFieldNames;
    private transient FacetManagerImpl facetManager;
    private Integer resultSize;

    public LuceneHSQuery(ExtendedSearchIntegrator extendedIntegrator) {
        super(extendedIntegrator);
    }

    @Override
    public HSQuery luceneQuery(Query query) {
        this.clearCachedResults();
        this.luceneQuery = query;
        return this;
    }

    @Override
    protected TimeoutManagerImpl buildTimeoutManager() {
        if (this.luceneQuery == null) {
            throw new AssertionFailure("Requesting TimeoutManager before setting luceneQuery()");
        }
        return new TimeoutManagerImpl(this.luceneQuery, this.timeoutExceptionFactory, this.extendedIntegrator.getTimingSource());
    }

    @Override
    public FacetManagerImpl getFacetManager() {
        if (this.facetManager == null) {
            this.facetManager = new FacetManagerImpl(this);
        }
        return this.facetManager;
    }

    @Override
    public Query getLuceneQuery() {
        return this.luceneQuery;
    }

    @Override
    public List<EntityInfo> queryEntityInfos() {
        LazyQueryState searcher = this.buildSearcher();
        if (searcher == null) {
            return Collections.emptyList();
        }
        try {
            int size;
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.firstResult;
            int max = this.max(first, queryHits.getTotalHits());
            int n = size = max - first + 1 < 0 ? 0 : max - first + 1;
            if (size == 0) {
                List<EntityInfo> list = Collections.emptyList();
                return list;
            }
            ArrayList<EntityInfo> infos = new ArrayList<EntityInfo>(size);
            DocumentExtractor extractor = this.buildDocumentExtractor(searcher, queryHits, first, max);
            for (int index = first; index <= max; ++index) {
                infos.add(extractor.extract(index));
                if (index % 10 != 0) continue;
                this.getTimeoutManager().isTimedOut();
            }
            ArrayList<EntityInfo> arrayList = infos;
            return arrayList;
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index", e);
        }
        finally {
            this.closeSearcher(searcher);
        }
    }

    private DocumentExtractor buildDocumentExtractor(LazyQueryState searcher, QueryHits queryHits, int first, int max) {
        return new DocumentExtractorImpl(queryHits, this.extendedIntegrator, this.projectedFields, this.idFieldNames, this.allowFieldSelectionInProjection, searcher, first, max, this.targetedEntityBindingsByName);
    }

    @Override
    public DocumentExtractor queryDocumentExtractor() {
        LazyQueryState openSearcher = this.buildSearcher();
        try {
            QueryHits queryHits = this.getQueryHits(openSearcher, this.calculateTopDocsRetrievalSize());
            int max = this.max(this.firstResult, queryHits.getTotalHits());
            return this.buildDocumentExtractor(openSearcher, queryHits, this.firstResult, max);
        }
        catch (IOException e) {
            this.closeSearcher(openSearcher);
            throw new SearchException("Unable to query Lucene index", e);
        }
    }

    @Override
    public int queryResultSize() {
        if (this.resultSize == null) {
            this.getTimeoutManager().start();
            LazyQueryState searcher = this.buildSearcher(this.extendedIntegrator, false);
            if (searcher == null) {
                this.resultSize = 0;
            } else {
                try {
                    QueryHits queryHits = this.getQueryHits(searcher, 0);
                    this.resultSize = queryHits.getTotalHits();
                }
                catch (IOException e) {
                    throw new SearchException("Unable to query Lucene index", e);
                }
                finally {
                    this.closeSearcher(searcher);
                }
            }
        }
        return this.resultSize;
    }

    @Override
    public Explanation explain(int documentId) {
        Explanation explanation = null;
        LazyQueryState searcher = this.buildSearcher(this.extendedIntegrator, true);
        if (searcher == null) {
            throw new SearchException("Unable to build explanation for document id:" + documentId + ". no index found");
        }
        try {
            QueryFilters filters = this.createFilters();
            explanation = searcher.explain(filters, documentId);
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index and build explanation", e);
        }
        finally {
            this.closeSearcher(searcher);
        }
        return explanation;
    }

    private void closeSearcher(LazyQueryState searcherWithPayload) {
        if (searcherWithPayload == null) {
            return;
        }
        searcherWithPayload.close();
    }

    @Override
    protected void clearCachedResults() {
        this.resultSize = null;
    }

    @Override
    protected void extractFacetResults() {
        DocumentExtractor queryDocumentExtractor = this.queryDocumentExtractor();
        queryDocumentExtractor.close();
    }

    @Override
    protected Set<String> getSupportedProjectionConstants() {
        return SUPPORTED_PROJECTION_CONSTANTS;
    }

    private QueryHits getQueryHits(LazyQueryState searcher, Integer n) throws IOException {
        QueryFilters filters = this.createFilters();
        boolean stats = this.extendedIntegrator.getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.nanoTime();
        }
        Collection<FacetingRequest> facetingRequests = this.getFacetManager().getFacetRequests().values();
        Map<FacetingRequest, FacetMetadata> facetingRequestsAndMetadata = this.buildFacetingRequestsAndMetadata(facetingRequests, this.targetedEntityBindingsByName.values());
        QueryHits queryHits = n == null ? new QueryHits(searcher, filters, this.sort, this.getTimeoutManager(), facetingRequestsAndMetadata, this.timeoutExceptionFactory, this.spatialSearchCenter, this.spatialFieldName) : (0 == n ? new QueryHits(searcher, filters, null, 0, this.getTimeoutManager(), null, this.timeoutExceptionFactory, this.spatialSearchCenter, this.spatialFieldName) : new QueryHits(searcher, filters, this.sort, n, this.getTimeoutManager(), facetingRequestsAndMetadata, this.timeoutExceptionFactory, this.spatialSearchCenter, this.spatialFieldName));
        this.resultSize = queryHits.getTotalHits();
        if (stats) {
            this.extendedIntegrator.getStatisticsImplementor().searchExecuted(searcher.describeQuery(), System.nanoTime() - startTime);
        }
        this.getFacetManager().setFacetResults(queryHits.getFacets());
        return queryHits;
    }

    private Integer calculateTopDocsRetrievalSize() {
        if (this.maxResults == null) {
            return null;
        }
        long tmpMaxResult = (long)this.firstResult + (long)this.maxResults.intValue();
        if (tmpMaxResult >= Integer.MAX_VALUE) {
            return 0x7FFFFFFE;
        }
        if (tmpMaxResult == 0L) {
            return 1;
        }
        return (int)tmpMaxResult;
    }

    private LazyQueryState buildSearcher() {
        return this.buildSearcher(this.extendedIntegrator, null);
    }

    private LazyQueryState buildSearcher(ExtendedSearchIntegrator extendedIntegrator, Boolean forceScoring) {
        HashSet<IndexManager> targetedIndexes = new HashSet<IndexManager>();
        HashSet<String> idFieldNames = new HashSet<String>();
        Similarity searcherSimilarity = null;
        SortConfigurations.Builder sortConfigurations = new SortConfigurations.Builder();
        this.targetedEntityBindingsByName = this.buildTargetedEntityIndexBindingsByName();
        for (EntityIndexBinding entityIndexBinding : this.targetedEntityBindingsByName.values()) {
            DocumentBuilderIndexedEntity builder = entityIndexBinding.getDocumentBuilder();
            Class<?> clazz = builder.getBeanClass();
            searcherSimilarity = this.checkSimilarity(searcherSimilarity, entityIndexBinding.getSimilarity());
            if (builder.getIdFieldName() != null) {
                idFieldNames.add(builder.getIdFieldName());
                this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
            }
            List<IndexManager> list = this.getIndexManagers(entityIndexBinding);
            targetedIndexes.addAll(list);
            Optional<CustomTypeMetadata> customTypeMetadata = this.getCustomTypeMetadata(clazz);
            this.collectSortableFields(sortConfigurations, list, builder.getTypeMetadata(), customTypeMetadata);
        }
        this.idFieldNames = idFieldNames;
        if (targetedIndexes.isEmpty()) {
            return null;
        }
        if (this.indexedTargetedEntities.size() > 0) {
            for (IndexManager indexManager : targetedIndexes) {
                Set<Class<?>> classesInIndexManager = indexManager.getContainedTypes();
                if (classesInIndexManager.size() > 1) {
                    for (Class clazz : classesInIndexManager) {
                        if (this.targetedEntityBindingsByName.containsKey(clazz.getName())) continue;
                        this.needClassFilterClause = true;
                        break;
                    }
                }
                if (!this.needClassFilterClause) continue;
                break;
            }
        }
        if (this.sort != null) {
            this.validateSortFields(this.targetedEntityBindingsByName.values());
        }
        IndexManager[] indexManagers = targetedIndexes.toArray(new IndexManager[targetedIndexes.size()]);
        IndexReader compoundReader = MultiReaderFactory.openReader(sortConfigurations.build(), this.sort, indexManagers, extendedIntegrator.isIndexUninvertingAllowed());
        Query filteredQuery = this.filterQueryByTenantId(this.filterQueryByClasses(this.luceneQuery));
        QueryFilters facetingFilters = this.getFacetManager().getFacetFilters();
        String[] stringArray = this.projectedFields;
        Collection<EntityIndexBinding> targetedEntityBindings = this.targetedEntityBindingsByName.values();
        if (Boolean.TRUE.equals(forceScoring)) {
            return new LazyQueryState(filteredQuery, facetingFilters, compoundReader, searcherSimilarity, extendedIntegrator, targetedEntityBindings, true, true);
        }
        if (Boolean.FALSE.equals(forceScoring)) {
            return new LazyQueryState(filteredQuery, facetingFilters, compoundReader, searcherSimilarity, extendedIntegrator, targetedEntityBindings, false, false);
        }
        if (this.sort != null && stringArray != null) {
            boolean activate = false;
            for (String field : stringArray) {
                if (!"__HSearch_Score".equals(field)) continue;
                activate = true;
                break;
            }
            if (activate) {
                return new LazyQueryState(filteredQuery, facetingFilters, compoundReader, searcherSimilarity, extendedIntegrator, targetedEntityBindings, true, false);
            }
        }
        return new LazyQueryState(filteredQuery, facetingFilters, compoundReader, searcherSimilarity, extendedIntegrator, targetedEntityBindings, false, false);
    }

    private void collectSortableFields(SortConfigurations.Builder sortConfigurations, Iterable<IndexManager> indexManagers, TypeMetadata typeMetadata, Optional<CustomTypeMetadata> customTypeMetadataOptional) {
        for (IndexManager indexManager : indexManagers) {
            sortConfigurations.setIndex(indexManager.getIndexName());
            sortConfigurations.setEntityType(typeMetadata.getType());
            sortConfigurations.addSortableFields(typeMetadata.getClassBridgeSortableFieldMetadata());
            sortConfigurations.addSortableFields(typeMetadata.getIdPropertyMetadata().getSortableFieldMetadata());
            for (PropertyMetadata property : typeMetadata.getAllPropertyMetadata()) {
                sortConfigurations.addSortableFields(property.getSortableFieldMetadata());
            }
            for (EmbeddedTypeMetadata embeddedType : typeMetadata.getEmbeddedTypeMetadata()) {
                this.collectSortableFields(sortConfigurations, embeddedType);
            }
            if (!customTypeMetadataOptional.isPresent()) continue;
            CustomTypeMetadata customTypeMetadata = customTypeMetadataOptional.get();
            for (String fieldName : customTypeMetadata.getSortableFields()) {
                sortConfigurations.addSortableField(new SortableFieldMetadata.Builder(fieldName).build());
            }
        }
    }

    private void collectSortableFields(SortConfigurations.Builder sortConfigurations, EmbeddedTypeMetadata embeddedTypeMetadata) {
        sortConfigurations.addSortableFields(embeddedTypeMetadata.getClassBridgeSortableFieldMetadata());
        for (PropertyMetadata property : embeddedTypeMetadata.getAllPropertyMetadata()) {
            sortConfigurations.addSortableFields(property.getSortableFieldMetadata());
        }
        for (EmbeddedTypeMetadata embeddedType : embeddedTypeMetadata.getEmbeddedTypeMetadata()) {
            this.collectSortableFields(sortConfigurations, embeddedType);
        }
    }

    private Similarity checkSimilarity(Similarity similarity, Similarity entitySimilarity) {
        if (similarity == null) {
            similarity = entitySimilarity;
        } else if (!similarity.getClass().equals(entitySimilarity.getClass())) {
            throw new SearchException("Cannot perform search on two entities with differing Similarity implementations (" + similarity.getClass().getName() + " & " + entitySimilarity.getClass().getName() + ")");
        }
        return similarity;
    }

    private List<IndexManager> getIndexManagers(EntityIndexBinding binding) {
        FullTextFilterImplementor[] fullTextFilters = this.getFullTextFilters();
        List<IndexManager> indexManagers = Arrays.asList(binding.getSelectionStrategy().getIndexManagersForQuery(fullTextFilters));
        for (IndexManager indexManager : indexManagers) {
            if (indexManager instanceof DirectoryBasedIndexManager) continue;
            throw log.cannotRunLuceneQueryTargetingEntityIndexedWithNonDirectoryBasedIndexManager(binding.getDocumentBuilder().getBeanClass(), this.luceneQuery.toString());
        }
        return indexManagers;
    }

    private FullTextFilterImplementor[] getFullTextFilters() {
        FullTextFilterImplementor[] fullTextFilters = this.filterDefinitions != null && !this.filterDefinitions.isEmpty() ? this.filterDefinitions.values().toArray(new FullTextFilterImplementor[this.filterDefinitions.size()]) : EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR;
        return fullTextFilters;
    }

    private QueryFilters createFilters() {
        ArrayList<Query> filterQueries = new ArrayList<Query>();
        if (!this.filterDefinitions.isEmpty()) {
            for (FullTextFilterImpl fullTextFilter : this.filterDefinitions.values()) {
                Query filter = this.buildLuceneFilter(fullTextFilter);
                if (filter == null) continue;
                filterQueries.add(filter);
            }
        }
        if (this.userFilter != null) {
            filterQueries.add((Query)this.userFilter);
        }
        if (filterQueries.isEmpty()) {
            return QueryFilters.EMPTY_FILTERSET;
        }
        return new QueryFilters(filterQueries);
    }

    private Query buildLuceneFilter(FullTextFilterImpl fullTextFilter) {
        FilterDef def = this.extendedIntegrator.getFilterDefinition(fullTextFilter.getName());
        if (this.isPreQueryFilterOnly(def)) {
            return null;
        }
        if (!FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode())) {
            Object filterOrFactory = this.createFilterInstance(fullTextFilter, def);
            return this.createFilterQuery(def, filterOrFactory);
        }
        return this.createOrGetLuceneFilterFromCache(fullTextFilter, def);
    }

    private Query createOrGetLuceneFilterFromCache(FullTextFilterImpl fullTextFilter, FilterDef def) {
        boolean hasCustomKey = def.getKeyMethod() != null;
        Object filterOrFactory = hasCustomKey ? this.createFilterInstance(fullTextFilter, def) : null;
        FilterKey key = this.createFilterKey(def, filterOrFactory, fullTextFilter);
        Query filterQuery = this.extendedIntegrator.getFilterCachingStrategy().getCachedFilter(key);
        if (filterQuery == null) {
            filterQuery = this.createFilterQuery(def, hasCustomKey ? filterOrFactory : this.createFilterInstance(fullTextFilter, def));
            this.extendedIntegrator.getFilterCachingStrategy().addCachedFilter(key, filterQuery);
        }
        return filterQuery;
    }

    private Query createFilterQuery(FilterDef def, Object filterOrFactory) {
        Query filterQuery;
        if (def.getFactoryMethod() != null) {
            try {
                filterQuery = (Query)def.getFactoryMethod().invoke(filterOrFactory, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
            catch (ClassCastException e) {
                throw new SearchException("Factory method does not return a org.apache.lucene.search.Query class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
        }
        try {
            filterQuery = (Query)filterOrFactory;
        }
        catch (ClassCastException e) {
            throw new SearchException("Filter implementation does not extend the Query class: " + def.getImpl().getName() + ". " + (def.getFactoryMethod() != null ? def.getFactoryMethod().getName() : ""), e);
        }
        return this.addCachingWrapper(filterQuery, def);
    }

    private Query addCachingWrapper(Query filterQuery, FilterDef def) {
        if (FilterCacheModeTypeHelper.cacheResults(def.getCacheMode())) {
            int cacheSize = this.extendedIntegrator.getFilterCacheBitResultsSize();
            filterQuery = new CachingWrapperQuery(filterQuery, cacheSize);
        }
        return filterQuery;
    }

    private FilterKey createFilterKey(FilterDef def, Object filterOrFactory, FullTextFilterImpl fullTextFilter) {
        FilterKey key = null;
        if (def.getKeyMethod() == null) {
            key = new DefaultFilterKey(def.getName(), fullTextFilter.getParameters());
        } else {
            try {
                key = (FilterKey)def.getKeyMethod().invoke(filterOrFactory, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return FilterKey: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            key.setImpl(def.getImpl());
            StandardFilterKey wrapperKey = new StandardFilterKey();
            wrapperKey.addParameter(def.getName());
            wrapperKey.addParameter(key);
            key = wrapperKey;
        }
        return key;
    }

    private Query filterQueryByClasses(Query luceneQuery) {
        if (!this.needClassFilterClause) {
            return luceneQuery;
        }
        BooleanQuery.Builder classFilterBuilder = new BooleanQuery.Builder();
        for (String typeName : this.targetedEntityBindingsByName.keySet()) {
            Term t = new Term("_hibernate_class", typeName);
            TermQuery termQuery = new TermQuery(t);
            classFilterBuilder.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery classFilter = classFilterBuilder.build();
        BooleanQuery.Builder combinedQueryBuilder = new BooleanQuery.Builder();
        combinedQueryBuilder.add(luceneQuery, BooleanClause.Occur.MUST);
        combinedQueryBuilder.add((Query)classFilter, BooleanClause.Occur.FILTER);
        return combinedQueryBuilder.build();
    }

    private Query filterQueryByTenantId(Query luceneQuery) {
        if (this.tenantId == null) {
            return luceneQuery;
        }
        TermQuery tenantIdFilter = new TermQuery(new Term("__HSearch_TenantId", this.tenantId));
        tenantIdFilter.setBoost(0.0f);
        BooleanQuery.Builder combinedQueryBuilder = new BooleanQuery.Builder();
        combinedQueryBuilder.add(luceneQuery, BooleanClause.Occur.MUST);
        combinedQueryBuilder.add((Query)tenantIdFilter, BooleanClause.Occur.FILTER);
        return combinedQueryBuilder.build();
    }

    private int max(int first, int totalHits) {
        if (this.maxResults == null) {
            return totalHits - 1;
        }
        return this.maxResults + first < totalHits ? first + this.maxResults - 1 : totalHits - 1;
    }

    @Override
    public String getQueryString() {
        return String.valueOf(this.luceneQuery);
    }
}

