/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.ElasticsearchHostsSniffer;
import org.elasticsearch.client.sniff.HostsSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.hibernate.search.elasticsearch.client.impl.DefaultElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientFactory;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.elasticsearch.client.impl.ServerUris;
import org.hibernate.search.elasticsearch.client.spi.ElasticsearchHttpClientConfigurer;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.SearchThreadFactory;

public class DefaultElasticsearchClientFactory
implements ElasticsearchClientFactory,
Startable,
Stoppable {
    private ServiceManager serviceManager;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
    }

    public void stop() {
        this.serviceManager = null;
    }

    @Override
    public ElasticsearchClientImplementor create(Properties properties) {
        int requestTimeoutMs = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.request_timeout", (int)60000);
        RestClient restClient = this.createClient(properties, requestTimeoutMs);
        Sniffer sniffer = this.createSniffer(restClient, properties);
        return new DefaultElasticsearchClient(restClient, sniffer, requestTimeoutMs, TimeUnit.MILLISECONDS);
    }

    private RestClient createClient(Properties properties, int maxRetryTimeoutMillis) {
        String serverUrisString = ConfigurationParseHelper.getString((Properties)properties, (String)"elasticsearch.host", (String)"http://localhost:9200");
        ServerUris hosts = ServerUris.fromString(serverUrisString);
        return RestClient.builder((HttpHost[])hosts.asHostsArray()).setMaxRetryTimeoutMillis(maxRetryTimeoutMillis).setRequestConfigCallback(b -> this.customizeRequestConfig(properties, b)).setHttpClientConfigCallback(b -> this.customizeHttpClientConfig(properties, hosts, b)).build();
    }

    private Sniffer createSniffer(RestClient client, Properties properties) {
        boolean discoveryEnabled = ConfigurationParseHelper.getBooleanValue((Properties)properties, (String)"elasticsearch.discovery.enabled", (boolean)false);
        if (discoveryEnabled) {
            SnifferBuilder builder = Sniffer.builder((RestClient)client).setSniffIntervalMillis(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.discovery.refresh_interval", (int)10) * 1000);
            String scheme = ConfigurationParseHelper.getString((Properties)properties, (String)"elasticsearch.discovery.default_scheme", (String)"http");
            if (scheme.equals(ElasticsearchHostsSniffer.Scheme.HTTPS.toString())) {
                ElasticsearchHostsSniffer hostsSniffer = new ElasticsearchHostsSniffer(client, ElasticsearchHostsSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, ElasticsearchHostsSniffer.Scheme.HTTPS);
                builder.setHostsSniffer((HostsSniffer)hostsSniffer);
            }
            return builder.build();
        }
        return null;
    }

    private HttpAsyncClientBuilder customizeHttpClientConfig(Properties properties, ServerUris hosts, HttpAsyncClientBuilder builder) {
        String username;
        builder = builder.setMaxConnTotal(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.max_total_connection", (int)20)).setMaxConnPerRoute(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.max_total_connection_per_route", (int)2)).setThreadFactory((ThreadFactory)new SearchThreadFactory("Elasticsearch transport thread"));
        if (!hosts.isAnyRequiringSSL()) {
            builder.setSSLStrategy((SchemeIOSessionStrategy)NoopIOSessionStrategy.INSTANCE);
        }
        if ((username = ConfigurationParseHelper.getString((Properties)properties, (String)"elasticsearch.username", null)) != null) {
            String password = ConfigurationParseHelper.getString((Properties)properties, (String)"elasticsearch.password", null);
            if (password != null) {
                hosts.warnPasswordsOverHttp();
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(username, password));
            builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        Iterable configurers = this.serviceManager.getClassLoaderService().loadJavaServices(ElasticsearchHttpClientConfigurer.class);
        for (ElasticsearchHttpClientConfigurer configurer : configurers) {
            configurer.configure(builder, properties);
        }
        return builder;
    }

    private RequestConfig.Builder customizeRequestConfig(Properties properties, RequestConfig.Builder builder) {
        return builder.setConnectionRequestTimeout(0).setSocketTimeout(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.read_timeout", (int)60000)).setConnectTimeout(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.connection_timeout", (int)3000));
    }
}

