/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import java.io.IOException;
import java.util.Properties;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerStrategyFactory;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientFactory;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.elasticsearch.dialect.impl.ElasticsearchDialect;
import org.hibernate.search.elasticsearch.dialect.impl.ElasticsearchDialectFactory;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.impl.ElasticsearchQueryOptions;
import org.hibernate.search.elasticsearch.impl.ElasticsearchService;
import org.hibernate.search.elasticsearch.nulls.impl.ElasticsearchMissingValueStrategy;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.elasticsearch.query.impl.ElasticsearchQueryFactory;
import org.hibernate.search.elasticsearch.schema.impl.DefaultElasticsearchSchemaCreator;
import org.hibernate.search.elasticsearch.schema.impl.DefaultElasticsearchSchemaDropper;
import org.hibernate.search.elasticsearch.schema.impl.DefaultElasticsearchSchemaMigrator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.impl.Closer;

public class DefaultElasticsearchService
implements ElasticsearchService,
Startable,
Stoppable {
    private ElasticsearchClient client;
    private GsonProvider gsonProvider;
    private ElasticsearchWorkFactory workFactory;
    private ElasticsearchWorkProcessor workProcessor;
    private ElasticsearchSchemaCreator schemaCreator;
    private ElasticsearchSchemaDropper schemaDropper;
    private ElasticsearchSchemaMigrator schemaMigrator;
    private ElasticsearchSchemaValidator schemaValidator;
    private ElasticsearchSchemaTranslator schemaTranslator;
    private ElasticsearchAnalyzerStrategyFactory analyzerStrategyFactory;
    private MissingValueStrategy missingValueStrategy;
    private ElasticsearchQueryFactory queryFactory;
    private ElasticsearchQueryOptions queryOptions;

    public void start(Properties unkmaskedProperties, BuildContext context) {
        ElasticsearchClientImplementor clientImplementor;
        MaskedProperty rootCfg = new MaskedProperty(unkmaskedProperties, "hibernate.search");
        MaskedProperty properties = new MaskedProperty((Properties)rootCfg, "default", (Properties)rootCfg);
        ServiceManager serviceManager = context.getServiceManager();
        this.queryOptions = this.createQueryOptions((Properties)properties);
        try (ServiceReference clientFactory = serviceManager.requestReference(ElasticsearchClientFactory.class);){
            clientImplementor = ((ElasticsearchClientFactory)clientFactory.get()).create((Properties)properties);
        }
        var8_7 = null;
        try (ServiceReference dialectFactory = serviceManager.requestReference(ElasticsearchDialectFactory.class);){
            ElasticsearchDialect dialect = ((ElasticsearchDialectFactory)dialectFactory.get()).createDialect(clientImplementor, (Properties)properties);
            this.gsonProvider = dialect.createGsonProvider();
            clientImplementor.init(this.gsonProvider);
            this.client = clientImplementor;
            this.workFactory = dialect.createWorkFactory(this.gsonProvider);
            this.workProcessor = new ElasticsearchWorkProcessor(context, this.client, this.gsonProvider, this.workFactory);
            ElasticsearchSchemaAccessor schemaAccessor = new ElasticsearchSchemaAccessor(this.workFactory, this.workProcessor);
            this.schemaValidator = dialect.createSchemaValidator(schemaAccessor);
            this.schemaTranslator = dialect.createSchemaTranslator();
            this.schemaCreator = new DefaultElasticsearchSchemaCreator(schemaAccessor);
            this.schemaDropper = new DefaultElasticsearchSchemaDropper(schemaAccessor);
            this.schemaMigrator = new DefaultElasticsearchSchemaMigrator(schemaAccessor, this.schemaValidator);
            this.analyzerStrategyFactory = dialect.createAnalyzerStrategyFactory(serviceManager);
            this.missingValueStrategy = new ElasticsearchMissingValueStrategy(this.schemaTranslator);
            this.queryFactory = dialect.createQueryFactory();
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
    }

    public void stop() {
        try (Closer closer = new Closer();){
            if (this.workProcessor != null) {
                closer.push(this.workProcessor::close);
            }
            if (this.client != null) {
                closer.push(this.client::close);
            }
            this.client = null;
        }
        catch (IOException | RuntimeException e) {
            throw new SearchException("Failed to shut down the Elasticsearch service", (Throwable)e);
        }
    }

    @Override
    public GsonProvider getGsonProvider() {
        return this.gsonProvider;
    }

    @Override
    public ElasticsearchWorkFactory getWorkFactory() {
        return this.workFactory;
    }

    @Override
    public ElasticsearchWorkProcessor getWorkProcessor() {
        return this.workProcessor;
    }

    @Override
    public ElasticsearchSchemaCreator getSchemaCreator() {
        return this.schemaCreator;
    }

    @Override
    public ElasticsearchSchemaDropper getSchemaDropper() {
        return this.schemaDropper;
    }

    @Override
    public ElasticsearchSchemaMigrator getSchemaMigrator() {
        return this.schemaMigrator;
    }

    @Override
    public ElasticsearchSchemaValidator getSchemaValidator() {
        return this.schemaValidator;
    }

    @Override
    public ElasticsearchSchemaTranslator getSchemaTranslator() {
        return this.schemaTranslator;
    }

    @Override
    public ElasticsearchAnalyzerStrategyFactory getAnalyzerStrategyFactory() {
        return this.analyzerStrategyFactory;
    }

    @Override
    public MissingValueStrategy getMissingValueStrategy() {
        return this.missingValueStrategy;
    }

    @Override
    public ElasticsearchQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    @Override
    public ElasticsearchQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    private ElasticsearchQueryOptions createQueryOptions(Properties properties) {
        String scrollTimeout = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.scroll_timeout", (int)60) + "s";
        int scrollFetchSize = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.scroll_fetch_size", (int)1000);
        int scrollBacktrackingWindowSize = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.scroll_backtracking_window_size", (int)10000);
        return new ElasticsearchQueryOptionsImpl(scrollTimeout, scrollFetchSize, scrollBacktrackingWindowSize);
    }

    private static class ElasticsearchQueryOptionsImpl
    implements ElasticsearchQueryOptions {
        private final String scrollTimeout;
        private final int scrollFetchSize;
        private final int scrollBacktrackingWindowSize;

        public ElasticsearchQueryOptionsImpl(String scrollTimeout, int scrollFetchSize, int scrollBacktrackingWindowSize) {
            this.scrollTimeout = scrollTimeout;
            this.scrollFetchSize = scrollFetchSize;
            this.scrollBacktrackingWindowSize = scrollBacktrackingWindowSize;
        }

        @Override
        public String getScrollTimeout() {
            return this.scrollTimeout;
        }

        @Override
        public int getScrollFetchSize() {
            return this.scrollFetchSize;
        }

        @Override
        public int getScrollBacktrackingWindowSize() {
            return this.scrollBacktrackingWindowSize;
        }
    }
}

