/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.logging.impl;

import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.util.impl.JsonLogHelper;

public class ElasticsearchRequestFormatter {
    private final String stringRepresentation;

    public ElasticsearchRequestFormatter(ElasticsearchRequest request) {
        this.stringRepresentation = ElasticsearchRequestFormatter.formatRequest(request);
    }

    private static String formatRequest(ElasticsearchRequest request) {
        StringBuilder sb = new StringBuilder(180);
        sb.append("Method: ").append(request.getMethod());
        sb.append("\nPath: ").append(request.getPath());
        sb.append("\nData:\n");
        JsonLogHelper.prettyPrint(sb, request.getBodyParts());
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

