/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.util.impl.JsonLogHelper;

public class ElasticsearchResponseFormatter {
    private final String stringRepresentation;

    public ElasticsearchResponseFormatter(ElasticsearchResponse response) {
        this.stringRepresentation = ElasticsearchResponseFormatter.formatResponse(response);
    }

    public static String formatResponse(ElasticsearchResponse response) {
        if (response == null) {
            return null;
        }
        JsonObject body = response.getBody();
        StringBuilder sb = new StringBuilder(180);
        sb.append("Status: ").append(response.getStatusCode()).append(" ").append(response.getStatusMessage());
        sb.append("\nError message: ").append(JsonLogHelper.propertyAsString((JsonElement)body, "error"));
        sb.append("\nCluster name: ").append(JsonLogHelper.propertyAsString((JsonElement)body, "cluster_name"));
        sb.append("\nCluster status: ").append(JsonLogHelper.propertyAsString((JsonElement)body, "status"));
        sb.append("\n\n");
        JsonElement items = JsonLogHelper.property(body, "items");
        if (items != null && items.isJsonArray()) {
            for (JsonElement item : items.getAsJsonArray()) {
                for (Map.Entry entry : item.getAsJsonObject().entrySet()) {
                    sb.append("Operation: ").append((String)entry.getKey());
                    JsonElement value = (JsonElement)entry.getValue();
                    sb.append("\n  Index: ").append(JsonLogHelper.propertyAsString(value, "_index"));
                    sb.append("\n  Type: ").append(JsonLogHelper.propertyAsString(value, "_type"));
                    sb.append("\n  Id: ").append(JsonLogHelper.propertyAsString(value, "_id"));
                    sb.append("\n  Status: ").append(JsonLogHelper.propertyAsString(value, "status"));
                    sb.append("\n  Error: ").append(JsonLogHelper.propertyAsString(value, "error"));
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

