/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.hibernate.search.elasticsearch.spi.DigestSelfSigningCapable;
import org.hibernate.search.exception.SearchException;

public final class GsonHttpEntity
implements HttpEntity,
HttpAsyncContentProducer,
DigestSelfSigningCapable {
    private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
    private static final BasicHeader CONTENT_TYPE = new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
    private static final int BUFFER_SIZES = 1024;
    private final Gson gson;
    private final List<JsonObject> bodyParts;
    private long contentLength;
    private boolean contentlengthWasProvided = false;
    private int nextBodyToEncodeIndex = 0;
    private ProgressiveCharBufferWriter writer = new ProgressiveCharBufferWriter();
    private BufferedWriter bufferedWriter = new BufferedWriter(this.writer, 1024);

    public GsonHttpEntity(Gson gson, List<JsonObject> bodyParts) {
        Objects.requireNonNull(gson);
        Objects.requireNonNull(bodyParts);
        this.gson = gson;
        this.bodyParts = bodyParts;
        this.contentLength = this.attemptOnePassEncoding();
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        this.contentlengthWasProvided = true;
        return this.contentLength;
    }

    public Header getContentType() {
        return CONTENT_TYPE;
    }

    public Header getContentEncoding() {
        return null;
    }

    public InputStream getContent() throws IOException {
        throw new UnsupportedOperationException("Not implemented! Expected to produce content only over produceContent()");
    }

    public void writeTo(OutputStream outstream) throws IOException {
        throw new UnsupportedOperationException("Not implemented! Expected to produce content only over produceContent()");
    }

    public boolean isStreaming() {
        return false;
    }

    public void consumeContent() throws IOException {
    }

    public void close() throws IOException {
        this.nextBodyToEncodeIndex = 0;
        this.writer = new ProgressiveCharBufferWriter();
        this.bufferedWriter = new BufferedWriter(this.writer, 1024);
    }

    private long attemptOnePassEncoding() {
        try {
            this.triggerFullWrite();
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
        if (!this.writer.flowControlPushingBack) {
            return this.writer.availableBuffer.position();
        }
        return -1L;
    }

    private void triggerFullWrite() throws IOException {
        while (this.nextBodyToEncodeIndex < this.bodyParts.size()) {
            JsonObject bodyPart = this.bodyParts.get(this.nextBodyToEncodeIndex++);
            this.gson.toJson((JsonElement)bodyPart, (Appendable)this.bufferedWriter);
            this.bufferedWriter.append('\n');
            this.bufferedWriter.flush();
            if (!this.writer.flowControlPushingBack) continue;
            return;
        }
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        Objects.requireNonNull(encoder);
        this.writer.out = encoder;
        this.writer.resumePendingWrites();
        if (this.writer.flowControlPushingBack) {
            return;
        }
        this.triggerFullWrite();
        if (this.writer.flowControlPushingBack) {
            return;
        }
        this.writer.flushToOutput();
        if (this.writer.flowControlPushingBack) {
            return;
        }
        encoder.complete();
        this.nextBodyToEncodeIndex = 0;
    }

    @Override
    public void fillDigest(MessageDigest digest) throws IOException {
        DigestWriter digestWriter = new DigestWriter(digest);
        for (JsonObject bodyPart : this.bodyParts) {
            this.gson.toJson((JsonElement)bodyPart, (Appendable)digestWriter);
            digestWriter.insertNewline();
        }
        this.hintContentLength(digestWriter.getContentLength());
    }

    private void hintContentLength(long contentLength) {
        if (!this.contentlengthWasProvided) {
            this.contentLength = contentLength;
        }
    }

    private static final class DigestWriter
    extends Writer {
        private final MessageDigest digest;
        private long totalWrittenBytes = 0L;

        public DigestWriter(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(char[] input, int offset, int len) throws IOException {
            CharBuffer charBuffer = CharBuffer.wrap(input, offset, len);
            ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
            this.totalWrittenBytes += (long)byteBuffer.remaining();
            this.digest.update(byteBuffer);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public void insertNewline() {
            this.totalWrittenBytes += (long)NEWLINE.length;
            this.digest.update(NEWLINE);
        }

        public long getContentLength() {
            return this.totalWrittenBytes;
        }
    }

    private static final class ProgressiveCharBufferWriter
    extends Writer {
        ContentEncoder out;
        List<CharBuffer> unwrittenLazyBuffers;
        boolean flowControlPushingBack = false;
        private final CharsetEncoder utf8Encoder = StandardCharsets.UTF_8.newEncoder();
        private ByteBuffer availableBuffer = ByteBuffer.allocate(1024);
        private ByteBuffer needsWritingBuffer;

        private ProgressiveCharBufferWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            CharBuffer toWriteChars = CharBuffer.wrap(cbuf, off, len);
            if (!this.flowControlPushingBack) {
                this.writeOrStore(toWriteChars, false, true);
            } else {
                this.storeForLater(toWriteChars);
            }
        }

        public void resumePendingWrites() throws IOException {
            this.flowControlPushingBack = false;
            if (this.availableBuffer == null) {
                this.attemptFlushPendingBuffers(false);
            }
        }

        private void storeForLater(CharBuffer toWriteLater) {
            if (this.unwrittenLazyBuffers == null) {
                this.unwrittenLazyBuffers = new ArrayList<CharBuffer>(16);
            }
            CharBuffer defensiveCopy = CharBuffer.allocate(toWriteLater.remaining());
            defensiveCopy.put(toWriteLater);
            defensiveCopy.flip();
            this.unwrittenLazyBuffers.add(defensiveCopy);
        }

        private void attemptFlushPendingBuffers(boolean lastWrite) throws IOException {
            this.flushCurrentBuffer();
            if (!this.flowControlPushingBack && this.needsWritingBuffer != null && this.fullyWrite(this.needsWritingBuffer)) {
                this.needsWritingBuffer.clear();
                this.availableBuffer = this.needsWritingBuffer;
                this.needsWritingBuffer = null;
            }
            while (!this.flowControlPushingBack && this.unwrittenLazyBuffers != null && !this.unwrittenLazyBuffers.isEmpty()) {
                CharBuffer charBuffer = this.unwrittenLazyBuffers.get(0);
                if (!this.writeOrStore(charBuffer, lastWrite, false)) continue;
                this.unwrittenLazyBuffers.remove(0);
            }
        }

        private boolean writeOrStore(CharBuffer toWriteChars, boolean lastWrite, boolean saveOnPushback) throws IOException {
            CoderResult coderResult;
            block3: {
                do {
                    if ((coderResult = this.utf8Encoder.encode(toWriteChars, this.availableBuffer, lastWrite)).equals(CoderResult.UNDERFLOW)) {
                        return true;
                    }
                    if (!coderResult.equals(CoderResult.OVERFLOW)) break block3;
                    this.flushCurrentBuffer();
                } while (!this.flowControlPushingBack);
                if (saveOnPushback) {
                    this.storeForLater(toWriteChars);
                }
                return false;
            }
            coderResult.throwException();
            return false;
        }

        private void flushCurrentBuffer() throws IOException {
            if (this.availableBuffer == null) {
                return;
            }
            this.availableBuffer.flip();
            if (this.fullyWrite(this.availableBuffer)) {
                this.availableBuffer.clear();
            } else {
                this.needsWritingBuffer = this.availableBuffer;
                this.availableBuffer = null;
            }
        }

        private boolean fullyWrite(ByteBuffer buffer) throws IOException {
            int actuallyWritten;
            if (this.out == null) {
                this.flowControlPushingBack = true;
                return false;
            }
            int toWrite = buffer.remaining();
            if (toWrite == (actuallyWritten = this.out.write(buffer))) {
                return true;
            }
            this.flowControlPushingBack = true;
            return false;
        }

        @Override
        public void flush() throws IOException {
        }

        public void flushToOutput() throws IOException {
            this.attemptFlushPendingBuffers(true);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

