/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.impl.Futures;
import org.hibernate.search.util.impl.Throwables;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class SimpleBulkableElasticsearchWork<R>
extends SimpleElasticsearchWork<R>
implements BulkableElasticsearchWork<R> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final JsonObject bulkableActionMetadata;

    protected SimpleBulkableElasticsearchWork(Builder<?> builder) {
        super(builder);
        this.bulkableActionMetadata = builder.buildBulkableActionMetadata();
    }

    @Override
    public void aggregate(ElasticsearchWorkAggregator aggregator) {
        aggregator.addBulkable(this);
    }

    @Override
    public JsonObject getBulkableActionMetadata() {
        return this.bulkableActionMetadata;
    }

    @Override
    public JsonObject getBulkableActionBody() {
        List<JsonObject> bodyParts = this.request.getBodyParts();
        if (!bodyParts.isEmpty()) {
            if (bodyParts.size() > 1) {
                throw new AssertionFailure("Found a bulkable action with multiple body parts: " + bodyParts);
            }
            return bodyParts.get(0);
        }
        return null;
    }

    @Override
    public CompletableFuture<R> handleBulkResult(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
        return Futures.create(() -> this.handleResult(context, bulkResponseItem));
    }

    @Override
    protected final CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        return super.beforeExecute(executionContext, request);
    }

    protected abstract R generateResult(ElasticsearchWorkExecutionContext var1, JsonObject var2);

    private CompletableFuture<R> handleResult(ElasticsearchWorkExecutionContext executionContext, JsonObject bulkResponseItem) {
        Object result;
        try {
            this.resultAssessor.checkSuccess(bulkResponseItem);
            result = this.generateResult(executionContext, bulkResponseItem);
            if (this.markIndexDirty) {
                executionContext.setIndexDirty(this.dirtiedIndexName);
            }
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchBulkedRequestFailed(this.getBulkableActionMetadata(), this.getBulkableActionBody(), bulkResponseItem, e);
        }
        return ((CompletableFuture)this.afterSuccess(executionContext).exceptionally(Futures.handler(throwable -> {
            throw LOG.elasticsearchBulkedRequestFailed(this.getBulkableActionMetadata(), this.getBulkableActionBody(), bulkResponseItem, Throwables.expectException((Throwable)throwable));
        }))).thenApply(ignored -> result);
    }

    protected static abstract class Builder<B>
    extends SimpleElasticsearchWork.Builder<B> {
        public Builder(URLEncodedString dirtiedIndexName, ElasticsearchRequestSuccessAssessor resultAssessor) {
            super(dirtiedIndexName, resultAssessor);
        }

        protected abstract JsonObject buildBulkableActionMetadata();
    }
}

