/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import org.hibernate.search.util.logging.impl.ClassFormatter;
import org.hibernate.search.util.logging.impl.IndexedTypeIdentifierFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BaseHibernateSearchLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String entityManagerFactoryReferenceIsEmpty = "HSEARCH500001: An 'entityManagerFactoryNamespace' parameter was defined, but the 'entityManagerFactoryReference' parameter is empty. Please also set the 'entityManagerFactoryReference' parameter to select an entity manager factory, or do not set the 'entityManagerFactoryNamespace' parameter to try to use a default entity manager factory.";
    private static final String noAvailableEntityManagerFactoryInCDI = "HSEARCH500002: No entity manager factory available in the CDI context with this bean name: '%1$s'. Make sure your entity manager factory is a named bean.";
    private static final String unknownEntityManagerFactoryNamespace = "HSEARCH500003: Unknown entity manager factory namespace: '%1$s'. Please use a supported namespace.";
    private static final String cannotRetrieveEntityManagerFactoryInJsr352 = "HSEARCH500004: Exception while retrieving the EntityManagerFactory using @PersistenceUnit. This generally happens either because the persistence wasn't configured properly or because there are multiple persistence units.";
    private static final String ambiguousEntityManagerFactoryInJsr352 = "HSEARCH500005: Multiple entity manager factories have been registered in the CDI context. Please provide the bean name for the selected entity manager factory to the batch indexing job through the 'entityManagerFactoryReference' parameter.";
    private static final String cannotFindEntityManagerFactoryByPUName = "HSEARCH500006: No entity manager factory has been created with this persistence unit name yet: '%1$s'. Make sure you use the JPA API to create your entity manager factory (use a 'persistence.xml' file) and that the entity manager factory has already been created and wasn't closed before you launch the job.";
    private static final String cannotFindEntityManagerFactoryByName = "HSEARCH500007: No entity manager factory has been created with this name yet: '%1$s'. Make sure your entity manager factory is named (for instance by setting the 'hibernate.session_factory_name' option) and that the entity manager factory has already been created and wasn't closed before you launch the job.";
    private static final String noEntityManagerFactoryCreated = "HSEARCH500008: No entity manager factory has been created yet. Make sure that the entity manager factory has already been created and wasn't closed before you launched the job.";
    private static final String tooManyActiveEntityManagerFactories = "HSEARCH500009: Multiple entity manager factories are currently active. Please provide the name of the selected persistence unit to the batch indexing job through the 'entityManagerFactoryReference' parameter (you may also use the 'entityManagerFactoryNamespace' parameter for more referencing options).";
    private static final String analyzeIndexProgress = "HSEARCH500010: %1$s";
    private static final String startOptimization = "HSEARCH500015: Optimizing all entities ...";
    private static final String criteriaSize = "HSEARCH500016: %1$d criteria found.";
    private static final String checkpointReached = "HSEARCH500017: Checkpoint reached. Sending checkpoint ID to batch runtime... (entity='%1$s', checkpointInfo='%2$s')";
    private static final String openingReader = "HSEARCH500018: Opening EntityReader of partitionId='%1$s', entity='%2$s'.";
    private static final String closingReader = "HSEARCH500019: Closing EntityReader of partitionId='%1$s', entity='%2$s'.";
    private static final String readingEntity = "HSEARCH500021: Reading entity...";
    private static final String noMoreResults = "HSEARCH500022: No more results, read ends.";
    private static final String processEntity = "HSEARCH500023: Processing entity with id: '%1$s'";
    private static final String openingDocWriter = "HSEARCH500024: Opening LuceneDocWriter of partitionId='%1$s', entity='%2$s'.";
    private static final String closingDocWriter = "HSEARCH500025: Closing LuceneDocWriter of partitionId='%1$s', entity='%2$s'.";
    private static final String partitionsPlan = "HSEARCH500026: %1$d partitions, %2$d threads.";
    private static final String rowsToIndex = "HSEARCH500027: entityName: '%1$s', rowsToIndex: %2$d";
    private static final String failedToSerializeJobParameter = "HSEARCH500028: Failed to serialize job parameter of type %1$s";
    private static final String unableToParseJobParameter = "HSEARCH500029: Unable to parse value '%2$s' for job parameter '%1$s'.";
    private static final String illegalCheckpointInterval = "HSEARCH500030: The value of parameter 'checkpointInterval' (value=%1$d) should be equal to or less than the value of parameter 'rowsPerPartition' (value=%2$d).";
    private static final String negativeValueOrZero = "HSEARCH500031: The value of parameter '%1$s' (value=%2$d) should be greater than 0.";
    private static final String failingEntityTypes = "HSEARCH500032: The following selected entity types aren't indexable: %1$s. Please check if the annotation '@Indexed' has been added to each of them.";
    private static final String illegalSessionClearInterval = "HSEARCH500033: The value of parameter 'sessionClearInterval' (value=%1$d) should be equal to or less than the value of parameter 'checkpointInterval' (value=%2$d).";
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String illegalObjectRetrievedFromMessage = "HSEARCH000069: Illegal object retrieved from message";
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    private static final String unknownResolution = "HSEARCH000140: Unknown Resolution: %1$s";
    private static final String unsupportedFacetRangeParameter = "HSEARCH000266: '%s' is not a valid type for a facet range request. Numbers (byte, short, int, long, float, double and their wrappers) as well as dates are supported";
    private static final String projectingFieldWithoutTwoWayFieldBridge = "HSEARCH000324: The fieldBridge for field '%1$s' is an instance of '%2$s', which does not implement TwoWayFieldBridge. Projected fields must have a TwoWayFieldBridge.";
    private static final String unsupportedNullTokenType = "HSEARCH000327: Unsupported indexNullAs token type '%3$s' on field '%2$s' of entity '%1$s'.";
    private static final String invalidLuceneAnalyzerDefinitionProvider = "HSEARCH000329: Property 'hibernate.search.lucene.analysis_definition_provider' set to value '%1$s' is invalid. The value must be the fully-qualified name of a class with a public, no-arg constructor in your classpath. Also, the class must either implement LuceneAnalyzerDefinitionProvider or expose a public, @Factory-annotated method returning a LuceneAnalyzerDefinitionProvider.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String entityManagerFactoryReferenceIsEmpty$str() {
        return entityManagerFactoryReferenceIsEmpty;
    }

    @Override
    public final SearchException entityManagerFactoryReferenceIsEmpty() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.entityManagerFactoryReferenceIsEmpty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAvailableEntityManagerFactoryInCDI$str() {
        return noAvailableEntityManagerFactoryInCDI;
    }

    @Override
    public final SearchException noAvailableEntityManagerFactoryInCDI(String reference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noAvailableEntityManagerFactoryInCDI$str(), reference));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownEntityManagerFactoryNamespace$str() {
        return unknownEntityManagerFactoryNamespace;
    }

    @Override
    public final SearchException unknownEntityManagerFactoryNamespace(String namespace) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownEntityManagerFactoryNamespace$str(), namespace));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRetrieveEntityManagerFactoryInJsr352$str() {
        return cannotRetrieveEntityManagerFactoryInJsr352;
    }

    @Override
    public final SearchException cannotRetrieveEntityManagerFactoryInJsr352() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotRetrieveEntityManagerFactoryInJsr352$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousEntityManagerFactoryInJsr352$str() {
        return ambiguousEntityManagerFactoryInJsr352;
    }

    @Override
    public final SearchException ambiguousEntityManagerFactoryInJsr352() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ambiguousEntityManagerFactoryInJsr352$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindEntityManagerFactoryByPUName$str() {
        return cannotFindEntityManagerFactoryByPUName;
    }

    @Override
    public final SearchException cannotFindEntityManagerFactoryByPUName(String persistentUnitName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindEntityManagerFactoryByPUName$str(), persistentUnitName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindEntityManagerFactoryByName$str() {
        return cannotFindEntityManagerFactoryByName;
    }

    @Override
    public final SearchException cannotFindEntityManagerFactoryByName(String entityManagerFactoryName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindEntityManagerFactoryByName$str(), entityManagerFactoryName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noEntityManagerFactoryCreated$str() {
        return noEntityManagerFactoryCreated;
    }

    @Override
    public final SearchException noEntityManagerFactoryCreated() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noEntityManagerFactoryCreated$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tooManyActiveEntityManagerFactories$str() {
        return tooManyActiveEntityManagerFactories;
    }

    @Override
    public final SearchException tooManyActiveEntityManagerFactories() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tooManyActiveEntityManagerFactories$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void analyzeIndexProgress(String progress) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.analyzeIndexProgress$str(), (Object)progress);
    }

    protected String analyzeIndexProgress$str() {
        return analyzeIndexProgress;
    }

    @Override
    public final void startOptimization() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startOptimization$str(), new Object[0]);
    }

    protected String startOptimization$str() {
        return startOptimization;
    }

    @Override
    public final void criteriaSize(int size) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.criteriaSize$str(), (Object)size);
    }

    protected String criteriaSize$str() {
        return criteriaSize;
    }

    @Override
    public final void checkpointReached(String entityName, Object checkpointInfo) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.checkpointReached$str(), (Object)entityName, checkpointInfo);
    }

    protected String checkpointReached$str() {
        return checkpointReached;
    }

    @Override
    public final void openingReader(String partitionId, String entityName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.openingReader$str(), (Object)partitionId, (Object)entityName);
    }

    protected String openingReader$str() {
        return openingReader;
    }

    @Override
    public final void closingReader(String partitionId, String entityName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.closingReader$str(), (Object)partitionId, (Object)entityName);
    }

    protected String closingReader$str() {
        return closingReader;
    }

    @Override
    public final void readingEntity() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.readingEntity$str(), new Object[0]);
    }

    protected String readingEntity$str() {
        return readingEntity;
    }

    @Override
    public final void noMoreResults() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.noMoreResults$str(), new Object[0]);
    }

    protected String noMoreResults$str() {
        return noMoreResults;
    }

    @Override
    public final void processEntity(Object entityId) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.processEntity$str(), entityId);
    }

    protected String processEntity$str() {
        return processEntity;
    }

    @Override
    public final void openingDocWriter(String partitionId, String entityName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.openingDocWriter$str(), (Object)partitionId, (Object)entityName);
    }

    protected String openingDocWriter$str() {
        return openingDocWriter;
    }

    @Override
    public final void closingDocWriter(String partitionId, String entityName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.closingDocWriter$str(), (Object)partitionId, (Object)entityName);
    }

    protected String closingDocWriter$str() {
        return closingDocWriter;
    }

    @Override
    public final void partitionsPlan(int partitionSize, int threadSize) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.partitionsPlan$str(), (Object)partitionSize, (Object)threadSize);
    }

    protected String partitionsPlan$str() {
        return partitionsPlan;
    }

    @Override
    public final void rowsToIndex(String entityName, Long rowsToIndex) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.rowsToIndex$str(), (Object)entityName, (Object)rowsToIndex);
    }

    protected String rowsToIndex$str() {
        return rowsToIndex;
    }

    protected String failedToSerializeJobParameter$str() {
        return failedToSerializeJobParameter;
    }

    @Override
    public final SearchException failedToSerializeJobParameter(Class<?> type, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToSerializeJobParameter$str(), new ClassFormatter(type)), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToParseJobParameter$str() {
        return unableToParseJobParameter;
    }

    @Override
    public final SearchException unableToParseJobParameter(String parameterName, Object parameterValue, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToParseJobParameter$str(), parameterName, parameterValue), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalCheckpointInterval$str() {
        return illegalCheckpointInterval;
    }

    @Override
    public final SearchException illegalCheckpointInterval(int checkpointInterval, int rowsPerPartition) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalCheckpointInterval$str(), checkpointInterval, rowsPerPartition));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String negativeValueOrZero$str() {
        return negativeValueOrZero;
    }

    @Override
    public final SearchException negativeValueOrZero(String parameterName, Number parameterValue) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.negativeValueOrZero$str(), parameterName, parameterValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failingEntityTypes$str() {
        return failingEntityTypes;
    }

    @Override
    public final SearchException failingEntityTypes(String failingEntityNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failingEntityTypes$str(), failingEntityNames));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalSessionClearInterval$str() {
        return illegalSessionClearInterval;
    }

    @Override
    public final SearchException illegalSessionClearInterval(int sessionClearInterval, int checkpointInterval) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.illegalSessionClearInterval$str(), sessionClearInterval, checkpointInterval));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final void interruptedWhileWaitingForIndexActivity(String arg0, InterruptedException arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg1, this.interruptedWhileWaitingForIndexActivity$str(), (Object)arg0);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    public final void illegalObjectRetrievedFromMessage(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg0, this.illegalObjectRetrievedFromMessage$str(), new Object[0]);
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    public final SearchException unableToLoadResource(String arg0) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    public final AssertionFailure unknownResolution(String arg0) {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.unknownResolution$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFacetRangeParameter$str() {
        return unsupportedFacetRangeParameter;
    }

    public final SearchException unsupportedFacetRangeParameter(String arg0) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedFacetRangeParameter$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String projectingFieldWithoutTwoWayFieldBridge$str() {
        return projectingFieldWithoutTwoWayFieldBridge;
    }

    public final SearchException projectingFieldWithoutTwoWayFieldBridge(String arg0, Class<?> arg1) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectingFieldWithoutTwoWayFieldBridge$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedNullTokenType$str() {
        return unsupportedNullTokenType;
    }

    public final SearchException unsupportedNullTokenType(IndexedTypeIdentifier arg0, String arg1, Class<?> arg2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedNullTokenType$str(), new IndexedTypeIdentifierFormatter(arg0), arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLuceneAnalyzerDefinitionProvider$str() {
        return invalidLuceneAnalyzerDefinitionProvider;
    }

    public final SearchException invalidLuceneAnalyzerDefinitionProvider(String arg0, Exception arg1) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLuceneAnalyzerDefinitionProvider$str(), arg0), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

