/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.MassIndexingJobParameters;
import org.hibernate.search.jsr352.massindexing.impl.util.SerializationUtil;
import org.hibernate.search.jsr352.massindexing.impl.util.ValidationUtil;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class MassIndexingJob {
    public static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String NAME = "hibernate-search-mass-indexing";

    private MassIndexingJob() {
    }

    public static ParametersBuilderInitialStep parameters() {
        return ParametersBuilderInitialStep.INSTANCE;
    }

    public static class ParametersBuilder {
        private final Set<Class<?>> entityTypes;
        private String entityManagerFactoryNamespace;
        private String entityManagerFactoryReference;
        private CacheMode cacheMode;
        private Boolean optimizeAfterPurge;
        private Boolean optimizeOnFinish;
        private Boolean purgeAllOnStart;
        private Integer idFetchSize;
        private Integer entityFetchSize;
        private Integer sessionClearInterval;
        private Integer checkpointInterval;
        private Integer rowsPerPartition;
        private Integer maxThreads;
        private Set<Criterion> customQueryCriteria;
        private String customQueryHql;
        private Integer maxResultsPerEntity;
        private String tenantId;

        private ParametersBuilder(Class<?> entityType, Class<?> ... entityTypes) {
            if (entityType == null) {
                throw new IllegalArgumentException("entityTypes must have at least 1 element.");
            }
            this.entityTypes = new HashSet();
            this.entityTypes.add(entityType);
            Collections.addAll(this.entityTypes, entityTypes);
            this.customQueryCriteria = new HashSet<Criterion>();
        }

        public ParametersBuilder entityManagerFactoryNamespace(String namespace) {
            this.entityManagerFactoryNamespace = namespace;
            return this;
        }

        public ParametersBuilder entityManagerFactoryReference(String reference) {
            this.entityManagerFactoryReference = reference;
            return this;
        }

        public ParametersBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            return this;
        }

        public ParametersBuilder sessionClearInterval(int sessionClearInterval) {
            this.sessionClearInterval = sessionClearInterval;
            return this;
        }

        public ParametersBuilder checkpointInterval(int checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
            return this;
        }

        public ParametersBuilder idFetchSize(int idFetchSize) {
            this.idFetchSize = idFetchSize;
            return this;
        }

        public ParametersBuilder entityFetchSize(int entityFetchSize) {
            this.entityFetchSize = entityFetchSize;
            return this;
        }

        public ParametersBuilder maxResultsPerEntity(int maxResultsPerEntity) {
            if (maxResultsPerEntity < 1) {
                String msg = String.format(Locale.ROOT, "The value of parameter '%s' must be at least 1 (value=%d).", "maxResultsPerEntity", maxResultsPerEntity);
                throw new IllegalArgumentException(msg);
            }
            this.maxResultsPerEntity = maxResultsPerEntity;
            return this;
        }

        public ParametersBuilder maxThreads(int maxThreads) {
            if (maxThreads < 1) {
                throw new IllegalArgumentException("threads must be at least 1.");
            }
            this.maxThreads = maxThreads;
            return this;
        }

        public ParametersBuilder optimizeAfterPurge(boolean optimizeAfterPurge) {
            this.optimizeAfterPurge = optimizeAfterPurge;
            return this;
        }

        public ParametersBuilder optimizeOnFinish(boolean optimizeOnFinish) {
            this.optimizeOnFinish = optimizeOnFinish;
            return this;
        }

        public ParametersBuilder purgeAllOnStart(boolean purgeAllOnStart) {
            this.purgeAllOnStart = purgeAllOnStart;
            return this;
        }

        public ParametersBuilder restrictedBy(Criterion criterion) {
            if (this.customQueryHql != null) {
                throw new IllegalArgumentException("Cannot use HQL approach and Criteria approach in the same time.");
            }
            if (criterion == null) {
                throw new NullPointerException("The criterion is null.");
            }
            this.customQueryCriteria.add(criterion);
            return this;
        }

        public ParametersBuilder restrictedBy(String hql) {
            if (hql == null) {
                throw new NullPointerException("The HQL is null.");
            }
            if (this.customQueryCriteria.size() > 0) {
                throw new IllegalArgumentException("Cannot use HQL approach and Criteria approach in the same time.");
            }
            this.customQueryHql = hql;
            return this;
        }

        public ParametersBuilder rowsPerPartition(int rowsPerPartition) {
            if (rowsPerPartition < 1) {
                throw new IllegalArgumentException("rowsPerPartition must be at least 1");
            }
            this.rowsPerPartition = rowsPerPartition;
            return this;
        }

        public ParametersBuilder tenantId(String tenantId) {
            if (tenantId == null) {
                throw new NullPointerException("Your tenantId is null, please provide a valid tenant ID.");
            }
            if (tenantId.isEmpty()) {
                throw new IllegalArgumentException("Your tenantId is empty, please provide a valid tenant ID.");
            }
            this.tenantId = tenantId;
            return this;
        }

        public Properties build() {
            int defaultedCheckpointInterval = MassIndexingJobParameters.Defaults.checkpointInterval(this.checkpointInterval, this.rowsPerPartition);
            ValidationUtil.validateCheckpointInterval(defaultedCheckpointInterval, this.rowsPerPartition != null ? this.rowsPerPartition : 20000);
            int defaultedSessionClearInterval = MassIndexingJobParameters.Defaults.sessionClearInterval(this.sessionClearInterval, defaultedCheckpointInterval);
            ValidationUtil.validateSessionClearInterval(defaultedSessionClearInterval, defaultedCheckpointInterval);
            Properties jobParams = new Properties();
            this.addIfNotNull(jobParams, "entityManagerFactoryNamespace", this.entityManagerFactoryNamespace);
            this.addIfNotNull(jobParams, "entityManagerFactoryReference", this.entityManagerFactoryReference);
            this.addIfNotNull(jobParams, "idFetchSize", this.idFetchSize);
            this.addIfNotNull(jobParams, "entityFetchSize", this.entityFetchSize);
            this.addIfNotNull(jobParams, "customQueryHQL", this.customQueryHql);
            this.addIfNotNull(jobParams, "checkpointInterval", this.checkpointInterval);
            this.addIfNotNull(jobParams, "sessionClearInterval", this.sessionClearInterval);
            this.addIfNotNull(jobParams, "maxResultsPerEntity", this.maxResultsPerEntity);
            this.addIfNotNull(jobParams, "maxThreads", this.maxThreads);
            this.addIfNotNull(jobParams, "optimizeAfterPurge", this.optimizeAfterPurge);
            this.addIfNotNull(jobParams, "optimizeOnFinish", this.optimizeOnFinish);
            this.addIfNotNull(jobParams, "purgeAllOnStart", this.purgeAllOnStart);
            this.addIfNotNull(jobParams, "entityTypes", this.getEntityTypesAsString());
            this.addIfNotNull(jobParams, "rowsPerPartition", this.rowsPerPartition);
            this.addIfNotNull(jobParams, "tenantId", this.tenantId);
            if (this.cacheMode != null) {
                jobParams.put("cacheMode", this.cacheMode.name());
            }
            if (!this.customQueryCriteria.isEmpty()) {
                try {
                    jobParams.put("customQueryCriteria", SerializationUtil.serialize(this.customQueryCriteria));
                }
                catch (IOException e) {
                    throw log.failedToSerializeJobParameter(Criteria.class, e);
                }
            }
            return jobParams;
        }

        private String getEntityTypesAsString() {
            return this.entityTypes.stream().map(Class::getName).collect(Collectors.joining(","));
        }

        private void addIfNotNull(Properties properties, String key, Object value) {
            if (value != null) {
                properties.put(key, String.valueOf(value));
            }
        }
    }

    public static class ParametersBuilderInitialStep {
        private static final ParametersBuilderInitialStep INSTANCE = new ParametersBuilderInitialStep();

        private ParametersBuilderInitialStep() {
        }

        public ParametersBuilder forEntity(Class<?> entityType) {
            return new ParametersBuilder((Class)entityType, new Class[0]);
        }

        public ParametersBuilder forEntities(Class<?> entityType, Class<?> ... entityTypes) {
            return new ParametersBuilder((Class)entityType, (Class[])entityTypes);
        }
    }
}

