/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing;

import org.hibernate.CacheMode;

public final class MassIndexingJobParameters {
    public static final String ENTITY_MANAGER_FACTORY_NAMESPACE = "entityManagerFactoryNamespace";
    public static final String ENTITY_MANAGER_FACTORY_REFERENCE = "entityManagerFactoryReference";
    public static final String ENTITY_TYPES = "entityTypes";
    public static final String MAX_THREADS = "maxThreads";
    public static final String MAX_RESULTS_PER_ENTITY = "maxResultsPerEntity";
    public static final String ID_FETCH_SIZE = "idFetchSize";
    public static final String ENTITY_FETCH_SIZE = "entityFetchSize";
    public static final String CACHE_MODE = "cacheMode";
    public static final String OPTIMIZE_ON_FINISH = "optimizeOnFinish";
    public static final String OPTIMIZE_AFTER_PURGE = "optimizeAfterPurge";
    public static final String PURGE_ALL_ON_START = "purgeAllOnStart";
    public static final String ROWS_PER_PARTITION = "rowsPerPartition";
    public static final String CHECKPOINT_INTERVAL = "checkpointInterval";
    public static final String SESSION_CLEAR_INTERVAL = "sessionClearInterval";
    public static final String CUSTOM_QUERY_HQL = "customQueryHQL";
    public static final String CUSTOM_QUERY_CRITERIA = "customQueryCriteria";
    public static final String TENANT_ID = "tenantId";

    private MassIndexingJobParameters() {
    }

    public static final class Defaults {
        public static final int ID_FETCH_SIZE = 1000;
        public static final CacheMode CACHE_MODE = CacheMode.IGNORE;
        public static final boolean OPTIMIZE_ON_FINISH = true;
        public static final boolean OPTIMIZE_AFTER_PURGE = true;
        public static final boolean PURGE_ALL_ON_START = true;
        public static final int ROWS_PER_PARTITION = 20000;
        public static final int CHECKPOINT_INTERVAL_DEFAULT_RAW = 2000;
        public static final int SESSION_CLEAR_INTERVAL_DEFAULT_RAW = 200;

        private Defaults() {
        }

        public static int checkpointInterval(Integer checkpointIntervalRaw, Integer rowsPerPartition) {
            if (checkpointIntervalRaw != null) {
                return checkpointIntervalRaw;
            }
            if (rowsPerPartition == null || rowsPerPartition > 2000) {
                return 2000;
            }
            return rowsPerPartition;
        }

        public static int sessionClearInterval(Integer sessionClearIntervalRaw, Integer checkpointInterval) {
            if (sessionClearIntervalRaw != null) {
                return sessionClearIntervalRaw;
            }
            if (checkpointInterval == null || checkpointInterval > 200) {
                return 200;
            }
            return checkpointInterval;
        }
    }
}

