/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.steps.lucene;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemProcessor;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.impl.JobContextData;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneDocProducer
implements ItemProcessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    @Inject
    private JobContext jobContext;
    @Inject
    @BatchProperty(name="entityName")
    private String entityName;
    @Inject
    @BatchProperty(name="tenantId")
    private String tenantId;
    private EntityManagerFactory emf;
    private ExtendedSearchIntegrator searchIntegrator;
    private EntityIndexBinding entityIndexBinding;
    private DocumentBuilderIndexedEntity docBuilder;
    private boolean isSetup = false;
    private IndexedTypeIdentifier entityTypeIdentifier;

    public Object processItem(Object item) throws Exception {
        log.processEntity(item);
        if (!this.isSetup) {
            this.setup();
            this.isSetup = true;
        }
        return this.buildWork(item);
    }

    private void setup() throws ClassNotFoundException, NamingException {
        JobContextData jobContextData = (JobContextData)this.jobContext.getTransientUserData();
        Class<?> entityType = jobContextData.getEntityType(this.entityName);
        this.entityTypeIdentifier = new PojoIndexedTypeIdentifier(entityType);
        this.searchIntegrator = jobContextData.getSearchIntegrator();
        this.entityIndexBinding = (EntityIndexBinding)this.searchIntegrator.getIndexBindings().get(this.entityTypeIdentifier);
        this.docBuilder = this.entityIndexBinding.getDocumentBuilder();
        this.emf = jobContextData.getEntityManagerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LuceneWork buildWork(Object entity) {
        String idInString;
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        Serializable id = (Serializable)this.emf.getPersistenceUnitUtil().getIdentifier(entity);
        TwoWayFieldBridge idBridge = this.docBuilder.getIdBridge();
        conversionContext.pushIdentifierProperty();
        try {
            idInString = conversionContext.setConvertedTypeId(this.entityTypeIdentifier).twoWayConversionContext(idBridge).objectToString((Object)id);
        }
        finally {
            conversionContext.popProperty();
        }
        if (StringHelper.isEmpty((String)this.tenantId)) {
            this.tenantId = null;
        }
        return this.docBuilder.createAddWork(this.tenantId, this.entityTypeIdentifier, entity, id, idInString, null, (ConversionContext)conversionContext);
    }
}

