/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.steps.lucene;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.batch.api.partition.AbstractPartitionAnalyzer;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.PartitionProgress;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.StepProgress;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ProgressAggregator
extends AbstractPartitionAnalyzer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    @Inject
    private StepContext stepContext;

    public void analyzeCollectorData(Serializable fromCollector) throws Exception {
        PartitionProgress partitionProgress = (PartitionProgress)fromCollector;
        StepProgress stepProgress = (StepProgress)this.stepContext.getTransientUserData();
        stepProgress.updateProgress(partitionProgress);
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        this.formatEntityProgresses(stepProgress).forEach(msg -> sb.append(System.lineSeparator()).append("\t").append((String)msg));
        sb.append(System.lineSeparator());
        log.analyzeIndexProgress(sb.toString());
    }

    private Stream<String> formatEntityProgresses(StepProgress stepProgress) {
        Map<String, Long> entityProgress = stepProgress.getEntityProgress();
        return stepProgress.getEntityTotal().entrySet().stream().map(entry -> this.formatEntityProgress((String)entry.getKey(), (Long)entityProgress.get(entry.getKey()), (Long)entry.getValue()));
    }

    private String formatEntityProgress(String entity, Long processed, Long total) {
        if (total == null) {
            return String.format(Locale.ROOT, "%s: %d entities processed.", entity, processed);
        }
        return String.format(Locale.ROOT, "%s: %d/%d entities processed (%.2f%%).", entity, processed, total, Float.valueOf((float)processed.longValue() * 100.0f / (float)total.longValue()));
    }
}

