/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.steps.lucene;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.PartitionProgress;

public class StepProgress
implements Serializable {
    private static final long serialVersionUID = 7808926033388850340L;
    private Map<Integer, Long> partitionProgress = new HashMap<Integer, Long>();
    private Map<String, Long> entityProgress = new HashMap<String, Long>();
    private Map<String, Long> entityTotal = new HashMap<String, Long>();

    public void updateProgress(PartitionProgress pp) {
        long prevDone = this.partitionProgress.getOrDefault(pp.getPartitionId(), 0L);
        long currDone = pp.getWorkDone();
        if (currDone < prevDone) {
            throw new ArithmeticException("Current indexed works (" + currDone + " indexed) is smaller than previous indexed works (" + prevDone + " indexed).");
        }
        this.increment(pp.getEntityName(), currDone - prevDone);
        this.increment(pp.getPartitionId(), currDone - prevDone);
    }

    private void increment(String entityName, long increment) {
        long prevDone = this.entityProgress.getOrDefault(entityName, 0L);
        this.entityProgress.put(entityName, prevDone + increment);
    }

    private void increment(int pid, long increment) {
        long prevDone = this.partitionProgress.getOrDefault(pid, 0L);
        this.partitionProgress.put(pid, prevDone + increment);
    }

    public Map<Integer, Long> getPartitionProgress() {
        return Collections.unmodifiableMap(this.partitionProgress);
    }

    public Map<String, Long> getEntityProgress() {
        return Collections.unmodifiableMap(this.entityProgress);
    }

    public Map<String, Long> getEntityTotal() {
        return Collections.unmodifiableMap(this.entityTotal);
    }

    public void setRowsToIndex(String entityName, Long rowsToIndex) {
        this.entityProgress.put(entityName, 0L);
        this.entityTotal.put(entityName, rowsToIndex);
    }
}

