/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiFunction;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.search.jsr352.massindexing.impl.util.IdOrder;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.type.ComponentType;

public class CompositeIdOrder
implements IdOrder {
    private final ComponentType componentType;
    private final List<String> propertyPaths;
    private final List<Integer> propertyIndices;

    public CompositeIdOrder(String componentPath, ComponentType componentType) {
        this.componentType = componentType;
        this.propertyPaths = new ArrayList<String>(Arrays.asList(componentType.getPropertyNames()));
        this.propertyPaths.sort(Comparator.naturalOrder());
        String pathPrefix = componentPath == null ? "" : componentPath + ".";
        this.propertyIndices = CollectionHelper.newArrayList((int)this.propertyPaths.size());
        ListIterator<String> iterator = this.propertyPaths.listIterator();
        while (iterator.hasNext()) {
            String propertyName = iterator.next();
            this.propertyIndices.add(componentType.getPropertyIndex(propertyName));
            iterator.set(pathPrefix + propertyName);
        }
    }

    @Override
    public Criterion idGreater(Object idObj) {
        return this.restrictLexicographically(Restrictions::gt, idObj, false);
    }

    @Override
    public Criterion idGreaterOrEqual(Object idObj) {
        return this.restrictLexicographically(Restrictions::gt, idObj, true);
    }

    @Override
    public Criterion idLesser(Object idObj) {
        return this.restrictLexicographically(Restrictions::lt, idObj, false);
    }

    @Override
    public void addAscOrder(Criteria criteria) {
        for (String path : this.propertyPaths) {
            criteria.addOrder(Order.asc((String)path));
        }
    }

    private Criterion restrictLexicographically(BiFunction<String, Object, SimpleExpression> strictOperator, Object idObj, boolean orEquals) {
        int propertyPathsSize = this.propertyPaths.size();
        int expressionsInOr = propertyPathsSize + (orEquals ? 1 : 0);
        Criterion[] or = new Criterion[expressionsInOr];
        for (int i = 0; i < propertyPathsSize; ++i) {
            Object val;
            String path;
            int j;
            Criterion[] and = new Criterion[i + 1];
            for (j = 0; j < and.length - 1; ++j) {
                path = this.propertyPaths.get(j);
                val = this.getPropertyValue(idObj, j);
                and[j] = Restrictions.eq((String)path, (Object)val);
            }
            path = this.propertyPaths.get(j);
            val = this.getPropertyValue(idObj, j);
            and[j] = (Criterion)strictOperator.apply(path, val);
            or[i] = Restrictions.conjunction((Criterion[])and);
        }
        if (orEquals) {
            Criterion[] and = new Criterion[propertyPathsSize];
            for (int i = 0; i < propertyPathsSize; ++i) {
                String path = this.propertyPaths.get(i);
                Object val = this.getPropertyValue(idObj, i);
                and[i] = Restrictions.eq((String)path, (Object)val);
            }
            or[or.length - 1] = Restrictions.conjunction((Criterion[])and);
        }
        return Restrictions.or((Criterion[])or);
    }

    private Object getPropertyValue(Object obj, int ourIndex) {
        int theirIndex = this.propertyIndices.get(ourIndex);
        return this.componentType.getPropertyValue(obj, theirIndex);
    }
}

