/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.batch.runtime.context.JobContext;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.jsr352.context.jpa.impl.ActiveSessionFactoryRegistry;
import org.hibernate.search.jsr352.context.jpa.spi.EntityManagerFactoryRegistry;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.impl.JobContextData;
import org.hibernate.search.jsr352.massindexing.impl.util.EntityTypeDescriptor;
import org.hibernate.search.jsr352.massindexing.impl.util.PersistenceUtil;
import org.hibernate.search.jsr352.massindexing.impl.util.SerializationUtil;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class JobContextUtil {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private JobContextUtil() {
    }

    public static JobContextData getOrCreateData(JobContext jobContext, EntityManagerFactoryRegistry emfRegistry, String entityManagerFactoryNamespace, String entityManagerFactoryReference, String entityTypes, String serializedCustomQueryCriteria) throws ClassNotFoundException, IOException {
        JobContextData data = (JobContextData)jobContext.getTransientUserData();
        if (data == null) {
            EntityManagerFactory emf = JobContextUtil.getEntityManagerFactory(emfRegistry, entityManagerFactoryNamespace, entityManagerFactoryReference);
            data = JobContextUtil.createData(emf, entityTypes, serializedCustomQueryCriteria);
            jobContext.setTransientUserData((Object)data);
        }
        return data;
    }

    public static JobContextData getExistingData(JobContext jobContext) {
        JobContextData data = (JobContextData)jobContext.getTransientUserData();
        if (data == null) {
            throw new AssertionFailure("The job context data was unexpectedly missing; there probably is something wrong with how Hibernate Search set up the job context data.");
        }
        return data;
    }

    static EntityManagerFactory getEntityManagerFactory(EntityManagerFactoryRegistry emfRegistry, String entityManagerFactoryNamespace, String entityManagerFactoryReference) {
        EntityManagerFactoryRegistry registry;
        EntityManagerFactoryRegistry entityManagerFactoryRegistry = registry = emfRegistry != null ? emfRegistry : ActiveSessionFactoryRegistry.getInstance();
        if (StringHelper.isEmpty((String)entityManagerFactoryNamespace)) {
            if (StringHelper.isEmpty((String)entityManagerFactoryReference)) {
                return registry.getDefault();
            }
            return registry.get(entityManagerFactoryReference);
        }
        if (StringHelper.isEmpty((String)entityManagerFactoryReference)) {
            throw log.entityManagerFactoryReferenceIsEmpty();
        }
        return registry.get(entityManagerFactoryNamespace, entityManagerFactoryReference);
    }

    private static JobContextData createData(EntityManagerFactory emf, String entityTypes, String serializedCustomQueryCriteria) throws ClassNotFoundException, IOException {
        ExtendedSearchIntegrator searchIntegrator = ContextHelper.getSearchIntegratorBySF((SessionFactory)((SessionFactory)emf.unwrap(SessionFactory.class)));
        List<String> entityNamesToIndex = Arrays.asList(entityTypes.split(","));
        IndexedTypeSet typeIds = searchIntegrator.getIndexedTypeIdentifiers();
        HashSet entityTypesToIndex = new HashSet();
        for (IndexedTypeIdentifier typeId : typeIds) {
            if (!entityNamesToIndex.contains(typeId.getName())) continue;
            entityTypesToIndex.add(typeId.getPojoType());
        }
        List<EntityTypeDescriptor> descriptors = PersistenceUtil.createDescriptors(emf, entityTypesToIndex);
        Set<Criterion> criteria = SerializationUtil.parseParameter(Set.class, "customQueryCriteria", serializedCustomQueryCriteria);
        if (criteria == null) {
            criteria = Collections.emptySet();
        }
        log.criteriaSize(criteria.size());
        JobContextData jobContextData = new JobContextData();
        jobContextData.setEntityManagerFactory(emf);
        jobContextData.setCustomQueryCriteria(criteria);
        jobContextData.setEntityTypeDescriptors(descriptors);
        return jobContextData;
    }
}

