/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.IndexScope;
import org.hibernate.search.jsr352.massindexing.impl.util.CompositeIdOrder;
import org.hibernate.search.jsr352.massindexing.impl.util.EntityTypeDescriptor;
import org.hibernate.search.jsr352.massindexing.impl.util.IdOrder;
import org.hibernate.search.jsr352.massindexing.impl.util.SingularIdOrder;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public final class PersistenceUtil {
    private PersistenceUtil() {
    }

    public static Session openSession(EntityManagerFactory entityManagerFactory, String tenantId) {
        SessionFactory sessionFactory = (SessionFactory)entityManagerFactory.unwrap(SessionFactory.class);
        SessionBuilder builder = sessionFactory.withOptions();
        if (StringHelper.isNotEmpty((String)tenantId)) {
            builder.tenantIdentifier(tenantId);
        }
        Session session = builder.openSession();
        session.setDefaultReadOnly(true);
        session.setHibernateFlushMode(FlushMode.MANUAL);
        return session;
    }

    public static StatelessSession openStatelessSession(EntityManagerFactory entityManagerFactory, String tenantId) {
        SessionFactory sessionFactory = (SessionFactory)entityManagerFactory.unwrap(SessionFactory.class);
        StatelessSessionBuilder builder = sessionFactory.withStatelessOptions();
        if (StringHelper.isNotEmpty((String)tenantId)) {
            builder.tenantIdentifier(tenantId);
        }
        return builder.openStatelessSession();
    }

    public static IndexScope getIndexScope(String hql, Set<Criterion> criterionSet) {
        if (StringHelper.isNotEmpty((String)hql)) {
            return IndexScope.HQL;
        }
        if (criterionSet != null && criterionSet.size() > 0) {
            return IndexScope.CRITERIA;
        }
        return IndexScope.FULL_ENTITY;
    }

    public static List<EntityTypeDescriptor> createDescriptors(EntityManagerFactory entityManagerFactory, Set<Class<?>> types) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        ArrayList result = CollectionHelper.newArrayList((int)types.size());
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        for (Class<?> type : types) {
            result.add(PersistenceUtil.createDescriptor(metamodel, type));
        }
        return result;
    }

    private static <T> EntityTypeDescriptor createDescriptor(MetamodelImplementor metamodel, Class<T> type) {
        EntityPersister entityPersister = metamodel.entityPersister(type);
        IdOrder idOrder = PersistenceUtil.createIdOrder(entityPersister);
        return new EntityTypeDescriptor(type, idOrder);
    }

    private static IdOrder createIdOrder(EntityPersister entityPersister) {
        String identifierPropertyName = entityPersister.getIdentifierPropertyName();
        Type identifierType = entityPersister.getIdentifierType();
        if (identifierType instanceof ComponentType) {
            ComponentType componentType = (ComponentType)identifierType;
            return new CompositeIdOrder(identifierPropertyName, componentType);
        }
        return new SingularIdOrder(identifierPropertyName);
    }
}

