/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.serialization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.impl.StandardServiceManager;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.test.serialization.RemoteEntity;
import org.hibernate.search.test.util.SerializationTestHelper;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1795")
public class DocValuesSerializationTest {
    @Rule
    public SearchFactoryHolder searchFactoryHolder = new SearchFactoryHolder(new Class[]{RemoteEntity.class});
    private LuceneWorkSerializer workSerializer;

    @Before
    public void setUp() {
        ServiceManager serviceManager = this.getTestServiceManager();
        this.workSerializer = (LuceneWorkSerializer)serviceManager.requestService(LuceneWorkSerializer.class);
    }

    private ServiceManager getTestServiceManager() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        return new StandardServiceManager((SearchConfiguration)new SearchConfigurationForTest(), (BuildContext)new BuildContextForTest((SearchConfiguration)searchConfiguration){

            public ExtendedSearchIntegrator getUninitializedSearchIntegrator() {
                return DocValuesSerializationTest.this.searchFactoryHolder.getSearchFactory();
            }
        });
    }

    @Test
    public void testSerializationOfSortedSetDocValuesField() throws Exception {
        Document document = new Document();
        document.add((IndexableField)new SortedSetDocValuesField("foo", new BytesRef((CharSequence)"hello")));
        document.add((IndexableField)new SortedSetDocValuesField("foo", new BytesRef((CharSequence)"world")));
        List<LuceneWork> expectedWorkList = this.buildLuceneWorks(document);
        this.serializeDeserializeAndAssert(expectedWorkList);
    }

    @Test
    public void testSerializationOfSortedDocValuesField() throws Exception {
        Document document = new Document();
        document.add((IndexableField)new SortedDocValuesField("foo", new BytesRef((CharSequence)"world")));
        List<LuceneWork> expectedWorkList = this.buildLuceneWorks(document);
        this.serializeDeserializeAndAssert(expectedWorkList);
    }

    @Test
    public void testSerializationOfBinaryDocValuesField() throws Exception {
        Document document = new Document();
        document.add((IndexableField)new BinaryDocValuesField("foo", new BytesRef((CharSequence)"world")));
        List<LuceneWork> expectedWorkList = this.buildLuceneWorks(document);
        this.serializeDeserializeAndAssert(expectedWorkList);
    }

    @Test
    public void testSerializationOfNumericDocValuesField() throws Exception {
        Document document = new Document();
        document.add((IndexableField)new NumericDocValuesField("foo", 22L));
        List<LuceneWork> expectedWorkList = this.buildLuceneWorks(document);
        this.serializeDeserializeAndAssert(expectedWorkList);
    }

    @Test
    public void testSerializationOfMultipleDocValuesFields() throws Exception {
        Document document = new Document();
        document.add((IndexableField)new NumericDocValuesField("foo", 22L));
        document.add((IndexableField)new BinaryDocValuesField("foo", new BytesRef((CharSequence)"world")));
        document.add((IndexableField)new SortedSetDocValuesField("foo", new BytesRef((CharSequence)"hello")));
        document.add((IndexableField)new SortedSetDocValuesField("foo", new BytesRef((CharSequence)"world")));
        document.add((IndexableField)new SortedDocValuesField("foo", new BytesRef((CharSequence)"world")));
        List<LuceneWork> expectedWorkList = this.buildLuceneWorks(document);
        this.serializeDeserializeAndAssert(expectedWorkList);
    }

    private void serializeDeserializeAndAssert(List<LuceneWork> expectedWorkList) {
        byte[] bytes = this.workSerializer.toSerializedModel(expectedWorkList);
        List actualWorkList = this.workSerializer.toLuceneWorks(bytes);
        SerializationTestHelper.assertLuceneWorkList(expectedWorkList, actualWorkList);
    }

    private List<LuceneWork> buildLuceneWorks(Document document) {
        ArrayList<LuceneWork> works = new ArrayList<LuceneWork>();
        works.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(123), "123", RemoteEntity.class, document));
        return works;
    }
}

