/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mysql;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.MySQL5InnoDBDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.mysql.MySQLGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.mysql.MySQLSpatialDialect;
import org.hibernate.spatial.dialect.mysql.MySQLSpatialFunctions;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class MySQL5InnoDBSpatialDialect
extends MySQL5InnoDBDialect
implements SpatialDialect {
    private MySQLSpatialDialect dialectDelegate = new MySQLSpatialDialect();

    public MySQL5InnoDBSpatialDialect() {
        this.registerColumnType(MySQLGeometryTypeDescriptor.INSTANCE.getSqlType(), "GEOMETRY");
        for (Map.Entry<String, SQLFunction> entry : new MySQLSpatialFunctions()) {
            this.registerFunction(entry.getKey(), entry.getValue());
        }
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        this.dialectDelegate.contributeTypes(typeContributions, serviceRegistry);
    }

    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        return this.dialectDelegate.getTypeName(code, length, precision, scale);
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        return this.dialectDelegate.remapSqlTypeDescriptor(sqlTypeDescriptor);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        return this.dialectDelegate.getSpatialRelateSQL(columnName, spatialRelation);
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return this.dialectDelegate.getSpatialFilterExpression(columnName);
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        return this.dialectDelegate.getSpatialAggregateSQL(columnName, aggregation);
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return this.dialectDelegate.getDWithinSQL(columnName);
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return this.dialectDelegate.getHavingSridSQL(columnName);
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        return this.dialectDelegate.getIsEmptySQL(columnName, isEmpty);
    }

    @Override
    public boolean supportsFiltering() {
        return this.dialectDelegate.supportsFiltering();
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.dialectDelegate.supports(function);
    }
}

