/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.SimpleProjection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.type.Type;

public class OracleSpatialProjection
extends SimpleProjection {
    private static final long serialVersionUID = 1L;
    private final String propertyName;
    private final int aggregate;

    public OracleSpatialProjection(int aggregate, String propertyName) {
        this.propertyName = propertyName;
        this.aggregate = aggregate;
    }

    public String toSqlString(Criteria criteria, int position, CriteriaQuery criteriaQuery) throws HibernateException {
        SessionFactoryImplementor factory = criteriaQuery.getFactory();
        String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        Dialect dialect = factory.getDialect();
        if (dialect instanceof SpatialDialect) {
            SpatialDialect seDialect = (SpatialDialect)dialect;
            return new StringBuffer(seDialect.getSpatialAggregateSQL(columns[0], this.aggregate)).append(" y").append(position).append("_").toString();
        }
        throw new IllegalStateException("Dialect must be spatially enabled dialect");
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new Type[]{criteriaQuery.getType(criteria, this.propertyName)};
    }

    public String toString() {
        return this.aggregate + "(" + this.propertyName + ")";
    }
}

