/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.testing.orm.junit.EntityManagerFactoryScope;
import org.hibernate.testing.orm.transaction.TransactionUtil;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.ExtensionContext;

abstract class AbstractEntityManagerFactoryScope
implements EntityManagerFactoryScope,
ExtensionContext.Store.CloseableResource {
    private static final Logger log = Logger.getLogger(EntityManagerFactoryScope.class);
    protected EntityManagerFactory emf;
    protected boolean active = true;

    AbstractEntityManagerFactoryScope() {
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        if (this.emf == null) {
            if (!this.active) {
                throw new IllegalStateException("EntityManagerFactoryScope is no longer active");
            }
            log.debug((Object)"Creating EntityManagerFactory");
            this.emf = this.createEntityManagerFactory();
        }
        return this.emf;
    }

    protected abstract EntityManagerFactory createEntityManagerFactory();

    @Override
    public StatementInspector getStatementInspector() {
        return ((SessionFactoryImplementor)this.getEntityManagerFactory().unwrap(SessionFactoryImplementor.class)).getSessionFactoryOptions().getStatementInspector();
    }

    @Override
    public <T extends StatementInspector> T getStatementInspector(Class<T> type) {
        return (T)this.getStatementInspector();
    }

    public void close() {
        if (!this.active) {
            return;
        }
        log.debug((Object)"Closing SessionFactoryScope");
        this.active = false;
        this.releaseEntityManagerFactory();
    }

    @Override
    public void releaseEntityManagerFactory() {
        if (this.emf != null) {
            log.debug((Object)"Releasing SessionFactory");
            try {
                this.emf.close();
            }
            catch (Exception e) {
                log.warn((Object)"Error closing EMF", (Throwable)e);
            }
            finally {
                this.emf = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inEntityManager(Consumer<EntityManager> action) {
        log.trace((Object)"#inEntityManager(Consumer)");
        try (SessionImplementor session = (SessionImplementor)this.getEntityManagerFactory().createEntityManager().unwrap(SessionImplementor.class);){
            log.trace((Object)"EntityManager opened, calling action");
            action.accept((EntityManager)session);
        }
        finally {
            log.trace((Object)"EntityManager close - auto-close block");
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T fromEntityManager(Function<EntityManager, T> action) {
        log.trace((Object)"#fromEntityManager(Function)");
        try {
            T t;
            try (SessionImplementor session = (SessionImplementor)this.getEntityManagerFactory().createEntityManager().unwrap(SessionImplementor.class);){
                log.trace((Object)"EntityManager opened, calling action");
                t = action.apply((EntityManager)session);
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            log.trace((Object)"EntityManager close - auto-close block");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inTransaction(Consumer<EntityManager> action) {
        log.trace((Object)"#inTransaction(Consumer)");
        try (SessionImplementor session = (SessionImplementor)this.getEntityManagerFactory().createEntityManager().unwrap(SessionImplementor.class);){
            log.trace((Object)"EntityManager opened, calling action");
            this.inTransaction((EntityManager)session, action);
        }
        finally {
            log.trace((Object)"EntityManager close - auto-close block");
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T fromTransaction(Function<EntityManager, T> action) {
        log.trace((Object)"#fromTransaction(Function)");
        try {
            T t;
            try (SessionImplementor session = (SessionImplementor)this.getEntityManagerFactory().createEntityManager().unwrap(SessionImplementor.class);){
                log.trace((Object)"EntityManager opened, calling action");
                t = this.fromTransaction((EntityManager)session, action);
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            log.trace((Object)"EntityManager close - auto-close block");
        }
    }

    @Override
    public void inTransaction(EntityManager entityManager, Consumer<EntityManager> action) {
        log.trace((Object)"inTransaction(EntityManager,Consumer)");
        TransactionUtil.inTransaction(entityManager, action);
    }

    @Override
    public <T> T fromTransaction(EntityManager entityManager, Function<EntityManager, T> action) {
        log.trace((Object)"fromTransaction(EntityManager,Function)");
        SessionImplementor session = (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        return TransactionUtil.fromTransaction((EntityManager)session, action);
    }
}

