/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class XMLPrettyPrinter {
    public static void prettyPrintFile(File file) throws IOException {
        String input = XMLPrettyPrinter.readFile(file.getAbsolutePath(), Charset.defaultCharset());
        String output = XMLPrettyPrinter.prettyFormat(input, 4);
        PrintWriter writer = new PrintWriter(file);
        writer.print(output);
        writer.flush();
        writer.close();
    }

    private static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    private static String prettyFormat(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

