/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.Metadata;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.TemplateHelper;
import org.jboss.logging.Logger;

public abstract class AbstractExporter
implements Exporter {
    protected Logger log = Logger.getLogger(this.getClass());
    private File outputdir;
    private String[] templatePaths = new String[0];
    private TemplateHelper vh;
    private Properties properties = new Properties();
    private ArtifactCollector collector = new ArtifactCollector();
    private Metadata metadata = null;
    private MetadataDescriptor metadataDescriptor = null;
    private Iterator<Map.Entry<Object, Object>> iterator;
    private Cfg2HbmTool c2h = new Cfg2HbmTool();
    private Cfg2JavaTool c2j = new Cfg2JavaTool();

    @Override
    public void setMetadataDescriptor(MetadataDescriptor metadataDescriptor) {
        this.metadataDescriptor = metadataDescriptor;
    }

    protected MetadataDescriptor getMetadataDescriptor() {
        return this.metadataDescriptor;
    }

    @Override
    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.buildMetadata();
        }
        return this.metadata;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputdir;
    }

    @Override
    public void setOutputDirectory(File outputdir) {
        this.outputdir = outputdir;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setTemplatePath(String[] templatePaths) {
        this.templatePaths = templatePaths;
    }

    @Override
    public String[] getTemplatePath() {
        return this.templatePaths;
    }

    @Override
    public void setArtifactCollector(ArtifactCollector collector) {
        this.collector = collector;
    }

    @Override
    public ArtifactCollector getArtifactCollector() {
        return this.collector;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Cfg2HbmTool getCfg2HbmTool() {
        return this.c2h;
    }

    public Cfg2JavaTool getCfg2JavaTool() {
        return this.c2j;
    }

    @Override
    public void start() {
        this.setTemplateHelper(new TemplateHelper());
        this.setupTemplates();
        this.setupContext();
        this.doStart();
        this.cleanUpContext();
        this.setTemplateHelper(null);
        this.getArtifactCollector().formatFiles();
    }

    protected abstract void doStart();

    protected void cleanUpContext() {
        if (this.getProperties() != null) {
            for (Map.Entry<Object, Object> element : this.getProperties().entrySet()) {
                Object value = this.transformValue(element.getValue());
                String key = element.getKey().toString();
                if (key.startsWith("hibernatetool.")) {
                    this.getTemplateHelper().removeFromContext(key.substring("hibernatetool.".length()), value);
                }
                this.getTemplateHelper().removeFromContext(key, value);
            }
        }
        if (this.getOutputDirectory() != null) {
            this.getTemplateHelper().removeFromContext("outputdir", this.getOutputDirectory());
        }
        if (this.getTemplatePath() != null) {
            this.getTemplateHelper().removeFromContext("template_path", this.getTemplatePath());
        }
        this.getTemplateHelper().removeFromContext("exporter", this);
        this.getTemplateHelper().removeFromContext("artifacts", this.collector);
        if (this.getMetadata() != null) {
            this.getTemplateHelper().removeFromContext("md", this.metadata);
            this.getTemplateHelper().removeFromContext("props", this.getProperties());
            this.getTemplateHelper().removeFromContext("tables", this.metadata.collectTableMappings());
        }
        this.getTemplateHelper().removeFromContext("c2h", this.getCfg2HbmTool());
        this.getTemplateHelper().removeFromContext("c2j", this.getCfg2JavaTool());
    }

    protected void setupContext() {
        this.getTemplateHelper().setupContext();
        this.getTemplateHelper().putInContext("exporter", this);
        this.getTemplateHelper().putInContext("c2h", this.getCfg2HbmTool());
        this.getTemplateHelper().putInContext("c2j", this.getCfg2JavaTool());
        if (this.getOutputDirectory() != null) {
            this.getTemplateHelper().putInContext("outputdir", this.getOutputDirectory());
        }
        if (this.getTemplatePath() != null) {
            this.getTemplateHelper().putInContext("template_path", this.getTemplatePath());
        }
        if (this.getProperties() != null) {
            for (Map.Entry<Object, Object> element : this.getProperties().entrySet()) {
                String key = element.getKey().toString();
                Object value = this.transformValue(element.getValue());
                this.getTemplateHelper().putInContext(key, value);
                if (!key.startsWith("hibernatetool.")) continue;
                this.getTemplateHelper().putInContext(key.substring("hibernatetool.".length()), value);
                if (!key.endsWith(".toolclass")) continue;
                try {
                    Class toolClass = ReflectHelper.classForName((String)value.toString(), this.getClass());
                    Object object = toolClass.newInstance();
                    this.getTemplateHelper().putInContext(key.substring("hibernatetool.".length(), key.length() - ".toolclass".length()), object);
                }
                catch (Exception e) {
                    throw new ExporterException("Exception when instantiating tool " + element.getKey() + " with " + value, e);
                }
            }
        }
        this.getTemplateHelper().putInContext("artifacts", this.collector);
        if (this.getMetadata() != null) {
            this.getTemplateHelper().putInContext("md", this.metadata);
            this.getTemplateHelper().putInContext("props", this.getProperties());
            this.getTemplateHelper().putInContext("tables", this.metadata.collectTableMappings());
        }
    }

    protected void setupTemplates() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getClass().getName() + " outputdir:" + this.getOutputDirectory() + " path: " + this.toString(this.templatePaths)));
        }
        this.getTemplateHelper().init(this.getOutputDirectory(), this.templatePaths);
    }

    protected void setTemplateHelper(TemplateHelper vh) {
        this.vh = vh;
    }

    protected TemplateHelper getTemplateHelper() {
        return this.vh;
    }

    protected File getFileForClassName(File baseDir, String className, String extension) {
        String filename = StringHelper.unqualify((String)className) + extension;
        String packagename = StringHelper.qualifier((String)className);
        return new File(this.getDirForPackage(baseDir, packagename), filename);
    }

    protected Metadata buildMetadata() {
        return this.metadataDescriptor.createMetadata();
    }

    private File getDirForPackage(File baseDir, String packageName) {
        String p = packageName == null ? "" : packageName;
        return new File(baseDir, p.replace('.', File.separatorChar));
    }

    private String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            buf.append(String.valueOf(a[i]));
        }
        buf.append("]");
        return buf.toString();
    }

    private Object transformValue(Object value) {
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        return value;
    }
}

