/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.Iterator;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.cfg.reveng.AbstractDatabaseCollector;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.mapping.Table;

public class MappingsDatabaseCollector
extends AbstractDatabaseCollector {
    private final InFlightMetadataCollector metadataCollector;

    public MappingsDatabaseCollector(InFlightMetadataCollector metadataCollector, MetaDataDialect metaDataDialect) {
        super(metaDataDialect);
        this.metadataCollector = metadataCollector;
    }

    @Override
    public Iterator<Table> iterateTables() {
        return this.metadataCollector.collectTableMappings().iterator();
    }

    @Override
    public Table addTable(String schema, String catalog, String name) {
        return this.metadataCollector.addTable(this.quote(schema), this.quote(catalog), this.quote(name), null, false);
    }

    @Override
    public Table getTable(String schema, String catalog, String name) {
        for (Table table : this.metadataCollector.collectTableMappings()) {
            if (!this.equalOrBothNull(schema, table.getSchema()) || !this.equalOrBothNull(catalog, table.getCatalog()) || !this.equalOrBothNull(name, table.getName())) continue;
            return table;
        }
        return null;
    }

    private boolean equalOrBothNull(String left, String right) {
        return left == null && right == null || left != null && left.equals(right);
    }
}

