/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata;

import java.util.Arrays;
import java.util.List;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataImpl;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.SoftLimitMRUCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataManager {
    public static final int DEFAULT_HARD_REF_LIMIT = 64;
    public static final int DEFAULT_SOFT_REF_LIMIT = 1024;
    private final List<MetaDataProvider> metaDataProviders;
    private final ConstraintHelper constraintHelper;
    private final SoftLimitMRUCache<Class<?>, BeanMetaData<?>> beanMetaDataCache;

    public BeanMetaDataManager(ConstraintHelper constraintHelper, MetaDataProvider ... metaDataProviders) {
        this(constraintHelper, Arrays.asList(metaDataProviders));
    }

    public BeanMetaDataManager(ConstraintHelper constraintHelper, List<MetaDataProvider> optionalMetaDataProviders) {
        this(constraintHelper, optionalMetaDataProviders, 64, 1024);
    }

    public BeanMetaDataManager(ConstraintHelper constraintHelper, List<MetaDataProvider> optionalMetaDataProviders, Integer hardRefLimit, Integer softRefLimit) {
        this.constraintHelper = constraintHelper;
        this.metaDataProviders = CollectionHelper.newArrayList();
        this.metaDataProviders.addAll(optionalMetaDataProviders);
        if (hardRefLimit == null) {
            hardRefLimit = 64;
        }
        if (softRefLimit == null) {
            softRefLimit = 1024;
        }
        this.beanMetaDataCache = new SoftLimitMRUCache(hardRefLimit, softRefLimit);
        AnnotationProcessingOptions annotationProcessingOptions = this.getAnnotationProcessingOptionsFromNonDefaultProviders();
        AnnotationMetaDataProvider defaultProvider = new AnnotationMetaDataProvider(constraintHelper, annotationProcessingOptions);
        this.metaDataProviders.add(defaultProvider);
    }

    public <T> BeanMetaData<T> getBeanMetaData(Class<T> beanClass) {
        BeanMetaData<?> cachedBeanMetaData;
        BeanMetaData<?> beanMetaData = this.beanMetaDataCache.get(beanClass);
        if (beanMetaData == null && (cachedBeanMetaData = this.beanMetaDataCache.put(beanClass, beanMetaData = this.createBeanMetaData(beanClass))) != null) {
            beanMetaData = cachedBeanMetaData;
        }
        return beanMetaData;
    }

    public int numberOfCachedBeanMetaDataInstances() {
        return this.beanMetaDataCache.softSize();
    }

    private <T> BeanMetaDataImpl<T> createBeanMetaData(Class<T> clazz) {
        BeanMetaDataImpl.BeanMetaDataBuilder<T> builder = BeanMetaDataImpl.BeanMetaDataBuilder.getInstance(this.constraintHelper, clazz);
        for (MetaDataProvider provider : this.metaDataProviders) {
            for (BeanConfiguration<T> beanConfiguration : provider.getBeanConfigurationForHierarchy(clazz)) {
                builder.add(beanConfiguration);
            }
        }
        return builder.build();
    }

    private AnnotationProcessingOptions getAnnotationProcessingOptionsFromNonDefaultProviders() {
        AnnotationProcessingOptions options = new AnnotationProcessingOptions();
        for (MetaDataProvider metaDataProvider : this.metaDataProviders) {
            options.merge(metaDataProvider.getAnnotationProcessingOptions());
        }
        return options;
    }
}

