/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.location;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodConstraintLocation
implements ConstraintLocation {
    private final Method method;
    private final Integer parameterIndex;

    public MethodConstraintLocation(Method method) {
        Contracts.assertNotNull(method, Messages.MESSAGES.mustNotBeNull("Method"));
        this.method = method;
        this.parameterIndex = null;
    }

    public MethodConstraintLocation(Method method, int parameterIndex) {
        Contracts.assertNotNull(method, Messages.MESSAGES.mustNotBeNull("Method"));
        this.method = method;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.method.getDeclaringClass();
    }

    @Override
    public Type typeOfAnnotatedElement() {
        Type t = this.parameterIndex == null ? ReflectionHelper.typeOf(this.method) : ReflectionHelper.typeOf(this.method, this.parameterIndex);
        if (t instanceof Class && ((Class)t).isPrimitive()) {
            t = ReflectionHelper.boxedType(t);
        }
        return t;
    }

    @Override
    public Method getMember() {
        return this.method;
    }

    @Override
    public ElementType getElementType() {
        return this.parameterIndex != null ? ElementType.PARAMETER : ElementType.METHOD;
    }

    public Integer getParameterIndex() {
        return this.parameterIndex;
    }

    public Class<?> getParameterType() {
        return this.parameterIndex != null ? this.method.getParameterTypes()[this.parameterIndex] : null;
    }

    public String toString() {
        return String.format("%s#%s(%s)", this.method.getDeclaringClass().getSimpleName(), this.method.getName(), this.parameterIndex != null ? this.parameterIndex : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.parameterIndex == null ? 0 : this.parameterIndex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodConstraintLocation other = (MethodConstraintLocation)obj;
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        return !(this.parameterIndex == null ? other.parameterIndex != null : !this.parameterIndex.equals(other.parameterIndex));
    }
}

