/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import java.io.InputStream;
import java.util.Properties;
import javax.validation.ValidatorFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;

public abstract class HibernateTestCase {
    private SessionFactory sessionFactory;
    private Configuration cfg;

    @BeforeTest
    protected void setUp() throws Exception {
        this.buildSessionFactory(this.getAnnotatedClasses(), this.getAnnotatedPackages(), this.getXmlFiles());
    }

    @AfterTest
    protected void tearDown() throws Exception {
        SchemaExport export = new SchemaExport(this.cfg);
        export.drop(false, true);
        this.sessionFactory = null;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private void buildSessionFactory(Class<?>[] classes, String[] packages, String[] xmlFiles) throws Exception {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
        try {
            this.setCfg((Configuration)new AnnotationConfiguration());
            this.configure(this.cfg);
            if (this.recreateSchema()) {
                this.cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
            }
            for (String aPackage : packages) {
                ((AnnotationConfiguration)this.getCfg()).addPackage(aPackage);
            }
            for (Class<?> aClass : classes) {
                ((AnnotationConfiguration)this.getCfg()).addAnnotatedClass((Class)aClass);
            }
            for (String xmlFile : xmlFiles) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
                this.getCfg().addInputStream(is);
            }
            this.sessionFactory = this.getCfg().buildSessionFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void configure(Configuration cfg) {
        Properties prop = cfg.getProperties();
        prop.put("javax.persistence.validation.factory", this.getValidatorFactory());
        prop.put("hibernate.current_session_context_class", "thread");
    }

    protected abstract ValidatorFactory getValidatorFactory();

    protected abstract Class<?>[] getAnnotatedClasses();

    protected String[] getAnnotatedPackages() {
        return new String[0];
    }

    protected String[] getXmlFiles() {
        return new String[0];
    }

    protected boolean recreateSchema() {
        return true;
    }

    protected void setCfg(Configuration cfg) {
        this.cfg = cfg;
    }

    protected Configuration getCfg() {
        return this.cfg;
    }
}

