/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.descriptor;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.OverridesAttribute;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.ValidationException;
import javax.validation.constraintvalidation.ValidationTarget;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraints.CompositionType;
import org.hibernate.validator.constraints.ConstraintComposition;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetAnnotationParameter;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethods;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;

public class ConstraintDescriptorImpl<T extends Annotation>
implements ConstraintDescriptor<T>,
Serializable {
    private static final long serialVersionUID = -2563102960314069246L;
    private static final Log log = LoggerFactory.make();
    private static final int OVERRIDES_PARAMETER_DEFAULT_INDEX = -1;
    private static final List<String> NON_COMPOSING_CONSTRAINT_ANNOTATIONS = Arrays.asList(Documented.class.getName(), Retention.class.getName(), Target.class.getName(), Constraint.class.getName(), ReportAsSingleViolation.class.getName());
    private final T annotation;
    private final Class<T> annotationType;
    private final List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorClasses;
    private final List<Class<? extends ConstraintValidator<T, ?>>> matchingConstraintValidatorClasses;
    private final Set<Class<?>> groups;
    private final Map<String, Object> attributes;
    private final Set<Class<? extends Payload>> payloads;
    private final Set<ConstraintDescriptorImpl<?>> composingConstraints;
    private final boolean isReportAsSingleInvalidConstraint;
    private final ElementType elementType;
    private final ConstraintOrigin definedOn;
    private final ConstraintType constraintType;
    private final CompositionType compositionType;
    private final int hashCode;

    public ConstraintDescriptorImpl(ConstraintHelper constraintHelper, Member member, T annotation, ElementType type, Class<?> implicitGroup, ConstraintOrigin definedOn, ConstraintType externalConstraintType) {
        this.annotation = annotation;
        this.annotationType = this.annotation.annotationType();
        this.elementType = type;
        this.definedOn = definedOn;
        this.isReportAsSingleInvalidConstraint = this.annotationType.isAnnotationPresent(ReportAsSingleViolation.class);
        this.attributes = this.buildAnnotationParameterMap((Annotation)annotation);
        this.groups = this.buildGroupSet(implicitGroup);
        this.payloads = this.buildPayloadSet(annotation);
        this.constraintValidatorClasses = constraintHelper.getAllValidatorClasses(this.annotationType);
        List<Class<ConstraintValidator<T, ?>>> crossParameterValidatorClasses = constraintHelper.findValidatorClasses(this.annotationType, ValidationTarget.PARAMETERS);
        List<Class<ConstraintValidator<T, ?>>> genericValidatorClasses = constraintHelper.findValidatorClasses(this.annotationType, ValidationTarget.ANNOTATED_ELEMENT);
        if (crossParameterValidatorClasses.size() > 1) {
            throw log.getMultipleCrossParameterValidatorClassesException(this.annotationType.getName());
        }
        this.constraintType = this.determineConstraintType(member, type, !genericValidatorClasses.isEmpty(), !crossParameterValidatorClasses.isEmpty(), externalConstraintType);
        this.composingConstraints = this.parseComposingConstraints(member, constraintHelper, externalConstraintType);
        this.compositionType = this.parseCompositionType(constraintHelper);
        this.validateComposingConstraintTypes();
        this.matchingConstraintValidatorClasses = this.constraintType == ConstraintType.GENERIC ? Collections.unmodifiableList(genericValidatorClasses) : Collections.unmodifiableList(crossParameterValidatorClasses);
        this.hashCode = annotation.hashCode();
    }

    public ConstraintDescriptorImpl(ConstraintHelper constraintHelper, Member member, T annotation, ElementType type) {
        this(constraintHelper, member, annotation, type, null, ConstraintOrigin.DEFINED_LOCALLY, null);
    }

    public ConstraintDescriptorImpl(ConstraintHelper constraintHelper, Member member, T annotation, ElementType type, ConstraintType constraintType) {
        this(constraintHelper, member, annotation, type, null, ConstraintOrigin.DEFINED_LOCALLY, constraintType);
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public Class<T> getAnnotationType() {
        return this.annotationType;
    }

    public String getMessageTemplate() {
        return (String)this.getAttributes().get("message");
    }

    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    public Set<Class<? extends Payload>> getPayload() {
        return this.payloads;
    }

    public ConstraintTarget getValidationAppliesTo() {
        return (ConstraintTarget)this.attributes.get("validationAppliesTo");
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return this.constraintValidatorClasses;
    }

    public List<Class<? extends ConstraintValidator<T, ?>>> getMatchingConstraintValidatorClasses() {
        return this.matchingConstraintValidatorClasses;
    }

    public Map<Type, Class<? extends ConstraintValidator<T, ?>>> getAvailableValidatorTypes() {
        Map<Type, Class<? extends ConstraintValidator<T, ?>>> availableValidatorTypes = TypeHelper.getValidatorsTypes(this.getAnnotationType(), this.getMatchingConstraintValidatorClasses());
        return availableValidatorTypes;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return Collections.unmodifiableSet(this.composingConstraints);
    }

    public Set<ConstraintDescriptorImpl<?>> getComposingConstraintImpls() {
        return this.composingConstraints;
    }

    public boolean isReportAsSingleViolation() {
        return this.isReportAsSingleInvalidConstraint;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ConstraintOrigin getDefinedOn() {
        return this.definedOn;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintDescriptorImpl that = (ConstraintDescriptorImpl)o;
        return !(this.annotation != null ? !this.annotation.equals(that.annotation) : that.annotation != null);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintDescriptorImpl");
        sb.append("{annotation=").append(this.annotationType.getName());
        sb.append(", payloads=").append(this.payloads);
        sb.append(", hasComposingConstraints=").append(this.composingConstraints.isEmpty());
        sb.append(", isReportAsSingleInvalidConstraint=").append(this.isReportAsSingleInvalidConstraint);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", definedOn=").append((Object)this.definedOn);
        sb.append(", groups=").append(this.groups);
        sb.append(", attributes=").append(this.attributes);
        sb.append(", constraintType=").append((Object)this.constraintType);
        sb.append('}');
        return sb.toString();
    }

    private ConstraintType determineConstraintType(Member member, ElementType elementType, boolean hasGenericValidators, boolean hasCrossParameterValidator, ConstraintType externalConstraintType) {
        ConstraintType constraintType;
        ConstraintTarget constraintTarget = (ConstraintTarget)this.attributes.get("validationAppliesTo");
        boolean isExecutable = this.isExecutable(elementType);
        if (constraintTarget == ConstraintTarget.RETURN_VALUE) {
            if (!isExecutable) {
                throw log.getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException(this.annotationType.getName(), ConstraintTarget.RETURN_VALUE);
            }
            constraintType = ConstraintType.GENERIC;
        } else if (constraintTarget == ConstraintTarget.PARAMETERS) {
            if (!isExecutable) {
                throw log.getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException(this.annotationType.getName(), ConstraintTarget.PARAMETERS);
            }
            constraintType = ConstraintType.CROSS_PARAMETER;
        } else if (externalConstraintType != null) {
            constraintType = externalConstraintType;
        } else if (hasGenericValidators && !hasCrossParameterValidator) {
            constraintType = ConstraintType.GENERIC;
        } else if (!hasGenericValidators && hasCrossParameterValidator) {
            constraintType = ConstraintType.CROSS_PARAMETER;
        } else if (!isExecutable) {
            constraintType = ConstraintType.GENERIC;
        } else {
            boolean hasParameters = this.hasParameters(member);
            boolean hasReturnValue = this.hasReturnValue(member);
            if (!hasParameters && hasReturnValue) {
                constraintType = ConstraintType.GENERIC;
            } else if (hasParameters && !hasReturnValue) {
                constraintType = ConstraintType.CROSS_PARAMETER;
            } else {
                throw log.getImplicitConstraintTargetInAmbiguousConfigurationException(this.annotationType.getName());
            }
        }
        if (constraintType == ConstraintType.CROSS_PARAMETER) {
            this.validateCrossParameterConstraintType(member, hasCrossParameterValidator);
        }
        return constraintType;
    }

    private void validateCrossParameterConstraintType(Member member, boolean hasCrossParameterValidator) {
        if (!hasCrossParameterValidator) {
            throw log.getCrossParameterConstraintHasNoValidatorException(this.annotationType.getName());
        }
        if (member == null) {
            throw log.getCrossParameterConstraintOnClassException(this.annotationType.getName());
        }
        if (member instanceof Field) {
            throw log.getCrossParameterConstraintOnFieldException(this.annotationType.getName(), member.toString());
        }
        if (!this.hasParameters(member)) {
            throw log.getCrossParameterConstraintOnMethodWithoutParametersException(this.annotationType.getName(), member.toString());
        }
    }

    private void validateComposingConstraintTypes() {
        for (ConstraintDescriptorImpl<?> composingConstraint : this.composingConstraints) {
            if (composingConstraint.constraintType == this.constraintType) continue;
            throw log.getComposedAndComposingConstraintsHaveDifferentTypesException(this.annotationType.getName(), composingConstraint.annotationType.getName(), this.constraintType, composingConstraint.constraintType);
        }
    }

    private boolean hasParameters(Member member) {
        boolean hasParameters = false;
        if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            hasParameters = constructor.getParameterTypes().length > 0;
        } else if (member instanceof Method) {
            Method method = (Method)member;
            hasParameters = method.getParameterTypes().length > 0;
        }
        return hasParameters;
    }

    private boolean hasReturnValue(Member member) {
        Method method;
        boolean hasReturnValue = member instanceof Constructor ? true : (member instanceof Method ? (method = (Method)member).getGenericReturnType() != Void.TYPE : false);
        return hasReturnValue;
    }

    private boolean isExecutable(ElementType elementType) {
        return elementType == ElementType.METHOD || elementType == ElementType.CONSTRUCTOR;
    }

    private Set<Class<? extends Payload>> buildPayloadSet(T annotation) {
        Class[] payloadFromAnnotation;
        HashSet payloadSet = CollectionHelper.newHashSet();
        try {
            payloadFromAnnotation = this.run(GetAnnotationParameter.action(annotation, "payload", Class[].class));
        }
        catch (ValidationException e) {
            payloadFromAnnotation = null;
        }
        if (payloadFromAnnotation != null) {
            payloadSet.addAll(Arrays.asList(payloadFromAnnotation));
        }
        return Collections.unmodifiableSet(payloadSet);
    }

    private Set<Class<?>> buildGroupSet(Class<?> implicitGroup) {
        HashSet groupSet = CollectionHelper.newHashSet();
        Class[] groupsFromAnnotation = this.run(GetAnnotationParameter.action(this.annotation, "groups", Class[].class));
        if (groupsFromAnnotation.length == 0) {
            groupSet.add(Default.class);
        } else {
            groupSet.addAll(Arrays.asList(groupsFromAnnotation));
        }
        if (implicitGroup != null && groupSet.contains(Default.class)) {
            groupSet.add(implicitGroup);
        }
        return Collections.unmodifiableSet(groupSet);
    }

    private Map<String, Object> buildAnnotationParameterMap(Annotation annotation) {
        Method[] declaredMethods = this.run(GetDeclaredMethods.action(annotation.annotationType()));
        HashMap<String, Object> parameters = CollectionHelper.newHashMap(declaredMethods.length);
        for (Method m : declaredMethods) {
            Object value = this.run(GetAnnotationParameter.action(annotation, m.getName(), Object.class));
            parameters.put(m.getName(), value);
        }
        return Collections.unmodifiableMap(parameters);
    }

    private Map<ClassIndexWrapper, Map<String, Object>> parseOverrideParameters() {
        Method[] methods;
        HashMap<ClassIndexWrapper, Map<String, Object>> overrideParameters = CollectionHelper.newHashMap();
        for (Method m : methods = this.run(GetDeclaredMethods.action(this.annotationType))) {
            if (m.getAnnotation(OverridesAttribute.class) != null) {
                this.addOverrideAttributes(overrideParameters, m, m.getAnnotation(OverridesAttribute.class));
                continue;
            }
            if (m.getAnnotation(OverridesAttribute.List.class) == null) continue;
            this.addOverrideAttributes(overrideParameters, m, m.getAnnotation(OverridesAttribute.List.class).value());
        }
        return overrideParameters;
    }

    private void addOverrideAttributes(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, Method m, OverridesAttribute ... attributes) {
        Object value = this.run(GetAnnotationParameter.action(this.annotation, m.getName(), Object.class));
        for (OverridesAttribute overridesAttribute : attributes) {
            this.ensureAttributeIsOverridable(m, overridesAttribute);
            ClassIndexWrapper wrapper = new ClassIndexWrapper(overridesAttribute.constraint(), overridesAttribute.constraintIndex());
            Map<String, Object> map = overrideParameters.get(wrapper);
            if (map == null) {
                map = CollectionHelper.newHashMap();
                overrideParameters.put(wrapper, map);
            }
            map.put(overridesAttribute.name(), value);
        }
    }

    private void ensureAttributeIsOverridable(Method m, OverridesAttribute overridesAttribute) {
        Method method = this.run(GetMethod.action(overridesAttribute.constraint(), overridesAttribute.name()));
        if (method == null) {
            throw log.getOverriddenConstraintAttributeNotFoundException(overridesAttribute.name());
        }
        Class<?> returnTypeOfOverriddenConstraint = method.getReturnType();
        if (!returnTypeOfOverriddenConstraint.equals(m.getReturnType())) {
            throw log.getWrongAttributeTypeForOverriddenConstraintException(returnTypeOfOverriddenConstraint.getName(), m.getReturnType());
        }
    }

    private Set<ConstraintDescriptorImpl<?>> parseComposingConstraints(Member member, ConstraintHelper constraintHelper, ConstraintType externalConstraintType) {
        HashSet composingConstraintsSet = CollectionHelper.newHashSet();
        Map<ClassIndexWrapper, Map<String, Object>> overrideParameters = this.parseOverrideParameters();
        for (Annotation declaredAnnotation : this.annotationType.getDeclaredAnnotations()) {
            Class<? extends Annotation> declaredAnnotationType = declaredAnnotation.annotationType();
            if (NON_COMPOSING_CONSTRAINT_ANNOTATIONS.contains(declaredAnnotationType.getName())) continue;
            if (constraintHelper.isConstraintAnnotation(declaredAnnotationType)) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(member, overrideParameters, -1, declaredAnnotation, externalConstraintType, constraintHelper);
                composingConstraintsSet.add(descriptor);
                log.debugf("Adding composing constraint: %s.", descriptor);
                continue;
            }
            if (!constraintHelper.isMultiValueConstraint(declaredAnnotationType)) continue;
            List<Annotation> multiValueConstraints = constraintHelper.getConstraintsFromMultiValueConstraint(declaredAnnotation);
            int index = 0;
            for (Annotation constraintAnnotation : multiValueConstraints) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(member, overrideParameters, index, constraintAnnotation, externalConstraintType, constraintHelper);
                composingConstraintsSet.add(descriptor);
                log.debugf("Adding composing constraint: %s.", descriptor);
                ++index;
            }
        }
        return Collections.unmodifiableSet(composingConstraintsSet);
    }

    private CompositionType parseCompositionType(ConstraintHelper constraintHelper) {
        for (Annotation declaredAnnotation : this.annotationType.getDeclaredAnnotations()) {
            Class<? extends Annotation> declaredAnnotationType = declaredAnnotation.annotationType();
            if (NON_COMPOSING_CONSTRAINT_ANNOTATIONS.contains(declaredAnnotationType.getName()) || !constraintHelper.isConstraintComposition(declaredAnnotationType)) continue;
            if (log.isDebugEnabled()) {
                log.debugf("Adding Bool %s.", declaredAnnotationType.getName());
            }
            return ((ConstraintComposition)declaredAnnotation).value();
        }
        return CompositionType.AND;
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(Member member, Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, int index, U constraintAnnotation, ConstraintType externalConstraintType, ConstraintHelper constraintHelper) {
        Class<? extends Annotation> annotationType = constraintAnnotation.annotationType();
        AnnotationDescriptor<? extends Annotation> annotationDescriptor = new AnnotationDescriptor<Annotation>(annotationType, this.buildAnnotationParameterMap(constraintAnnotation));
        Map<String, Object> overrides = overrideParameters.get(new ClassIndexWrapper(annotationType, index));
        if (overrides != null) {
            for (Map.Entry<String, Object> entry : overrides.entrySet()) {
                annotationDescriptor.setValue(entry.getKey(), entry.getValue());
            }
        }
        annotationDescriptor.setValue("groups", this.groups.toArray(new Class[this.groups.size()]));
        annotationDescriptor.setValue("payload", this.payloads.toArray(new Class[this.payloads.size()]));
        if (annotationDescriptor.getElements().containsKey("validationAppliesTo")) {
            annotationDescriptor.setValue("validationAppliesTo", this.getValidationAppliesTo());
        }
        Annotation annotationProxy = AnnotationFactory.create(annotationDescriptor);
        return new ConstraintDescriptorImpl<Annotation>(constraintHelper, member, annotationProxy, this.elementType, null, this.definedOn, externalConstraintType);
    }

    private <P> P run(PrivilegedAction<P> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    public CompositionType getCompositionType() {
        return this.compositionType;
    }

    public static enum ConstraintType {
        GENERIC,
        CROSS_PARAMETER;

    }

    private class ClassIndexWrapper {
        final Class<?> clazz;
        final int index;

        ClassIndexWrapper(Class<?> clazz, int index) {
            this.clazz = clazz;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassIndexWrapper that = (ClassIndexWrapper)o;
            if (this.index != that.index) {
                return false;
            }
            if (this.clazz != null && !this.clazz.equals(that.clazz)) {
                return false;
            }
            return this.clazz != null || that.clazz == null;
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + this.index;
            return result;
        }
    }
}

