/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class DiskUsage
implements Serializable {
    private static final long serialVersionUID = 7887L;
    long reads = 0L;
    long writes = 0L;
    long readBytes = 0L;
    long writeBytes = 0L;
    long queue = 0L;
    double serviceTime = 0.0;

    public native void gather(Sigar var1, String var2) throws SigarException;

    static DiskUsage fetch(Sigar sigar, String name) throws SigarException {
        DiskUsage diskUsage = new DiskUsage();
        diskUsage.gather(sigar, name);
        return diskUsage;
    }

    public long getReads() {
        return this.reads;
    }

    public long getWrites() {
        return this.writes;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getWriteBytes() {
        return this.writeBytes;
    }

    public long getQueue() {
        return this.queue;
    }

    public double getServiceTime() {
        return this.serviceTime;
    }

    void copyTo(DiskUsage copy) {
        copy.reads = this.reads;
        copy.writes = this.writes;
        copy.readBytes = this.readBytes;
        copy.writeBytes = this.writeBytes;
        copy.queue = this.queue;
        copy.serviceTime = this.serviceTime;
    }

    public Map toMap() {
        String strserviceTime;
        String strqueue;
        String strwriteBytes;
        String strreadBytes;
        String strwrites;
        HashMap<String, String> map = new HashMap<String, String>();
        String strreads = String.valueOf(this.reads);
        if (!"-1".equals(strreads)) {
            map.put("Reads", strreads);
        }
        if (!"-1".equals(strwrites = String.valueOf(this.writes))) {
            map.put("Writes", strwrites);
        }
        if (!"-1".equals(strreadBytes = String.valueOf(this.readBytes))) {
            map.put("ReadBytes", strreadBytes);
        }
        if (!"-1".equals(strwriteBytes = String.valueOf(this.writeBytes))) {
            map.put("WriteBytes", strwriteBytes);
        }
        if (!"-1".equals(strqueue = String.valueOf(this.queue))) {
            map.put("Queue", strqueue);
        }
        if (!"-1".equals(strserviceTime = String.valueOf(this.serviceTime))) {
            map.put("ServiceTime", strserviceTime);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

