/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;
import org.hyperic.sigar.SigarLog;
import org.hyperic.sigar.SudoFileInputStream;

public abstract class FileTail
extends FileWatcher {
    public static final String PROP_USE_SUDO = "sigar.tail.sudo";
    private boolean useSudo = "true".equals(System.getProperty("sigar.tail.sudo"));
    private static final Logger log = SigarLog.getLogger((class$org$hyperic$sigar$FileTail == null ? (class$org$hyperic$sigar$FileTail = FileTail.class$("org.hyperic.sigar.FileTail")) : class$org$hyperic$sigar$FileTail).getName());
    private static final boolean isDebug = log.isDebugEnabled();
    static /* synthetic */ Class class$org$hyperic$sigar$FileTail;

    public abstract void tail(FileInfo var1, Reader var2);

    public FileTail(Sigar sigar) {
        super(sigar);
    }

    public void useSudo(boolean useSudo) {
        this.useSudo = useSudo;
    }

    static void error(String name, Throwable exc) {
        String msg = name + ": " + exc.getMessage();
        log.error((Object)msg, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onChange(FileInfo info) {
        InputStreamReader reader = null;
        String name = info.getName();
        reader = this.useSudo ? new InputStreamReader(new SudoFileInputStream(name)) : new FileReader(name);
        long offset = this.getOffset(info);
        if (offset > 0L) {
            reader.skip(offset);
        }
        this.tail(info, reader);
        Object var7_6 = null;
        if (reader == null) return;
        try {
            ((Reader)reader).close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                FileTail.error(name, e);
                Object var7_7 = null;
                if (reader == null) return;
                try {
                    ((Reader)reader).close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (reader == null) throw throwable;
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public FileInfo add(String file) throws SigarException {
        FileInfo info = super.add(file);
        if (isDebug) {
            log.debug((Object)("add: " + file + "=" + info));
        }
        return info;
    }

    protected boolean changed(FileInfo info) throws SigarException, SigarFileNotFoundException {
        return info.modified() || info.getPreviousInfo().size != info.size;
    }

    private long getOffset(FileInfo current) {
        FileInfo previous = current.getPreviousInfo();
        if (previous == null) {
            if (isDebug) {
                log.debug((Object)(current.getName() + ": first stat"));
            }
            return current.size;
        }
        if (current.inode != previous.inode) {
            if (isDebug) {
                log.debug((Object)(current.getName() + ": file inode changed"));
            }
            return -1L;
        }
        if (current.size < previous.size) {
            if (isDebug) {
                log.debug((Object)(current.getName() + ": file truncated"));
            }
            return -1L;
        }
        if (isDebug) {
            long diff = current.size - previous.size;
            log.debug((Object)(current.getName() + ": " + diff + " new bytes"));
        }
        return previous.size;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

